/*
 * Decompiled with CFR 0.152.
 */
package com.github.vanroy.springdata.jest.internal;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.client.JestResult;
import io.searchbox.cloning.CloneUtils;
import io.searchbox.core.SearchResult;
import java.util.List;
import java.util.Map;

public class ExtendedSearchResult
extends SearchResult {
    public ExtendedSearchResult(SearchResult searchResult) {
        super(searchResult);
    }

    public ExtendedSearchResult(Gson gson) {
        super(gson);
    }

    public String getScrollId() {
        return this.getJsonObject().get("_scroll_id").getAsString();
    }

    protected <T, K> SearchResult.Hit<T, K> extractHit(Class<T> sourceType, Class<K> explanationType, JsonElement hitElement, String sourceKey) {
        SearchResult.Hit hit = null;
        if (hitElement.isJsonObject()) {
            JsonObject hitObject = hitElement.getAsJsonObject();
            String id = hitObject.get("_id").getAsString();
            String index = hitObject.get("_index").getAsString();
            String type = hitObject.get("_type").getAsString();
            Double score = null;
            if (hitObject.has("_score") && !hitObject.get("_score").isJsonNull()) {
                score = hitObject.get("_score").getAsDouble();
            }
            JsonElement explanation = hitObject.get("_explanation");
            Map highlight = this.extractHighlight(hitObject.getAsJsonObject("highlight"));
            List sort = this.extractSort(hitObject.getAsJsonArray("sort"));
            JsonObject source = hitObject.getAsJsonObject(sourceKey);
            if (source == null) {
                source = new JsonObject();
            }
            JsonObject clonedSource = null;
            for (JestResult.MetaField metaField : META_FIELDS) {
                JsonElement metaElement = hitObject.get(metaField.esFieldName);
                if (metaElement == null) continue;
                if (clonedSource == null) {
                    clonedSource = (JsonObject)CloneUtils.deepClone((JsonElement)source);
                }
                clonedSource.add(metaField.internalFieldName, metaElement);
            }
            if (clonedSource != null) {
                source = clonedSource;
            }
            hit = new SearchResult.Hit((SearchResult)this, sourceType, (JsonElement)source, explanationType, explanation, highlight, sort, index, type, id, score);
        }
        return hit;
    }
}

