/*
 * Decompiled with CFR 0.152.
 */
package com.github.vanroy.springdata.jest.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.client.JestResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SearchScrollResult
extends JestResult {
    public static final String EXPLANATION_KEY = "_explanation";
    public static final String HIGHLIGHT_KEY = "highlight";
    public static final String FIELDS_KEY = "fields";
    public static final String SORT_KEY = "sort";
    public static final String[] PATH_TO_TOTAL = "hits/total".split("/");
    public static final String[] PATH_TO_MAX_SCORE = "hits/max_score".split("/");

    public SearchScrollResult(JestResult source) {
        super(source);
    }

    public <T> List<Hit<T, Void>> getHits(Class<T> sourceType) {
        return this.getHits(sourceType, Void.class);
    }

    public <T, K> List<Hit<T, K>> getHits(Class<T> sourceType, Class<K> explanationType) {
        return this.getHits(sourceType, explanationType, false);
    }

    protected <T, K> List<Hit<T, K>> getHits(Class<T> sourceType, Class<K> explanationType, boolean returnSingle) {
        String[] keys;
        ArrayList<Hit<T, K>> sourceList = new ArrayList<Hit<T, K>>();
        if (this.jsonObject != null && (keys = this.getKeys()) != null) {
            String sourceKey = keys[keys.length - 1];
            JsonElement obj = this.jsonObject.get(keys[0]);
            for (int i = 1; i < keys.length - 1; ++i) {
                obj = ((JsonObject)obj).get(keys[i]);
            }
            if (obj.isJsonObject()) {
                sourceList.add(this.extractHit(sourceType, explanationType, obj, sourceKey));
            } else if (obj.isJsonArray()) {
                for (JsonElement hitElement : obj.getAsJsonArray()) {
                    sourceList.add(this.extractHit(sourceType, explanationType, hitElement, sourceKey));
                    if (!returnSingle) continue;
                    break;
                }
            }
        }
        return sourceList;
    }

    protected <T, K> Hit<T, K> extractHit(Class<T> sourceType, Class<K> explanationType, JsonElement hitElement, String sourceKey) {
        Hit<T, K> hit = null;
        if (hitElement.isJsonObject()) {
            JsonObject hitObject = hitElement.getAsJsonObject();
            JsonElement id = hitObject.get("_id");
            String index = hitObject.get("_index").getAsString();
            String type = hitObject.get("_type").getAsString();
            Double score = null;
            if (hitObject.has("_score") && !hitObject.get("_score").isJsonNull()) {
                score = hitObject.get("_score").getAsDouble();
            }
            JsonElement explanation = hitObject.get(EXPLANATION_KEY);
            Map<String, List<String>> highlight = this.extractJsonObject(hitObject.getAsJsonObject(HIGHLIGHT_KEY));
            Map<String, List<String>> fields = this.extractJsonObject(hitObject.getAsJsonObject(FIELDS_KEY));
            List<String> sort = this.extractSort(hitObject.getAsJsonArray(SORT_KEY));
            JsonObject source = hitObject.getAsJsonObject(sourceKey);
            if (source == null) {
                source = new JsonObject();
            }
            if (id != null) {
                source.add("es_metadata_id", id);
            }
            hit = new Hit<T, K>(sourceType, (JsonElement)source, explanationType, explanation, highlight, fields, sort, index, type, score);
        }
        return hit;
    }

    protected List<String> extractSort(JsonArray sort) {
        if (sort == null) {
            return null;
        }
        ArrayList<String> retval = new ArrayList<String>(sort.size());
        for (JsonElement sortValue : sort) {
            retval.add(sortValue.isJsonNull() ? "" : sortValue.getAsString());
        }
        return retval;
    }

    protected Map<String, List<String>> extractJsonObject(JsonObject highlight) {
        HashMap retval = null;
        if (highlight != null) {
            Set highlightSet = highlight.entrySet();
            retval = new HashMap(highlightSet.size());
            for (Map.Entry entry : highlightSet) {
                ArrayList<String> fragments = new ArrayList<String>();
                for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    fragments.add(element.getAsString());
                }
                retval.put(entry.getKey(), fragments);
            }
        }
        return retval;
    }

    public Integer getTotal() {
        Integer total = null;
        JsonElement obj = this.getPath(PATH_TO_TOTAL);
        if (obj != null) {
            total = obj.getAsInt();
        }
        return total;
    }

    public Float getMaxScore() {
        Float maxScore = null;
        JsonElement obj = this.getPath(PATH_TO_MAX_SCORE);
        if (obj != null) {
            maxScore = Float.valueOf(obj.getAsFloat());
        }
        return maxScore;
    }

    protected JsonElement getPath(String[] path) {
        JsonObject retval = null;
        if (this.jsonObject != null) {
            JsonObject obj = this.jsonObject;
            for (String component : path) {
                if (obj == null) break;
                obj = obj.get(component);
            }
            retval = obj;
        }
        return retval;
    }

    public String getScrollId() {
        return this.jsonObject.get("_scroll_id").getAsString();
    }

    public class Hit<T, K> {
        public final T source;
        public final K explanation;
        public final Map<String, List<String>> highlight;
        public final Map<String, List<String>> fields;
        public final List<String> sort;
        public final String index;
        public final String type;
        public final Double score;

        public Hit(Class<T> sourceType, JsonElement source) {
            this(sourceType, source, null, null);
        }

        public Hit(Class<T> sourceType, JsonElement source, Class<K> explanationType, JsonElement explanation) {
            this(sourceType, source, explanationType, explanation, null, null, null, null, null, null);
        }

        public Hit(Class<T> sourceType, JsonElement source, Class<K> explanationType, JsonElement explanation, Map<String, List<String>> highlight, Map<String, List<String>> fields, List<String> sort, String index, String type, Double score) {
            this.source = source == null ? null : SearchScrollResult.this.createSourceObject(source, sourceType);
            this.explanation = explanation == null ? null : SearchScrollResult.this.createSourceObject(explanation, explanationType);
            this.highlight = highlight;
            this.fields = fields;
            this.sort = sort;
            this.index = index;
            this.type = type;
            this.score = score;
        }

        public Hit(T source) {
            this(source, null, null, null, null, null, null, null);
        }

        public Hit(T source, K explanation) {
            this(source, explanation, null, null, null, null, null, null);
        }

        public Hit(T source, K explanation, Map<String, List<String>> highlight, Map<String, List<String>> fields, List<String> sort, String index, String type, Double score) {
            this.source = source;
            this.explanation = explanation;
            this.highlight = highlight;
            this.fields = fields;
            this.sort = sort;
            this.index = index;
            this.type = type;
            this.score = score;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.source).append(this.explanation).append(this.highlight).append(this.fields).append(this.sort).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Hit rhs = (Hit)obj;
            return new EqualsBuilder().append(this.source, rhs.source).append(this.explanation, rhs.explanation).append(this.highlight, rhs.highlight).append(this.fields, rhs.fields).append(this.sort, rhs.sort).isEquals();
        }
    }
}

