/*
 * Decompiled with CFR 0.152.
 */
package com.github.vanroy.springdata.jest.mapper;

import io.searchbox.core.search.aggregation.ExtendedStatsAggregation;
import io.searchbox.core.search.aggregation.HistogramAggregation;
import io.searchbox.core.search.aggregation.MetricAggregation;
import io.searchbox.core.search.aggregation.RangeAggregation;
import io.searchbox.core.search.aggregation.TermsAggregation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.range.RangeBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.stats.extended.ExtendedStatsBuilder;
import org.springframework.data.elasticsearch.core.facet.FacetResult;
import org.springframework.data.elasticsearch.core.facet.result.HistogramResult;
import org.springframework.data.elasticsearch.core.facet.result.IntervalUnit;
import org.springframework.data.elasticsearch.core.facet.result.Range;
import org.springframework.data.elasticsearch.core.facet.result.RangeResult;
import org.springframework.data.elasticsearch.core.facet.result.StatisticalResult;
import org.springframework.data.elasticsearch.core.facet.result.Term;
import org.springframework.data.elasticsearch.core.facet.result.TermResult;

public class AggregationResultTransformer {
    public static List<FacetResult> parseAggregations(List<AbstractAggregationBuilder> queryAggregations, MetricAggregation aggregationResults) {
        if (Objects.isNull(queryAggregations)) {
            return Collections.emptyList();
        }
        return queryAggregations.stream().map(queryAggregation -> {
            String name = queryAggregation.getName();
            if (queryAggregation instanceof TermsBuilder) {
                return AggregationResultTransformer.parseTerms(aggregationResults.getTermsAggregation(name));
            }
            if (queryAggregation instanceof ExtendedStatsBuilder) {
                return AggregationResultTransformer.parseExtendedStats(aggregationResults.getExtendedStatsAggregation(name));
            }
            if (queryAggregation instanceof HistogramBuilder) {
                return AggregationResultTransformer.parseHistogram(aggregationResults.getHistogramAggregation(name));
            }
            if (queryAggregation instanceof RangeBuilder) {
                return AggregationResultTransformer.parseRange(aggregationResults.getRangeAggregation(name));
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static FacetResult parseTerms(TermsAggregation aggregation) {
        List entries = aggregation.getBuckets().stream().map(entry -> new Term(entry.getKey(), (long)entry.getCount().intValue())).collect(Collectors.toList());
        return !entries.isEmpty() ? new TermResult(aggregation.getName(), entries, 0L, 0L, 0L) : null;
    }

    private static FacetResult parseExtendedStats(ExtendedStatsAggregation stats) {
        return new StatisticalResult(stats.getName(), stats.getCount().longValue(), stats.getMax().doubleValue(), stats.getMin().doubleValue(), stats.getAvg().doubleValue(), stats.getStdDeviation().doubleValue(), stats.getSumOfSquares().doubleValue(), stats.getSum().doubleValue(), stats.getVariance().doubleValue());
    }

    private static FacetResult parseRange(RangeAggregation facet) {
        ArrayList<Range> entries = new ArrayList<Range>();
        for (io.searchbox.core.search.aggregation.Range entry : facet.getBuckets()) {
            entries.add(new Range(entry.getFrom() == Double.NEGATIVE_INFINITY ? null : entry.getFrom(), entry.getTo() == Double.POSITIVE_INFINITY ? null : entry.getTo(), entry.getCount().longValue(), 0.0, 0.0, 0.0, 0.0));
        }
        return new RangeResult(facet.getName(), entries);
    }

    private static FacetResult parseHistogram(HistogramAggregation facet) {
        ArrayList<IntervalUnit> entries = new ArrayList<IntervalUnit>();
        for (HistogramAggregation.Histogram entry : facet.getBuckets()) {
            entries.add(new IntervalUnit(entry.getKey().longValue(), entry.getCount().longValue(), 0L, 0.0, 0.0, 0.0, 0.0));
        }
        return new HistogramResult(facet.getName(), entries);
    }
}

