/*
 * Decompiled with CFR 0.152.
 */
package com.github.vanroy.springdata.jest.mapper;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.github.vanroy.springdata.jest.aggregation.AggregatedPage;
import com.github.vanroy.springdata.jest.aggregation.impl.AggregatedPageImpl;
import com.github.vanroy.springdata.jest.internal.MultiDocumentResult;
import com.github.vanroy.springdata.jest.internal.SearchScrollResult;
import com.github.vanroy.springdata.jest.mapper.AggregationResultTransformer;
import com.github.vanroy.springdata.jest.mapper.JestResultsMapper;
import com.google.gson.JsonObject;
import io.searchbox.core.DocumentResult;
import io.searchbox.core.SearchResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.ElasticsearchException;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.core.DefaultEntityMapper;
import org.springframework.data.elasticsearch.core.EntityMapper;
import org.springframework.data.elasticsearch.core.facet.FacetResult;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.util.StringUtils;

public class DefaultJestResultsMapper
implements JestResultsMapper {
    private EntityMapper entityMapper;
    private MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;

    public DefaultJestResultsMapper() {
        this.entityMapper = new DefaultEntityMapper();
    }

    public DefaultJestResultsMapper(EntityMapper entityMapper) {
        this.entityMapper = entityMapper;
    }

    public DefaultJestResultsMapper(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext) {
        this.entityMapper = new DefaultEntityMapper();
        this.mappingContext = mappingContext;
    }

    public DefaultJestResultsMapper(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext, EntityMapper entityMapper) {
        this.entityMapper = entityMapper;
        this.mappingContext = mappingContext;
    }

    @Override
    public EntityMapper getEntityMapper() {
        return this.entityMapper;
    }

    @Override
    public <T> T mapResult(DocumentResult response, Class<T> clazz) {
        T result = this.mapEntity(response.getSourceAsString(), clazz);
        if (result != null) {
            this.setPersistentEntityId(result, response.getId(), clazz);
        }
        return result;
    }

    @Override
    public <T> LinkedList<T> mapResults(MultiDocumentResult multiResponse, Class<T> clazz) {
        LinkedList<T> results = new LinkedList<T>();
        for (MultiDocumentResult.MultiDocumentResultItem item : multiResponse.getItems()) {
            T result = this.mapEntity(item.getSource(), clazz);
            this.setPersistentEntityId(result, item.getId(), clazz);
            results.add(result);
        }
        return results;
    }

    @Override
    public <T> Page<T> mapResults(SearchScrollResult response, Class<T> clazz) {
        LinkedList<T> results = new LinkedList<T>();
        for (SearchScrollResult.Hit<JsonObject, Void> hit : response.getHits(JsonObject.class)) {
            if (hit == null) continue;
            results.add(this.mapSource((JsonObject)hit.source, clazz));
        }
        return new PageImpl(results, null, (long)response.getTotal().intValue());
    }

    @Override
    public <T> AggregatedPage<T> mapResults(SearchResult response, Class<T> clazz, Pageable pageable) {
        return this.mapResults(response, clazz, pageable, null);
    }

    @Override
    public <T> AggregatedPage<T> mapResults(SearchResult response, Class<T> clazz, Pageable pageable, List<AbstractAggregationBuilder> aggregations) {
        LinkedList<T> results = new LinkedList<T>();
        for (SearchResult.Hit hit : response.getHits(JsonObject.class)) {
            if (hit == null) continue;
            results.add(this.mapSource((JsonObject)hit.source, clazz));
        }
        List<FacetResult> facets = AggregationResultTransformer.parseAggregations(aggregations, response.getAggregations());
        return new AggregatedPageImpl(results, pageable, response.getTotal().intValue(), response.getAggregations(), facets);
    }

    private <T> T mapSource(JsonObject source, Class<T> clazz) {
        String sourceString = source.toString();
        T result = null;
        if (!StringUtils.isEmpty((Object)sourceString)) {
            result = this.mapEntity(sourceString, clazz);
            this.setPersistentEntityId(result, source.get("es_metadata_id").getAsString(), clazz);
        }
        return result;
    }

    private <T> T mapEntity(Collection<SearchHitField> values, Class<T> clazz) {
        return this.mapEntity(this.buildJSONFromFields(values), clazz);
    }

    private <T> T mapEntity(String source, Class<T> clazz) {
        if (org.apache.commons.lang.StringUtils.isBlank((String)source)) {
            return null;
        }
        try {
            return (T)this.entityMapper.mapToObject(source, clazz);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to map source [ " + source + "] to class " + clazz.getSimpleName(), (Throwable)e);
        }
    }

    private String buildJSONFromFields(Collection<SearchHitField> values) {
        JsonFactory nodeFactory = new JsonFactory();
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            JsonGenerator generator = nodeFactory.createGenerator((OutputStream)stream, JsonEncoding.UTF8);
            generator.writeStartObject();
            for (SearchHitField value : values) {
                if (value.getValues().size() > 1) {
                    generator.writeArrayFieldStart(value.getName());
                    for (Object val : value.getValues()) {
                        generator.writeObject(val);
                    }
                    generator.writeEndArray();
                    continue;
                }
                generator.writeObjectField(value.getName(), value.getValue());
            }
            generator.writeEndObject();
            generator.flush();
            return new String(stream.toByteArray(), Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            return null;
        }
    }

    private <T> void setPersistentEntityId(T result, String id, Class<T> clazz) {
        Method setter;
        PersistentProperty idProperty;
        if (this.mappingContext != null && clazz.isAnnotationPresent(Document.class) && (idProperty = ((ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(clazz)).getIdProperty()) != null && idProperty.getType().isAssignableFrom(String.class) && (setter = idProperty.getSetter()) != null) {
            try {
                setter.invoke(result, id);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

