/*
 * Decompiled with CFR 0.152.
 */
package com.venky.swf.maven.plugin;

import com.venky.core.collections.IgnoreCaseSet;
import com.venky.core.string.StringUtil;
import com.venky.swf.db.Database;
import com.venky.swf.db.JdbcTypeHelper;
import com.venky.swf.db.annotations.column.COLUMN_NAME;
import com.venky.swf.db.annotations.column.COLUMN_SIZE;
import com.venky.swf.db.annotations.column.DECIMAL_DIGITS;
import com.venky.swf.db.annotations.column.IS_NULLABLE;
import com.venky.swf.db.model.Model;
import com.venky.swf.db.model.reflection.ModelReflector;
import com.venky.swf.db.table.Table;
import com.venky.swf.routing.Config;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelGeneratorMojo
extends AbstractMojo {
    File srcDir;
    String encoding;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Generating models...");
        this.generateModels(this.srcDir);
        this.getLog().info((CharSequence)"Done");
    }

    public void generateModels(File directory) throws MojoExecutionException {
        Database db = Database.getInstance((boolean)false);
        db.loadTables(true);
        for (Table table : db.getTables().values()) {
            this.generateModelClass(table, directory);
        }
    }

    private void generateModelClass(Table<?> table, File directory) throws MojoExecutionException {
        String simpleModelClassName = Table.getSimpleModelClassName((String)table.getTableName());
        String fQModelClassName = null;
        StringBuilder packageName = new StringBuilder((String)Config.instance().getModelPackageRoots().get(0));
        if (packageName.charAt(packageName.length() - 1) == '.') {
            packageName.setLength(packageName.length() - 1);
        }
        if (!(fQModelClassName = packageName.toString()).endsWith(".")) {
            fQModelClassName = fQModelClassName + ".";
        }
        fQModelClassName = fQModelClassName + simpleModelClassName;
        String srcFileName = directory.getPath() + "/" + fQModelClassName.replace('.', '/') + ".java";
        File srcFile = new File(srcFileName);
        if (!table.isExistingInDatabase()) {
            if (srcFile.exists()) {
                this.getLog().info((CharSequence)("Manually remove " + srcFileName + " to drop model"));
            }
        } else {
            if (!srcFile.exists()) {
                OutputStreamWriter wr = null;
                try {
                    wr = new OutputStreamWriter((OutputStream)new FileOutputStream(srcFile), this.encoding);
                    this.writeFile(wr, table, packageName.toString());
                }
                catch (Exception e) {
                    throw new MojoExecutionException(e.getMessage(), e);
                }
                finally {
                    if (wr != null) {
                        try {
                            wr.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            this.getLog().info((CharSequence)("Manually remove " + srcFileName + " to regenerate"));
        }
    }

    private void writeFile(OutputStreamWriter osw, Table<?> table, String packageName) {
        JdbcTypeHelper helper = Database.getInstance().getJdbcTypeHelper();
        IgnoreCaseSet columnsPresentInFrameworkModel = new IgnoreCaseSet();
        columnsPresentInFrameworkModel.addAll(ModelReflector.instance(Model.class).getRealColumns());
        HashSet<String> imports = new HashSet<String>();
        ArrayList<String> code = new ArrayList<String>();
        String extendingClass = null;
        if (table.getModelClass() == null) {
            imports.add("com.venky.swf.db.model.Model");
            extendingClass = "Model";
        } else {
            extendingClass = table.getModelClass().getName();
            if (extendingClass.equals(packageName + "." + Table.getSimpleModelClassName((String)table.getTableName()))) {
                imports.add("com.venky.swf.db.model.Model");
                extendingClass = "Model";
            }
            if (table.getModelClass().getName().startsWith("com.venky.swf.db.model")) {
                columnsPresentInFrameworkModel.addAll(table.getReflector().getRealColumns());
            }
        }
        code.add("public interface " + Table.getSimpleModelClassName((String)table.getTableName()) + " extends " + extendingClass + "{");
        for (Table.ColumnDescriptor cd : table.getColumnDescriptors()) {
            List refs = helper.getTypeRefs(cd.getJDBCType());
            JdbcTypeHelper.TypeRef ref = null;
            Iterator i$ = refs.iterator();
            while (i$.hasNext()) {
                JdbcTypeHelper.TypeRef r;
                ref = r = (JdbcTypeHelper.TypeRef)i$.next();
                if (!(cd.isNullable() ? !r.getJavaClass().isPrimitive() : r.getJavaClass().isPrimitive())) continue;
                break;
            }
            if (columnsPresentInFrameworkModel.contains(cd.getName())) continue;
            String camelfieldName = StringUtil.camelize((String)cd.getName());
            if (ref == null) {
                code.add("\tpublic Unknown get" + camelfieldName + "();");
                code.add("\tpublic void set" + camelfieldName + "(Unknown " + StringUtil.camelize((String)cd.getName(), (boolean)false) + ");");
                continue;
            }
            String getterPrefix = "get";
            if (Boolean.TYPE.isAssignableFrom(ref.getJavaClass()) || Boolean.class.isAssignableFrom(ref.getJavaClass())) {
                getterPrefix = "is";
            }
            if (!ref.getJavaClass().isPrimitive() && !ref.getJavaClass().getPackage().getName().startsWith("java.lang")) {
                imports.add(ref.getJavaClass().getName());
            }
            code.add("\t");
            if (!cd.isNullable()) {
                imports.add(IS_NULLABLE.class.getName());
                code.add("\t@IS_NULLABLE(false)");
            }
            if (cd.getSize() > 0) {
                imports.add(COLUMN_SIZE.class.getName());
                code.add("\t@COLUMN_SIZE(" + cd.getSize() + ")");
            }
            if (cd.getScale() > 0) {
                imports.add(DECIMAL_DIGITS.class.getName());
                code.add("\t@DECIMAL_DIGITS(" + cd.getScale() + ")");
            }
            imports.add(COLUMN_NAME.class.getName());
            code.add("\t@COLUMN_NAME(\"" + cd.getName() + "\")");
            code.add("\tpublic " + ref.getJavaClass().getSimpleName() + " " + getterPrefix + camelfieldName + "();");
            code.add("\tpublic void set" + camelfieldName + "(" + ref.getJavaClass().getSimpleName() + " " + StringUtil.camelize((String)cd.getName(), (boolean)false) + ");");
        }
        code.add("}");
        PrintWriter w = new PrintWriter(osw);
        w.println("package " + packageName + ";");
        for (String imp : imports) {
            w.println("import " + imp + ";");
        }
        for (String line : code) {
            w.println(line);
        }
    }
}

