/*
 * Decompiled with CFR 0.152.
 */
package com.venky.swf.maven.plugin;

import com.venky.core.collections.IgnoreCaseSet;
import com.venky.core.string.StringUtil;
import com.venky.core.util.ObjectUtil;
import com.venky.swf.db.Database;
import com.venky.swf.db.JdbcTypeHelper;
import com.venky.swf.db.annotations.column.COLUMN_DEF;
import com.venky.swf.db.annotations.column.COLUMN_NAME;
import com.venky.swf.db.annotations.column.COLUMN_SIZE;
import com.venky.swf.db.annotations.column.DECIMAL_DIGITS;
import com.venky.swf.db.annotations.column.IS_NULLABLE;
import com.venky.swf.db.annotations.column.defaulting.StandardDefault;
import com.venky.swf.db.annotations.model.DBPOOL;
import com.venky.swf.db.jdbc.ConnectionManager;
import com.venky.swf.db.model.Model;
import com.venky.swf.db.model.reflection.ModelReflector;
import com.venky.swf.db.table.Table;
import com.venky.swf.routing.Config;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(defaultPhase=LifecyclePhase.COMPILE, name="generate-model")
public class ModelGeneratorMojo
extends AbstractMojo {
    @Parameter(property="srcDir", defaultValue="src/main/java")
    File srcDir;
    @Parameter(property="pool", defaultValue="")
    String pool;
    @Parameter(property="tableName", defaultValue="")
    String tableName;
    @Parameter(property="project.build.sourceEncoding", defaultValue="UTF-8")
    String encoding;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Generating models...");
        this.generateModels(this.srcDir);
        this.getLog().info((CharSequence)"Done");
    }

    public void generateModels(File directory) throws MojoExecutionException {
        Database.loadTables((boolean)true);
        if (!ObjectUtil.isVoid((Object)this.pool)) {
            this.generateModelClass(directory, this.pool);
        } else {
            for (String pool : ConnectionManager.instance().getPools()) {
                this.generateModelClass(directory, pool);
            }
        }
        Database.getInstance().getCurrentTransaction().rollback(null);
        Database.getInstance().close();
    }

    private void generateModelClass(File directory, String pool) throws MojoExecutionException {
        for (Table table : Database.getTables((String)pool).values()) {
            this.generateModelClass(table, directory, pool);
        }
    }

    private void generateModelClass(Table<?> table, File directory, String pool) throws MojoExecutionException {
        if (!ObjectUtil.isVoid((Object)this.tableName) && !ObjectUtil.equals((Object)table.getTableName(), (Object)this.tableName)) {
            return;
        }
        String simpleModelClassName = Table.getSimpleModelClassName((String)table.getTableName());
        Object fQModelClassName = null;
        StringBuilder packageName = new StringBuilder((String)Config.instance().getModelPackageRoots().get(0));
        if (packageName.charAt(packageName.length() - 1) == '.') {
            packageName.setLength(packageName.length() - 1);
        }
        if (!((String)(fQModelClassName = packageName.toString())).endsWith(".")) {
            fQModelClassName = (String)fQModelClassName + ".";
        }
        fQModelClassName = (String)fQModelClassName + simpleModelClassName;
        String srcFileName = directory.getPath() + "/" + ((String)fQModelClassName).replace('.', '/') + ".java";
        File srcFile = new File(srcFileName);
        srcFile.getParentFile().mkdirs();
        if (srcFile.exists()) {
            if (!table.isExistingInDatabase() && !table.isVirtual()) {
                this.getLog().info((CharSequence)("Manually remove " + srcFileName + " to drop model"));
            }
        } else if (table.getReflector() == null) {
            OutputStreamWriter wr = null;
            try {
                wr = new OutputStreamWriter((OutputStream)new FileOutputStream(srcFile), this.encoding);
                this.writeFile(wr, table, packageName.toString(), pool);
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
            finally {
                if (wr != null) {
                    try {
                        wr.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void writeFile(OutputStreamWriter osw, Table<?> table, String packageName, String pool) {
        JdbcTypeHelper helper = Database.getJdbcTypeHelper((String)pool);
        IgnoreCaseSet columnsPresentInFrameworkModel = new IgnoreCaseSet();
        columnsPresentInFrameworkModel.addAll(ModelReflector.instance(Model.class).getRealColumns());
        HashSet<String> imports = new HashSet<String>();
        ArrayList<Object> code = new ArrayList<Object>();
        String extendingClass = null;
        if (table.getModelClass() == null) {
            imports.add("com.venky.swf.db.model.Model");
            extendingClass = "Model";
        } else {
            extendingClass = table.getModelClass().getName();
            if (extendingClass.equals(packageName + "." + Table.getSimpleModelClassName((String)table.getTableName()))) {
                imports.add("com.venky.swf.db.model.Model");
                extendingClass = "Model";
            }
            if (!table.getModelClass().getName().startsWith(packageName)) {
                columnsPresentInFrameworkModel.addAll(table.getReflector().getRealColumns());
            }
        }
        if (!ObjectUtil.isVoid((Object)pool)) {
            imports.add(DBPOOL.class.getName());
            code.add("@DBPOOL(\"" + pool + "\")");
        }
        code.add("public interface " + Table.getSimpleModelClassName((String)table.getTableName()) + " extends " + extendingClass + "{");
        for (Table.ColumnDescriptor cd : table.getColumnDescriptors()) {
            String possibleReferredModelName;
            String possibleReferredTableName;
            Table referredTable;
            String columnName;
            List list = helper.getTypeRefs(cd.getJDBCType());
            JdbcTypeHelper.TypeRef ref = null;
            if (list == null) {
                this.getLog().error((CharSequence)("cannot find jdbc type with helper for pool" + pool + " with helper " + helper.getClass().getName()));
                throw new NullPointerException("cannot find jdbc type for column " + cd);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                JdbcTypeHelper.TypeRef r;
                ref = r = (JdbcTypeHelper.TypeRef)iterator.next();
                if (!(cd.isNullable() ? !r.getJavaClass().isPrimitive() : r.getJavaClass().isPrimitive())) continue;
                break;
            }
            if (columnsPresentInFrameworkModel.contains(columnName = cd.getName())) continue;
            String camelfieldName = StringUtil.camelize((String)columnName);
            if (ref == null) {
                code.add("\tpublic Unknown get" + camelfieldName + "();");
                code.add("\tpublic void set" + camelfieldName + "(Unknown " + StringUtil.camelize((String)columnName, (boolean)false) + ");");
                continue;
            }
            String getterPrefix = "get";
            if (Boolean.TYPE.isAssignableFrom(ref.getJavaClass()) || Boolean.class.isAssignableFrom(ref.getJavaClass())) {
                getterPrefix = "is";
            }
            if (!ref.getJavaClass().isPrimitive() && !ref.getJavaClass().getPackage().getName().startsWith("java.lang")) {
                imports.add(ref.getJavaClass().getName());
            }
            code.add("\t");
            if (!cd.isNullable() && !ref.getJavaClass().isPrimitive()) {
                imports.add(IS_NULLABLE.class.getName());
                code.add("\t@IS_NULLABLE(false)");
            }
            if (cd.getSize() > 0 && ref.getSize() > 0 && ref.getSize() != cd.getSize()) {
                imports.add(COLUMN_SIZE.class.getName());
                code.add("\t@COLUMN_SIZE(" + cd.getSize() + ")");
            }
            if (cd.getScale() > 0 && ref.getScale() != cd.getScale()) {
                imports.add(DECIMAL_DIGITS.class.getName());
                code.add("\t@DECIMAL_DIGITS(" + cd.getScale() + ")");
            }
            if (!cd.isNullable() && !ObjectUtil.isVoid((Object)cd.getColumnDefault())) {
                imports.add(COLUMN_DEF.class.getName());
                imports.add(StandardDefault.class.getName());
                code.add("\t" + this.toAppDefaultStr(helper, ref, cd.getColumnDefault()));
            }
            if (!StringUtil.underscorize((String)camelfieldName).equals(columnName.toUpperCase())) {
                imports.add(COLUMN_NAME.class.getName());
                code.add("\t@COLUMN_NAME(\"" + cd.getName().toUpperCase() + "\")");
            }
            code.add("\tpublic " + ref.getJavaClass().getSimpleName() + " " + getterPrefix + camelfieldName + "();");
            code.add("\tpublic void set" + camelfieldName + "(" + ref.getJavaClass().getSimpleName() + " " + StringUtil.camelize((String)columnName, (boolean)false) + ");");
            if (!camelfieldName.endsWith("Id") || (referredTable = Database.getTable((String)(possibleReferredTableName = StringUtil.underscorize((String)StringUtil.pluralize((String)(possibleReferredModelName = camelfieldName.substring(0, camelfieldName.length() - "Id".length()))))))) == null) continue;
            code.add("\tpublic " + possibleReferredModelName + " get" + possibleReferredModelName + "();");
        }
        code.add("}");
        PrintWriter w = new PrintWriter(osw);
        w.println("package " + packageName + ";");
        for (String string : imports) {
            w.println("import " + string + ";");
        }
        for (String string : code) {
            w.println(string);
        }
    }

    private String toAppDefaultStr(JdbcTypeHelper helper, JdbcTypeHelper.TypeRef<?> ref, String dbDefault) {
        if (ObjectUtil.equals((Object)dbDefault, (Object)helper.getCurrentTimeStampKW())) {
            return "@COLUMN_DEF(StandardDefault.CURRENT_TIMESTAMP)";
        }
        if (ObjectUtil.equals((Object)dbDefault, (Object)helper.getCurrentDateKW())) {
            return "@COLUMN_DEF(StandardDefault.CURRENT_DATE)";
        }
        if (dbDefault != null) {
            Class refClass = ref.getJavaClass();
            if (refClass == Boolean.TYPE || refClass == Boolean.class) {
                if (helper.getDefaultKW(ref, (Object)true).equals(dbDefault)) {
                    return "@COLUMN_DEF(StandardDefault.BOOLEAN_TRUE)";
                }
                return "@COLUMN_DEF(StandardDefault.BOOLEAN_FALSE)";
            }
            if (ref.isNumeric()) {
                if (helper.getDefaultKW(ref, (Object)0).equals(dbDefault)) {
                    return "@COLUMN_DEF(StandardDefault.ZERO)";
                }
                if (helper.getDefaultKW(ref, (Object)1).equals(dbDefault)) {
                    return "@COLUMN_DEF(StandardDefault.ONE)";
                }
            }
            if (ref.isColumnDefaultQuoted()) {
                StringTokenizer tok = new StringTokenizer(dbDefault, "'", false);
                return "@COLUMN_DEF(value=StandardDefault.SOME_VALUE,args=\"" + tok.nextToken() + "\")";
            }
            return "@COLUMN_DEF(value=StandardDefault.SOME_VALUE,args=\"" + dbDefault + "\")";
        }
        return "@COLUMN_DEF(value=StandardDefault.NULL)";
    }
}

