/*
 * Decompiled with CFR 0.152.
 */
package com.venky.swf.plugins.bugs.extensions;

import com.venky.core.string.StringUtil;
import com.venky.core.util.ObjectUtil;
import com.venky.swf.db.Database;
import com.venky.swf.db.extensions.AfterModelSaveExtension;
import com.venky.swf.plugins.bugs.db.model.Issue;
import com.venky.swf.plugins.bugs.db.model.Note;
import com.venky.swf.plugins.mail.db.model.User;
import java.io.IOException;
import java.io.Reader;

public class IssueAfterSaveExtension
extends AfterModelSaveExtension<Issue> {
    public void afterSave(Issue model) {
        Note note = (Note)Database.getTable(Note.class).newRecord();
        note.setIssueId(model.getId());
        boolean persist = false;
        String description = null;
        if (!ObjectUtil.isVoid((Object)model.getDescription()) && !ObjectUtil.isVoid((Object)(description = StringUtil.read((Reader)model.getDescription())))) {
            note.setNotes(model.getDescription());
            persist = true;
        }
        try {
            if (!ObjectUtil.isVoid((Object)model.getAttachment()) && model.getAttachment().available() > 0) {
                note.setAttachment(model.getAttachment());
                note.setAttachmentContentName(model.getAttachmentContentName());
                note.setAttachmentContentType(model.getAttachmentContentType());
                persist = true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (persist) {
            note.save();
            User admin = (User)Database.getTable(User.class).get(1);
            if (admin != null && !admin.getUserEmails().isEmpty()) {
                admin.sendMail("Issue: " + model.getId() + " " + model.getTitle(), description == null ? "" : description);
            }
        }
    }

    static {
        IssueAfterSaveExtension.registerExtension((AfterModelSaveExtension)new IssueAfterSaveExtension());
    }
}

