/*
 * Decompiled with CFR 0.152.
 */
package com.venky.swf.plugins.bugs.extensions;

import com.venky.core.string.StringUtil;
import com.venky.core.util.ObjectUtil;
import com.venky.swf.db.Database;
import com.venky.swf.db.extensions.AfterModelSaveExtension;
import com.venky.swf.plugins.bugs.db.model.Issue;
import com.venky.swf.plugins.bugs.db.model.Note;
import com.venky.swf.plugins.mail.db.model.User;
import java.io.IOException;
import java.io.Reader;

public class IssueAfterSaveExtension
extends AfterModelSaveExtension<Issue> {
    public void afterSave(Issue model) {
        Note note = (Note)Database.getTable(Note.class).newRecord();
        note.setIssueId(model.getId());
        boolean persistNote = false;
        String description = null;
        if (!ObjectUtil.isVoid((Object)model.getDescription()) && !ObjectUtil.isVoid((Object)(description = StringUtil.read((Reader)model.getDescription())))) {
            note.setNotes(model.getDescription());
            persistNote = true;
        }
        try {
            if (!ObjectUtil.isVoid((Object)model.getAttachment()) && model.getAttachment().available() > 0) {
                note.setAttachment(model.getAttachment());
                note.setAttachmentContentName(model.getAttachmentContentName());
                note.setAttachmentContentType(model.getAttachmentContentType());
                note.setAttachmentContentSize(model.getAttachmentContentSize());
                persistNote = true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (persistNote) {
            User creator;
            note.save();
            User admin = (User)Database.getTable(User.class).get(1L);
            if (admin != null && !admin.getUserEmails().isEmpty()) {
                String resolution = model.getResolution();
                admin.sendMail("Issue: " + model.getId() + " " + model.getTitle() + (String)(resolution == null ? "" : " (" + resolution + ")"), description == null ? "" : description);
            }
            if (!((creator = (User)model.getCreatorUser()) == null || creator.getUserEmails().isEmpty() || admin != null && admin.getId() == creator.getId())) {
                String resolution = model.getResolution();
                creator.sendMail("Issue: " + model.getId() + " " + model.getTitle() + (String)(resolution == null ? "" : " (" + resolution + ")"), description == null ? "" : description);
            }
        }
    }

    static {
        IssueAfterSaveExtension.registerExtension((AfterModelSaveExtension)new IssueAfterSaveExtension());
    }
}

