/*
 * Decompiled with CFR 0.152.
 */
package com.venky.swf.plugins.calendar.db.model;

import com.venky.core.date.DateUtils;
import com.venky.swf.db.Database;
import com.venky.swf.db.model.Model;
import com.venky.swf.db.table.ModelImpl;
import com.venky.swf.plugins.calendar.db.model.DOW;
import com.venky.swf.plugins.calendar.db.model.SpecialNonWorkDay;
import com.venky.swf.plugins.calendar.db.model.SpecialWorkDay;
import com.venky.swf.plugins.calendar.db.model.WorkCalendar;
import com.venky.swf.plugins.calendar.db.model.WorkDay;
import com.venky.swf.plugins.calendar.db.model.WorkSlot;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class WorkCalendarImpl
extends ModelImpl<WorkCalendar> {
    public WorkCalendarImpl(WorkCalendar proxy) {
        super((Model)proxy);
    }

    private void validateInput(Date date) {
        WorkCalendar wc = (WorkCalendar)this.getProxy();
        if (wc.getStartDate().after(date) || wc.getEndDate().before(date)) {
            throw new IllegalArgumentException("Outside calendar Range");
        }
    }

    public WorkCalendar.DayType getDayType(Date date) {
        return this.isWorking(date) ? WorkCalendar.DayType.WORKING : WorkCalendar.DayType.NON_WORKING;
    }

    public boolean isWorking(Date date) {
        return this.getWorkSlot(date) != null;
    }

    public Date nextWorkingDay(Date after) {
        Date nextDay = DateUtils.addHours((Date)after, (int)24);
        while (!this.isWorking(nextDay)) {
            nextDay = DateUtils.addHours((Date)nextDay, (int)24);
        }
        return nextDay;
    }

    public WorkSlot getSpecialWorkSlot(Date date) {
        WorkCalendar wc = (WorkCalendar)this.getProxy();
        this.validateInput(date);
        for (SpecialWorkDay workDay : wc.getSpecialWorkDays()) {
            Date st = DateUtils.getTimeOfDay((Date)workDay.getDate(), (String)workDay.getWorkSlot().getStartTime());
            Date et = DateUtils.getTimeOfDay((Date)workDay.getDate(), (String)workDay.getWorkSlot().getEndTime());
            if (!workDay.getDate().equals(date) && st.compareTo(date) > 0 || et.compareTo(date) < 0) continue;
            return workDay.getWorkSlot();
        }
        for (SpecialNonWorkDay nonWorkDay : wc.getSpecialNonWorkDays()) {
            if (!DateUtils.getStartOfDay((Date)date).equals(DateUtils.getStartOfDay((Date)nonWorkDay.getDate()))) continue;
            return (WorkSlot)Database.getTable(WorkSlot.class).newRecord();
        }
        if (wc.getParentWorkCalendarId() != null) {
            return wc.getParentWorkCalendar().getSpecialWorkSlot(date);
        }
        return null;
    }

    public WorkSlot getDefaultWorkSlot(Date date) {
        WorkCalendar wc = (WorkCalendar)this.getProxy();
        this.validateInput(date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int iDow = cal.get(7);
        List<WorkDay> workdays = wc.getWorkDays();
        for (WorkDay day : workdays) {
            if (DOW.getDOWNumber(day.getDayOfWeek()) != iDow) continue;
            Date shiftStart = DateUtils.getTimeOfDay((Date)date, (String)day.getWorkSlot().getStartTime());
            Date shiftEnd = DateUtils.getTimeOfDay((Date)date, (String)day.getWorkSlot().getEndTime());
            if (shiftStart.compareTo(date) > 0 && date.getTime() != DateUtils.getStartOfDay((long)date.getTime()) || shiftEnd.compareTo(date) < 0) continue;
            return day.getWorkSlot();
        }
        if (!workdays.isEmpty() || wc.getParentWorkCalendarId() == null) {
            return null;
        }
        return wc.getParentWorkCalendar().getDefaultWorkSlot(date);
    }

    public WorkSlot getWorkSlot(Date date) {
        WorkCalendar wc = (WorkCalendar)this.getProxy();
        this.validateInput(date);
        WorkSlot specialWorkSlot = this.getSpecialWorkSlot(date);
        if (specialWorkSlot != null) {
            if (specialWorkSlot.getRawRecord().isNewRecord()) {
                return null;
            }
            return specialWorkSlot;
        }
        return this.getDefaultWorkSlot(date);
    }
}

