/*
 * Decompiled with CFR 0.152.
 */
package com.venky.swf.plugins.calendar.db.model;

import com.venky.core.date.DateUtils;
import com.venky.swf.db.model.Model;
import com.venky.swf.db.table.ModelImpl;
import com.venky.swf.plugins.calendar.db.model.DOW;
import com.venky.swf.plugins.calendar.db.model.SpecialNonWorkDay;
import com.venky.swf.plugins.calendar.db.model.SpecialWorkDay;
import com.venky.swf.plugins.calendar.db.model.WorkCalendar;
import com.venky.swf.plugins.calendar.db.model.WorkDay;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkCalendarImpl
extends ModelImpl<WorkCalendar> {
    public WorkCalendarImpl(WorkCalendar proxy) {
        super((Model)proxy);
    }

    public WorkCalendar.DayType getSpecialDayType(Date date) {
        this.validateInput(date);
        WorkCalendar wc = (WorkCalendar)this.getProxy();
        WorkCalendar.DayType dayType = null;
        for (SpecialWorkDay sd : wc.getSpecialWorkDays()) {
            Date st = DateUtils.getTimeOfDay((Date)sd.getDate(), (String)sd.getWorkSlot().getStartTime());
            Date et = DateUtils.getTimeOfDay((Date)sd.getDate(), (String)sd.getWorkSlot().getEndTime());
            if (st.compareTo(date) > 0 || et.compareTo(date) < 0) continue;
            dayType = WorkCalendar.DayType.WORKING;
            break;
        }
        if (dayType == null) {
            Date startOfInDate = DateUtils.getStartOfDay((Date)date);
            for (SpecialNonWorkDay sd : wc.getSpecialNonWorkDays()) {
                if (!DateUtils.getStartOfDay((Date)sd.getDate()).equals(startOfInDate)) continue;
                dayType = WorkCalendar.DayType.NON_WORKING;
                break;
            }
        }
        if (dayType != null || wc.getParentWorkCalendarId() == null) {
            return dayType;
        }
        return wc.getParentWorkCalendar().getSpecialDayType(date);
    }

    public WorkCalendar.DayType getDefaultDayType(Date date) {
        this.validateInput(date);
        WorkCalendar wc = (WorkCalendar)this.getProxy();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int iDow = cal.get(7);
        List<WorkDay> workdays = wc.getWorkDays();
        WorkCalendar.DayType dayType = null;
        for (WorkDay day : workdays) {
            if (DOW.getDOWNumber(day.getDayOfWeek()) != iDow) continue;
            Date shiftStart = DateUtils.getTimeOfDay((Date)date, (String)day.getWorkSlot().getStartTime());
            Date shiftEnd = DateUtils.getTimeOfDay((Date)date, (String)day.getWorkSlot().getEndTime());
            if (shiftStart.compareTo(date) > 0 || shiftEnd.compareTo(date) < 0) continue;
            dayType = WorkCalendar.DayType.WORKING;
            break;
        }
        if (dayType == null) {
            dayType = !workdays.isEmpty() || wc.getParentWorkCalendarId() == null ? WorkCalendar.DayType.NON_WORKING : wc.getParentWorkCalendar().getDefaultDayType(date);
        }
        return dayType;
    }

    private void validateInput(Date date) {
        WorkCalendar wc = (WorkCalendar)this.getProxy();
        if (wc.getStartDate().after(date) || wc.getEndDate().before(date)) {
            throw new IllegalArgumentException("Outside calendar Range");
        }
    }

    public WorkCalendar.DayType getDayType(Date date) {
        this.validateInput(date);
        WorkCalendar.DayType type = this.getSpecialDayType(date);
        if (type == null) {
            type = this.getDefaultDayType(date);
        }
        return type;
    }

    public boolean isWorking(Date date) {
        return this.getDayType(date) == WorkCalendar.DayType.WORKING;
    }

    public Date nextWorkingDay(Date after) {
        Date nextDay = DateUtils.addHours((Date)after, (int)24);
        while (!this.isWorking(nextDay)) {
            nextDay = DateUtils.addHours((Date)nextDay, (int)24);
        }
        return nextDay;
    }
}

