/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.agents.catalog;

import com.venky.core.collections.SequenceSet;
import com.venky.swf.plugins.background.core.Task;
import com.venky.swf.plugins.background.core.agent.AgentSeederTask;
import com.venky.swf.plugins.background.core.agent.AgentSeederTaskBuilder;
import com.venky.swf.sql.Select;
import in.succinct.plugins.ecommerce.db.model.inventory.Inventory;
import in.succinct.plugins.ecommerce.db.model.participation.MarketPlaceSkuUpdateQueue;
import in.succinct.plugins.ecommerce.integration.MarketPlace;
import java.util.List;
import java.util.Objects;

public class MarketPlaceCatalogSyncAgent
implements Task,
AgentSeederTaskBuilder {
    private long skuId = -1L;
    private long facilityId = -1L;
    public static final String MARKET_PLACE_CATALOG_SYNC_AGENT = "MARKET_PLACE_CATALOG_SYNC_AGENT";

    public MarketPlaceCatalogSyncAgent() {
    }

    public MarketPlaceCatalogSyncAgent(long skuId, long facilityId) {
        this.skuId = skuId;
        this.facilityId = facilityId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketPlaceCatalogSyncAgent that = (MarketPlaceCatalogSyncAgent)o;
        return this.skuId == that.skuId && this.facilityId == that.facilityId;
    }

    public int hashCode() {
        return Objects.hash(this.skuId, this.facilityId);
    }

    public void execute() {
        MarketPlaceSkuUpdateQueue.entries(this.skuId, this.facilityId).forEach(e -> e.destroy());
        MarketPlace.get(this.facilityId).forEach(mp -> mp.getWarehouseActionHandler().sync(Inventory.find(this.facilityId, this.skuId)));
    }

    public AgentSeederTask createSeederTask() {
        return new AgentSeederTask(){

            public List<Task> getTasks() {
                List list = new Select(new String[0]).from(new Class[]{MarketPlaceSkuUpdateQueue.class}).execute();
                SequenceSet tasks = new SequenceSet();
                for (MarketPlaceSkuUpdateQueue entry : list) {
                    tasks.add((Object)new MarketPlaceCatalogSyncAgent(entry.getSkuId(), entry.getFacilityId()));
                }
                tasks.add((Object)this.getFinishUpTask());
                return tasks;
            }

            public String getAgentName() {
                return MarketPlaceCatalogSyncAgent.MARKET_PLACE_CATALOG_SYNC_AGENT;
            }
        };
    }
}

