/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.agents.inventory;

import com.venky.core.collections.SequenceSet;
import com.venky.swf.db.Database;
import com.venky.swf.plugins.background.core.Task;
import com.venky.swf.plugins.background.core.agent.AgentSeederTask;
import com.venky.swf.plugins.background.core.agent.AgentSeederTaskBuilder;
import com.venky.swf.sql.Select;
import in.succinct.plugins.ecommerce.db.model.inventory.Inventory;
import in.succinct.plugins.ecommerce.db.model.inventory.Sku;
import in.succinct.plugins.ecommerce.db.model.participation.Facility;
import in.succinct.plugins.ecommerce.db.model.participation.MarketPlaceInventoryUpdateQueue;
import in.succinct.plugins.ecommerce.integration.MarketPlace;
import java.util.List;
import java.util.Objects;

public class MarketPlaceInventorySyncAgent
implements Task,
AgentSeederTaskBuilder {
    private long skuId = -1L;
    private long facilityId = -1L;
    public static final String MARKET_PLACE_INVENTORY_SYNC_AGENT = "MARKET_PLACE_INVENTORY_SYNC_AGENT";

    public MarketPlaceInventorySyncAgent() {
    }

    public MarketPlaceInventorySyncAgent(long skuId, long facilityId) {
        this.skuId = skuId;
        this.facilityId = facilityId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketPlaceInventorySyncAgent that = (MarketPlaceInventorySyncAgent)o;
        return this.skuId == that.skuId && this.facilityId == that.facilityId;
    }

    public int hashCode() {
        return Objects.hash(this.skuId, this.facilityId);
    }

    public void execute() {
        MarketPlaceInventoryUpdateQueue.entries(this.skuId, this.facilityId).forEach(e -> e.destroy());
        Sku sku = (Sku)Database.getTable(Sku.class).get(this.skuId);
        Facility facility = (Facility)Database.getTable(Facility.class).get(this.facilityId);
        for (MarketPlace mp : MarketPlace.get(this.facilityId)) {
            mp.getWarehouseActionHandler().sync(Inventory.find(facility, sku));
        }
    }

    public AgentSeederTask createSeederTask() {
        return new AgentSeederTask(){

            public List<Task> getTasks() {
                List list = new Select(new String[0]).from(new Class[]{MarketPlaceInventoryUpdateQueue.class}).execute();
                SequenceSet tasks = new SequenceSet();
                for (MarketPlaceInventoryUpdateQueue entry : list) {
                    tasks.add((Object)new MarketPlaceInventorySyncAgent(entry.getSkuId(), entry.getFacilityId()));
                }
                tasks.add((Object)this.getFinishUpTask());
                return tasks;
            }

            public String getAgentName() {
                return MarketPlaceInventorySyncAgent.MARKET_PLACE_INVENTORY_SYNC_AGENT;
            }
        };
    }
}

