/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.agents.order.tasks;

import com.venky.core.date.DateUtils;
import com.venky.swf.plugins.background.core.Task;
import com.venky.swf.plugins.background.core.agent.AgentSeederTask;
import com.venky.swf.plugins.background.core.agent.AgentSeederTaskBuilder;
import com.venky.swf.sql.Conjunction;
import com.venky.swf.sql.Expression;
import com.venky.swf.sql.Operator;
import com.venky.swf.sql.Select;
import in.succinct.plugins.ecommerce.db.model.order.Order;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class AcknowledgeOrderTask
implements Task,
AgentSeederTaskBuilder {
    Order order = null;
    public static final String ACKNOWLEDGE_ORDER_AGENT = "ACKNOWLEDGE_ORDER_AGENT";

    public AcknowledgeOrderTask(Order order) {
        this.order = order;
    }

    public AcknowledgeOrderTask() {
    }

    public void execute() {
        if (this.order != null) {
            this.order.acknowledge();
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("|").append(this.order.getId());
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcknowledgeOrderTask)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public AgentSeederTask createSeederTask() {
        return new AgentSeederTask(){
            long lastId = -1L;
            int numTasksToBuffer = 2 * this.getAsyncTaskManager().getNumWorkers() + 10;

            public List<Task> getTasks() {
                Select select = new Select(new String[0]).from(new Class[]{Order.class});
                Expression expression = new Expression(select.getPool(), Conjunction.AND);
                expression.add(new Expression(select.getPool(), "FULFILLMENT_STATUS", Operator.EQ, (Object[])new String[]{"DOWNLOADED"}));
                expression.add(new Expression(select.getPool(), "SHIP_AFTER_DATE", Operator.LE, (Object[])new Date[]{new Date(DateUtils.getStartOfDay((long)System.currentTimeMillis()))}));
                expression.add(new Expression(select.getPool(), "ID", Operator.GT, (Object[])new Long[]{this.lastId}));
                ArrayList<Task> tasks = new ArrayList<Task>();
                for (Order order : select.where(expression).orderBy(new String[]{"ID"}).execute(Order.class, this.numTasksToBuffer)) {
                    tasks.add(new AcknowledgeOrderTask(order));
                    this.lastId = order.getId();
                }
                if (!tasks.isEmpty()) {
                    tasks.add((Task)this);
                }
                return tasks;
            }

            public String getAgentName() {
                return AcknowledgeOrderTask.ACKNOWLEDGE_ORDER_AGENT;
            }
        };
    }
}

