/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.agents.order.tasks;

import com.venky.core.string.StringUtil;
import com.venky.swf.db.Database;
import com.venky.swf.db.model.Model;
import com.venky.swf.db.table.RecordNotFoundException;
import com.venky.swf.plugins.background.core.Task;
import java.lang.reflect.ParameterizedType;

public abstract class EntityTask<M extends Model>
implements Task {
    protected long id;

    protected Class<M> getModelClass(EntityTask<M> instance) {
        ParameterizedType pt = (ParameterizedType)instance.getClass().getGenericSuperclass();
        return (Class)pt.getActualTypeArguments()[0];
    }

    public EntityTask(long id) {
        this.id = id;
    }

    public void execute() {
        Model model = Database.getTable(this.getModelClass(this)).lock(this.id);
        if (model == null) {
            throw new RecordNotFoundException(this.getModelClass(this).getName() + ":" + this.id);
        }
        this.execute(model);
    }

    protected abstract void execute(M var1);

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getModelClass(this).getSimpleName() + "Id=" + this.id + "]";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return StringUtil.equals((String)this.toString(), (String)obj.toString());
    }
}

