/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.agents.order.tasks.pack;

import com.venky.cache.Cache;
import com.venky.core.util.ObjectUtil;
import com.venky.swf.db.Database;
import com.venky.swf.db.annotations.column.ui.mimes.MimeType;
import com.venky.swf.db.model.Model;
import com.venky.swf.db.model.reflection.ModelReflector;
import com.venky.swf.plugins.collab.db.model.participants.admin.Address;
import com.venky.swf.plugins.templates.util.templates.TemplateEngine;
import in.succinct.plugins.ecommerce.agents.order.tasks.EntityTask;
import in.succinct.plugins.ecommerce.db.model.inventory.Sku;
import in.succinct.plugins.ecommerce.db.model.order.Order;
import in.succinct.plugins.ecommerce.db.model.order.OrderAddress;
import in.succinct.plugins.ecommerce.db.model.order.OrderLine;
import in.succinct.plugins.ecommerce.db.model.order.OrderPrint;
import in.succinct.plugins.ecommerce.db.model.order.OrderStatus;
import in.succinct.plugins.ecommerce.db.model.participation.Facility;
import in.succinct.plugins.ecommerce.integration.fedex.ShipWebServiceClient;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PacklistPrintTask
extends EntityTask<Order> {
    public PacklistPrintTask(long id) {
        super(id);
    }

    public PacklistPrintTask() {
        this(-1L);
    }

    @Override
    protected void execute(Order order) {
        HashMap printMap = new HashMap();
        List<OrderPrint> prints = order.getOrderPrints();
        prints.forEach(p -> printMap.put(p.getDocumentType(), p));
        if (printMap.get("CARRIER_LABEL") == null && ObjectUtil.equals((Object)"FedEx", (Object)order.getPreferredCarrierName())) {
            new ShipWebServiceClient(order).ship();
        }
        if (printMap.get("PACK_SLIP") == null) {
            this.printPackSlip(order);
        }
    }

    private Map<Class<? extends Model>, List<String>> getEntityFieldMap() {
        HashMap<Class<? extends Model>, List<String>> entityFieldMap = new HashMap<Class<? extends Model>, List<String>>();
        entityFieldMap.put(Order.class, ModelReflector.instance(Order.class).getVisibleFields());
        entityFieldMap.put(Sku.class, Arrays.asList("NAME", "MAX_RETAIL_PRICE", "TAX_RATE"));
        entityFieldMap.put(OrderLine.class, Arrays.asList("HSN", "SKU_ID", "PACKED_QUANTITY", "SHIPPED_QUANTITY", "MAX_RETAIL_PRICE", "DISCOUNT_PERCENTAGE", "SELLING_PRICE", "PRICE", "I_GST", "C_GST", "S_GST"));
        List facilityFields = ModelReflector.instance(Facility.class).getUniqueFields();
        facilityFields.addAll(Arrays.asList(Address.getAddressFields()));
        entityFieldMap.put(Facility.class, facilityFields);
        List addressFields = ModelReflector.instance(OrderAddress.class).getUniqueFields();
        addressFields.addAll(Arrays.asList(Address.getAddressFields()));
        addressFields.add("FIRST_NAME");
        addressFields.add("LAST_NAME");
        entityFieldMap.put(OrderAddress.class, Arrays.asList(Address.getAddressFields()));
        return entityFieldMap;
    }

    private void printPackSlip(Order order) {
        String html;
        ArrayList<Order> entities = new ArrayList<Order>();
        entities.add(order);
        Map entityMap = TemplateEngine.getInstance().createEntityMap(entities);
        for (OrderStatus status : order.getOrderStatuses()) {
            entityMap.put("OrderStatus" + status.getFulfillmentStatus(), status);
        }
        OrderAddress shipTo = order.getAddresses().stream().filter(a -> ObjectUtil.equals((Object)a.getAddressType(), (Object)"ST")).findFirst().get();
        OrderAddress billTo = order.getAddresses().stream().filter(a -> ObjectUtil.equals((Object)a.getAddressType(), (Object)"BT")).findFirst().get();
        Facility shipFrom = ((OrderLine)order.getOrderLines().get(0)).getShipFrom();
        entityMap.put("ShipFrom", shipFrom);
        entityMap.put("ShipTo", shipTo);
        entityMap.put("BillTo", billTo);
        Map<Class<? extends Model>, List<String>> entityFieldMap = this.getEntityFieldMap();
        Cache<Class<? extends Model>, List<Class<? extends Model>>> childModelMap = new Cache<Class<? extends Model>, List<Class<? extends Model>>>(){

            protected List<Class<? extends Model>> getValue(Class<? extends Model> aClass) {
                return new ArrayList<Class<? extends Model>>();
            }
        };
        childModelMap.put(Order.class, Arrays.asList(OrderLine.class, OrderAddress.class));
        Map root = TemplateEngine.getInstance().formatEntityMap(entityMap, entityFieldMap, (Map)childModelMap);
        String courier = order.getAttribute("courier").getValue();
        root.put("Courier", courier);
        String trackingNumber = order.getAttribute("tracking_number").getValue();
        if (!ObjectUtil.isVoid((Object)trackingNumber)) {
            root.put("TrackingNumber", trackingNumber);
        }
        String templateName = "prints/PRINT_packslip.ftlh";
        String string = html = TemplateEngine.getInstance().exists(templateName) ? TemplateEngine.getInstance().publish(templateName, root) : null;
        if (!ObjectUtil.isVoid((Object)html)) {
            OrderPrint print = (OrderPrint)Database.getTable(OrderPrint.class).newRecord();
            print.setOrderId(order.getId());
            print.setDocumentType("PACK_SLIP");
            byte[] htmlbytes = html.getBytes();
            byte[] bytes = TemplateEngine.getInstance().htmlToPdf(htmlbytes);
            if (bytes.length > 0) {
                print.setImageContentName("packlist" + order.getOrderNumber() + ".pdf");
                print.setImageContentType(MimeType.APPLICATION_PDF.toString());
            } else {
                bytes = htmlbytes;
                print.setImageContentName("packlist" + order.getOrderNumber() + ".html");
                print.setImageContentType(MimeType.TEXT_HTML.toString());
            }
            print.setImage(new ByteArrayInputStream(bytes));
            print.setImageContentSize(bytes.length);
            print.save();
        }
    }
}

