/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.agents.order.tasks.ship;

import com.venky.core.string.StringUtil;
import com.venky.core.util.ObjectUtil;
import com.venky.swf.db.Database;
import com.venky.swf.db.model.reflection.ModelReflector;
import com.venky.swf.plugins.background.core.CoreTask;
import com.venky.swf.plugins.background.core.Task;
import com.venky.swf.plugins.background.core.TaskManager;
import com.venky.swf.plugins.sequence.db.model.SequentialNumber;
import com.venky.swf.sql.Conjunction;
import com.venky.swf.sql.Expression;
import com.venky.swf.sql.Operator;
import com.venky.swf.sql.Select;
import in.succinct.plugins.ecommerce.agents.order.tasks.manifest.ManifestOrderTask;
import in.succinct.plugins.ecommerce.db.model.order.Manifest;
import in.succinct.plugins.ecommerce.db.model.order.Order;
import in.succinct.plugins.ecommerce.db.model.order.OrderLine;
import in.succinct.plugins.ecommerce.db.model.participation.PreferredCarrier;
import java.util.List;

public class CreateManifestTask
implements Task {
    private static final long serialVersionUID = -2079771132674955414L;
    private CoreTask.Priority priority = CoreTask.Priority.DEFAULT;
    long preferredCarrierId = -1L;

    @Deprecated
    public CreateManifestTask() {
    }

    public CreateManifestTask(long preferredCarrierId) {
        this.preferredCarrierId = preferredCarrierId;
    }

    public void setTaskPriority(CoreTask.Priority priority) {
        this.priority = priority;
    }

    public CoreTask.Priority getTaskPriority() {
        return this.priority;
    }

    public void execute() {
        PreferredCarrier preferredCarrier = (PreferredCarrier)Database.getTable(PreferredCarrier.class).lock(this.preferredCarrierId);
        Select manifestSelect = new Select(new String[0]).from(new Class[]{Manifest.class});
        Expression where = new Expression(manifestSelect.getPool(), Conjunction.AND);
        where.add(new Expression(manifestSelect.getPool(), "PREFERRED_CARRIER_ID", Operator.EQ, (Object[])new Long[]{preferredCarrier.getId()}));
        where.add(new Expression(manifestSelect.getPool(), "CLOSED", Operator.EQ, (Object[])new Boolean[]{false}));
        List manifests = manifestSelect.where(where).orderBy(new String[]{"ID"}).execute();
        Manifest manifest = null;
        if (manifests.isEmpty()) {
            manifest = (Manifest)Database.getTable(Manifest.class).newRecord();
            manifest.setManifestNumber(SequentialNumber.get((String)(preferredCarrier.getName() + ".Manifest")).next());
            manifest.setPreferredCarrierId(preferredCarrier.getId());
            manifest.save();
        } else {
            manifest = (Manifest)manifests.get(0);
        }
        this.addOrdersToManifest(manifest, preferredCarrier);
    }

    private void addOrdersToManifest(Manifest manifest, PreferredCarrier preferredCarrier) {
        Select orderSelect = new Select(new String[0]).from(new Class[]{Order.class});
        Expression where = new Expression(orderSelect.getPool(), Conjunction.AND);
        where.add(new Expression(orderSelect.getPool(), "FULFILLMENT_STATUS", Operator.EQ, (Object[])new String[]{"PACKED"}));
        orderSelect.where(where).add(" and exists ( select 1 from " + ModelReflector.instance(OrderLine.class).getTableName() + " ol  where ol.order_id = " + ModelReflector.instance(Order.class).getTableName() + ".id and ol.ship_from_id = " + manifest.getPreferredCarrier().getFacilityId() + ")");
        List packedOrders = orderSelect.orderBy(new String[]{"ID"}).execute();
        packedOrders.forEach(o -> {
            Double estimatedCharges = preferredCarrier.getEstimatedShippingCharges((Order)o);
            Double maxShippingCharges = preferredCarrier.getMaxShippingCharges();
            if (ObjectUtil.isVoid((Object)o.getPreferredCarrierName()) || ObjectUtil.equals((Object)o.getPreferredCarrierName(), (Object)preferredCarrier.getName())) {
                if (estimatedCharges == null || maxShippingCharges == null || estimatedCharges < maxShippingCharges) {
                    TaskManager.instance().executeAsync((CoreTask)new ManifestOrderTask(o.getId(), manifest.getId()), false);
                } else {
                    StringBuilder holdReason = new StringBuilder();
                    holdReason.append(StringUtil.valueOf((Object)o.getHoldReason()));
                    String currentHoldReason = "Shipping Charges > " + maxShippingCharges + " for " + preferredCarrier.getName();
                    if (holdReason.indexOf(currentHoldReason) < 0) {
                        holdReason.append(currentHoldReason).append("<br/>");
                    }
                    o.setHoldReason(holdReason.toString());
                    o.save();
                }
            }
        });
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [preferredCarrierId=" + this.preferredCarrierId + "]";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateManifestTask that = (CreateManifestTask)o;
        return this.preferredCarrierId == that.preferredCarrierId;
    }
}

