/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.controller;

import com.venky.swf.controller.Controller;
import com.venky.swf.db.annotations.column.ui.mimes.MimeType;
import com.venky.swf.db.model.Model;
import com.venky.swf.db.model.reflection.ModelReflector;
import com.venky.swf.integration.FormatHelper;
import com.venky.swf.integration.IntegrationAdaptor;
import com.venky.swf.path.Path;
import com.venky.swf.views.View;
import in.succinct.plugins.ecommerce.db.model.apis.Cancel;
import in.succinct.plugins.ecommerce.db.model.apis.Pack;
import in.succinct.plugins.ecommerce.db.model.attachments.Attachment;
import in.succinct.plugins.ecommerce.db.model.attributes.AssetCode;
import in.succinct.plugins.ecommerce.db.model.catalog.Item;
import in.succinct.plugins.ecommerce.db.model.inventory.AdjustmentRequest;
import in.succinct.plugins.ecommerce.db.model.inventory.Inventory;
import in.succinct.plugins.ecommerce.db.model.inventory.Sku;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ApiController
extends Controller {
    public ApiController(Path path) {
        super(path);
    }

    public View pack() {
        IntegrationAdaptor integrationAdaptor = null;
        if (this.getPath().getProtocol() != MimeType.TEXT_HTML) {
            integrationAdaptor = IntegrationAdaptor.instance(Pack.class, (Class)FormatHelper.getFormatClass((MimeType)this.path.getProtocol()));
        }
        if (integrationAdaptor == null) {
            throw new RuntimeException("Unsupported input format");
        }
        if (!this.getPath().getRequest().getMethod().equalsIgnoreCase("POST")) {
            throw new RuntimeException("Unsupported request method. Only POST is allowed");
        }
        List inputs = integrationAdaptor.readRequest(this.getPath());
        inputs.forEach(pack -> pack.pack());
        return integrationAdaptor.createResponse(this.getPath(), inputs);
    }

    public View cancel() {
        IntegrationAdaptor integrationAdaptor = null;
        if (this.getPath().getProtocol() != MimeType.TEXT_HTML) {
            integrationAdaptor = IntegrationAdaptor.instance(Cancel.class, (Class)FormatHelper.getFormatClass((MimeType)this.path.getProtocol()));
        }
        if (integrationAdaptor == null) {
            throw new RuntimeException("Unsupported input format");
        }
        if (!this.getPath().getRequest().getMethod().equalsIgnoreCase("POST")) {
            throw new RuntimeException("Unsupported request method. Only POST is allowed");
        }
        List inputs = integrationAdaptor.readRequest(this.getPath());
        inputs.forEach(cancel -> cancel.reject());
        return integrationAdaptor.createResponse(this.getPath(), inputs);
    }

    public <T> View adjust() throws Exception {
        IntegrationAdaptor integrationAdaptor = null;
        if (this.getPath().getProtocol() != MimeType.TEXT_HTML) {
            integrationAdaptor = IntegrationAdaptor.instance(AdjustmentRequest.class, (Class)FormatHelper.getFormatClass((MimeType)this.path.getProtocol()));
        }
        if (integrationAdaptor == null) {
            throw new RuntimeException("Unsupported input format");
        }
        if (!this.getPath().getRequest().getMethod().equalsIgnoreCase("POST")) {
            throw new RuntimeException("Unsupported request method. Only POST is allowed");
        }
        FormatHelper helper = FormatHelper.instance((MimeType)integrationAdaptor.getMimeType(), (InputStream)this.getPath().getInputStream());
        List<AdjustmentRequest> requests = AdjustmentRequest.adjust(helper);
        Map<Class<? extends Model>, List<String>> requestFields = ApiController.getAdjustmentRequestFields();
        return integrationAdaptor.createResponse(this.getPath(), requests, requestFields.get(AdjustmentRequest.class), new HashSet(), requestFields);
    }

    public static Map<Class<? extends Model>, List<String>> getAdjustmentRequestFields() {
        HashMap<Class<? extends Model>, List<String>> map = new HashMap<Class<? extends Model>, List<String>>();
        map.put(AdjustmentRequest.class, Arrays.asList("ID", "INVENTORY_ID", "ADJUSTMENT_QUANTITY"));
        map.put(Inventory.class, ModelReflector.instance(Inventory.class).getFields());
        List itemFields = ModelReflector.instance(Item.class).getUniqueFields();
        itemFields.add("ASSET_CODE_ID");
        itemFields.add("ID");
        map.put(Item.class, itemFields);
        List skuFields = ModelReflector.instance(Sku.class).getUniqueFields();
        skuFields.add("ID");
        skuFields.add("MAX_RETAIL_PRICE");
        skuFields.add("TAX_RATE");
        map.put(Sku.class, skuFields);
        map.put(AssetCode.class, Arrays.asList("CODE", "LONG_DESCRIPTION", "GST_PCT"));
        map.put(Attachment.class, Arrays.asList("ATTACHMENT_URL"));
        return map;
    }
}

