/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.controller;

import com.venky.swf.controller.ModelController;
import com.venky.swf.controller.annotations.SingleRecordAction;
import com.venky.swf.db.Database;
import com.venky.swf.db.model.Model;
import com.venky.swf.path.Path;
import com.venky.swf.plugins.background.core.CoreTask;
import com.venky.swf.plugins.background.core.TaskManager;
import com.venky.swf.views.View;
import in.succinct.plugins.ecommerce.agents.order.tasks.OrderStatusMonitor;
import in.succinct.plugins.ecommerce.db.model.order.OrderLine;

public class OrderLinesController
extends ModelController<OrderLine> {
    public OrderLinesController(Path path) {
        super(path);
    }

    @SingleRecordAction(icon="glyphicon-thumbs-up", tooltip="Accept Order for Fulfillment")
    public View acknowledge(long orderLineId) {
        OrderLine ol = (OrderLine)Database.getTable(OrderLine.class).get(orderLineId);
        ol.acknowledge();
        if (this.getIntegrationAdaptor() != null) {
            return this.getIntegrationAdaptor().createResponse(this.getPath(), (Model)ol, null, this.getIgnoredParentModels(), this.getIncludedModelFields());
        }
        return this.back();
    }

    @SingleRecordAction(icon="glyphicon-thumbs-down", tooltip="Reject order fulfillment")
    public View reject(long orderLineId) {
        OrderLine orderLine = (OrderLine)Database.getTable(OrderLine.class).get(orderLineId);
        orderLine.reject("OUT_OF_STOCK");
        if (this.getIntegrationAdaptor() != null) {
            return this.getIntegrationAdaptor().createResponse(this.getPath(), (Model)orderLine, null, this.getIgnoredParentModels(), this.getIncludedModelFields());
        }
        return this.back();
    }

    @SingleRecordAction(icon="glyphicon-thumbs-down", tooltip="Cancel Order Line")
    public View cancel(long orderLineId) {
        OrderLine orderLine = (OrderLine)Database.getTable(OrderLine.class).get(orderLineId);
        orderLine.cancel("No Longer Required", "User");
        if (this.getIntegrationAdaptor() != null) {
            return this.getIntegrationAdaptor().createResponse(this.getPath(), (Model)orderLine, null, this.getIgnoredParentModels(), this.getIncludedModelFields());
        }
        return this.back();
    }

    @SingleRecordAction(icon="glyphicon-gift", tooltip="Pack")
    public View pack(long orderLineId) {
        OrderLine orderLine = (OrderLine)Database.getTable(OrderLine.class).get(orderLineId);
        orderLine.pack(orderLine.getToPackQuantity());
        TaskManager.instance().executeAsync((CoreTask)new OrderStatusMonitor(orderLine.getOrderId()), false);
        if (this.getIntegrationAdaptor() != null) {
            return this.getIntegrationAdaptor().createResponse(this.getPath(), (Model)orderLine, null, this.getIgnoredParentModels(), this.getIncludedModelFields());
        }
        return this.back();
    }
}

