/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.controller;

import com.venky.swf.controller.ModelController;
import com.venky.swf.controller.annotations.SingleRecordAction;
import com.venky.swf.db.Database;
import com.venky.swf.db.model.Model;
import com.venky.swf.db.model.User;
import com.venky.swf.integration.IntegrationAdaptor;
import com.venky.swf.path.Path;
import com.venky.swf.path._IPath;
import com.venky.swf.plugins.background.core.Task;
import com.venky.swf.plugins.background.core.TaskManager;
import com.venky.swf.views.RedirectorView;
import com.venky.swf.views.View;
import in.succinct.plugins.ecommerce.agents.order.tasks.OrderStatusMonitor;
import in.succinct.plugins.ecommerce.agents.order.tasks.pack.PacklistPrintTask;
import in.succinct.plugins.ecommerce.db.model.order.Order;
import in.succinct.plugins.ecommerce.db.model.order.OrderAddress;
import in.succinct.plugins.ecommerce.db.model.order.OrderLine;
import in.succinct.plugins.ecommerce.db.model.order.OrderPrint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OrdersController
extends ModelController<Order> {
    public OrdersController(Path path) {
        super(path);
    }

    @SingleRecordAction(icon="glyphicon-thumbs-up", tooltip="Accept Order for Fulfillment")
    public View acknowledge(long orderId) {
        Order order = (Order)Database.getTable(Order.class).get(orderId);
        order.acknowledge();
        if (this.getIntegrationAdaptor() != null) {
            return this.show(order);
        }
        return this.back();
    }

    @SingleRecordAction(icon="glyphicon-thumbs-down", tooltip="Back order")
    public View backorder(long orderId) {
        Order order = (Order)Database.getTable(Order.class).get(orderId);
        order.backorder();
        if (this.getIntegrationAdaptor() != null) {
            return this.show(order);
        }
        return this.back();
    }

    @SingleRecordAction(icon="glyphicon-thumbs-down", tooltip="Reject order fulfillment")
    public View reject(long orderId) {
        Order order = (Order)Database.getTable(Order.class).get(orderId);
        order.reject();
        if (this.getIntegrationAdaptor() != null) {
            return this.show(order);
        }
        return this.back();
    }

    @SingleRecordAction(icon="glyphicon-thumbs-down", tooltip="Cancel order fulfillment")
    public View cancel(long orderId) {
        Order order = (Order)Database.getTable(Order.class).get(orderId);
        order.cancel("No Longer Required", "User");
        if (this.getIntegrationAdaptor() != null) {
            return this.show(order);
        }
        return this.back();
    }

    protected Set<Class<? extends Model>> getIgnoredParentModels() {
        HashSet<Class<? extends Model>> set = new HashSet<Class<? extends Model>>();
        set.add(User.class);
        return set;
    }

    protected Map<Class<? extends Model>, List<String>> getIncludedModelFields() {
        HashMap<Class<? extends Model>, List<String>> map = new HashMap<Class<? extends Model>, List<String>>();
        map.put(OrderLine.class, null);
        map.put(OrderAddress.class, null);
        return map;
    }

    @SingleRecordAction(icon="glyphicon-gift", tooltip="Pack")
    public View pack(long orderId) {
        Order order = (Order)Database.getTable(Order.class).get(orderId);
        order.pack();
        if (this.getIntegrationAdaptor() != null) {
            return this.show(order);
        }
        return this.back();
    }

    @SingleRecordAction(icon="glyphicon-barcode", tooltip="Print Pack List")
    public View print(long orderId) {
        Order order = (Order)Database.getTable(Order.class).get(orderId);
        OrderPrint print = null;
        for (OrderPrint p : order.getOrderPrints()) {
            if (!p.getDocumentType().equals("PACK_SLIP")) continue;
            print = p;
            break;
        }
        if (print == null) {
            boolean orderPacked = true;
            for (OrderLine line : order.getOrderLines()) {
                if (!(line.getToPackQuantity() > 0.0)) continue;
                orderPacked = false;
                break;
            }
            if (!orderPacked) {
                throw new RuntimeException("Order is not yet packed");
            }
            TaskManager.instance().executeAsync(this.getTasksToPrint(orderId), false);
            if (this.getReturnIntegrationAdaptor() != null) {
                return IntegrationAdaptor.instance(OrderPrint.class, (Class)this.getReturnIntegrationAdaptor().getFormatClass()).createResponse(this.getPath(), new ArrayList());
            }
            this.getPath().addInfoMessage("Labels being generated.. check after some time.");
            return this.back();
        }
        if (this.getReturnIntegrationAdaptor() != null) {
            return IntegrationAdaptor.instance(OrderPrint.class, (Class)this.getReturnIntegrationAdaptor().getFormatClass()).createResponse(this.getPath(), Arrays.asList(print), Arrays.asList("ID"));
        }
        return new RedirectorView((_IPath)this.getPath(), this.getPath().controllerPath() + "/show/" + orderId + "/order_prints", "view/" + print.getId());
    }

    @SingleRecordAction(icon="glyphicon-road", tooltip="Ship")
    public View ship(long orderId) {
        Order order = (Order)Database.getTable(Order.class).get(orderId);
        order.ship();
        if (this.getIntegrationAdaptor() != null) {
            return this.show(order);
        }
        return this.back();
    }

    @SingleRecordAction(icon="glyphicon-envelope", tooltip="Deliver")
    public View deliver(long orderId) {
        Order order = (Order)Database.getTable(Order.class).get(orderId);
        order.deliver();
        if (this.getIntegrationAdaptor() != null) {
            return this.show(order);
        }
        return this.back();
    }

    protected List<Task> getTasksToPrint(long orderId) {
        ArrayList<Task> printTasks = new ArrayList<Task>();
        printTasks.add(new PacklistPrintTask(orderId));
        return printTasks;
    }

    @SingleRecordAction(icon="glyphicon-refresh", tooltip="Refresh")
    public View refresh(long orderId) {
        ArrayList<OrderStatusMonitor> tasks = new ArrayList<OrderStatusMonitor>();
        tasks.add(new OrderStatusMonitor(orderId));
        TaskManager.instance().executeAsync(tasks, false);
        if (this.getIntegrationAdaptor() != null) {
            return this.show(orderId);
        }
        return this.back();
    }
}

