/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.db.model.apis;

import com.venky.core.util.ObjectUtil;
import com.venky.swf.db.model.Model;
import com.venky.swf.db.table.ModelImpl;
import in.succinct.plugins.ecommerce.db.model.apis.Pack;
import in.succinct.plugins.ecommerce.db.model.order.OrderLine;

public class PackImpl
extends ModelImpl<Pack> {
    public PackImpl(Pack pack) {
        super((Model)pack);
    }

    public void pack() {
        Pack pack = (Pack)this.getProxy();
        try {
            OrderLine ol = pack.getOrderLine();
            if (ol == null) {
                throw new Pack.PackValidationException("Could not determine order line");
            }
            if (pack.getPackedQuantity() == null) {
                if (!ObjectUtil.isVoid((Object)pack.getUnitNumber())) {
                    pack.setPackedQuantity(1.0);
                } else {
                    pack.setPackedQuantity(ol.getToPackQuantity());
                }
            }
            if (ol.isUnitNumberCaptureRequired()) {
                if (pack.getPackedQuantity() > 1.0) {
                    throw new Pack.PackValidationException("Sku " + ol.getSku().getName() + " requires scanning of " + ol.getUnitNumberTypeRequired() + " and therefore PackQuantity cannot be more than 1");
                }
                if (ObjectUtil.isVoid((Object)pack.getUnitNumber())) {
                    throw new Pack.PackValidationException("Sku " + ol.getSku().getName() + " requires scanning of " + ol.getUnitNumberTypeRequired());
                }
                ol.pack(pack.getUnitNumber());
            } else {
                ol.pack(pack.getPackedQuantity());
            }
            pack.setSuccess(true);
        }
        catch (Pack.PackValidationException ex) {
            pack.setError(ex.getMessage());
            pack.setSuccess(false);
        }
    }
}

