/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.db.model.assets;

import com.venky.digest.Encryptor;
import com.venky.swf.db.model.Model;
import com.venky.swf.db.table.ModelImpl;
import in.succinct.plugins.ecommerce.db.model.assets.Asset;
import in.succinct.plugins.ecommerce.db.model.assets.Capability;
import in.succinct.plugins.ecommerce.db.model.attributes.AttributeValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class AssetImpl
extends ModelImpl<Asset> {
    public AssetImpl(Asset asset) {
        super((Model)asset);
    }

    public AssetImpl() {
    }

    public boolean isRentable() {
        boolean rentable = false;
        Iterator<Capability> i = ((Asset)this.getProxy()).getAssetCapabilities().iterator();
        while (!rentable && i.hasNext()) {
            Capability capability = i.next();
            rentable = rentable || capability.getAssetCode().isSac();
        }
        return rentable;
    }

    public List<Capability> getLoanableCapabilities() {
        return ((Asset)this.getProxy()).getAssetCapabilities().stream().filter(c -> c.getAssetCode().isSac()).collect(Collectors.toList());
    }

    public void computeHash() {
        Asset asset = (Asset)this.getProxy();
        HashMap<Long, AttributeValue> attributeIdValueMap = new HashMap<Long, AttributeValue>();
        asset.getAssetAttributeValues().forEach(a -> {
            AttributeValue attributeValue = a.getAttributeValue();
            attributeIdValueMap.put(attributeValue.getAttributeId(), attributeValue);
        });
        HashSet allowedAttributeIds = new HashSet();
        for (Capability assetCapability : asset.getAssetCapabilities()) {
            TreeSet catalogAttributeValueIds = new TreeSet();
            TreeSet inventoryAttributeValueIds = new TreeSet();
            assetCapability.getAssetCode().getAssetCodeAttributes().forEach(attr -> {
                allowedAttributeIds.add(attr.getAttributeId());
                AttributeValue attributeValue = (AttributeValue)attributeIdValueMap.get(attr.getAttributeId());
                if (attributeValue != null) {
                    switch (attr.getAttributeType()) {
                        case "Catalog": {
                            catalogAttributeValueIds.add(attributeValue.getId());
                            break;
                        }
                        case "Inventory": {
                            inventoryAttributeValueIds.add(attributeValue.getId());
                        }
                    }
                }
            });
            String catalogHash = Encryptor.encrypt((String)(assetCapability.getAssetCodeId() + ((Object)catalogAttributeValueIds).toString()));
            assetCapability.setAssetCatalogHash(catalogHash);
            String inventoryHash = Encryptor.encrypt((String)(assetCapability.getAssetCodeId() + ((Object)inventoryAttributeValueIds).toString()));
            assetCapability.setAssetInventoryHash(inventoryHash);
            assetCapability.save();
        }
        attributeIdValueMap.forEach((attrId, attrValue) -> {
            if (!allowedAttributeIds.contains(attrId)) {
                attrValue.destroy();
            }
        });
    }
}

