/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.db.model.catalog;

import com.venky.digest.Encryptor;
import com.venky.swf.db.annotations.column.IS_NULLABLE;
import com.venky.swf.db.annotations.column.IS_VIRTUAL;
import com.venky.swf.db.annotations.column.UNIQUE_KEY;
import com.venky.swf.db.annotations.column.indexing.Index;
import com.venky.swf.db.annotations.column.pm.PARTICIPANT;
import com.venky.swf.db.annotations.column.ui.PROTECTION;
import com.venky.swf.db.annotations.model.MENU;
import com.venky.swf.db.annotations.model.validations.UniqueKeyValidator;
import com.venky.swf.db.model.Model;
import com.venky.swf.plugins.collab.db.model.CompanySpecific;
import com.venky.swf.sql.Conjunction;
import com.venky.swf.sql.Expression;
import com.venky.swf.sql.Operator;
import com.venky.swf.sql.Select;
import in.succinct.plugins.ecommerce.db.model.assets.Asset;
import in.succinct.plugins.ecommerce.db.model.attributes.AssetCode;
import in.succinct.plugins.ecommerce.db.model.attributes.AttributeValue;
import in.succinct.plugins.ecommerce.db.model.catalog.ItemAttributeValue;
import in.succinct.plugins.ecommerce.db.model.catalog.ItemCategory;
import in.succinct.plugins.ecommerce.db.model.inventory.Container;
import in.succinct.plugins.ecommerce.db.model.inventory.Sku;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;

@MENU(value="Catalog")
public interface Item
extends Container,
Model,
CompanySpecific {
    @PROTECTION(value=PROTECTION.Kind.NON_EDITABLE)
    public Long getCompanyId();

    @UNIQUE_KEY
    @Index
    public String getName();

    public void setName(String var1);

    @Override
    public Double getLength();

    @Override
    @PARTICIPANT(redundant=true)
    public Long getLengthUOMId();

    @Override
    public Double getWidth();

    @Override
    @PARTICIPANT(redundant=true)
    public Long getWidthUOMId();

    @Override
    public Double getHeight();

    @Override
    @PARTICIPANT(redundant=true)
    public Long getHeightUOMId();

    @Override
    public Double getWeight();

    @Override
    @PARTICIPANT(redundant=true)
    public Long getWeightUOMId();

    public List<Sku> getSkus();

    public List<ItemCategory> getItemCategories();

    public ItemCategory getItemCategory(String var1);

    public ItemCategory setItemCategory(String var1, String var2);

    public static Item find(long companyId, String name) {
        Select select = new Select(new String[0]).from(new Class[]{Item.class});
        Expression where = new Expression(select.getPool(), Conjunction.AND);
        where.add(new Expression(select.getPool(), "NAME", Operator.EQ, (Object[])new String[]{name}));
        where.add(new Expression(select.getPool(), "COMPANY_ID", Operator.EQ, (Object[])new Long[]{companyId}));
        List items = select.where(where).orderBy(new String[]{"ID"}).execute();
        if (items.size() == 0) {
            return null;
        }
        if (items.size() > 1) {
            throw new UniqueKeyValidator.UniqueConstraintViolatedException("CompanyId:" + companyId + ", Item: " + name);
        }
        return (Item)items.get(0);
    }

    @IS_NULLABLE
    public Long getAssetCodeId();

    public void setAssetCodeId(Long var1);

    public AssetCode getAssetCode();

    @IS_VIRTUAL
    public List<Asset> getAssets();

    @IS_VIRTUAL
    public boolean isRentable();

    public List<ItemAttributeValue> getAttributeValues();

    @UNIQUE_KEY(allowMultipleRecordsWithNull=false)
    public String getItemHash();

    public void setItemHash(String var1);

    @IS_VIRTUAL
    public void computeHash();

    @IS_VIRTUAL
    public String getHsn();

    public static String hash(AssetCode assetCode, Collection<AttributeValue> attributeValues) {
        HashSet allowedAttributeIds = new HashSet();
        assetCode.getAssetCodeAttributes().forEach(a -> allowedAttributeIds.add(a.getAttributeId()));
        StringBuilder builder = new StringBuilder();
        builder.append(assetCode.getId());
        TreeSet<Long> attributeValueIds = new TreeSet<Long>();
        for (AttributeValue value : attributeValues) {
            if (!allowedAttributeIds.contains(value.getAttributeId())) continue;
            attributeValueIds.add(value.getId());
        }
        builder.append(attributeValueIds);
        return Encryptor.encrypt((String)builder.toString());
    }
}

