/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.db.model.catalog;

import com.venky.swf.db.Database;
import com.venky.swf.db.model.Model;
import com.venky.swf.db.model.reflection.ModelReflector;
import com.venky.swf.db.table.ModelImpl;
import com.venky.swf.sql.Conjunction;
import com.venky.swf.sql.Expression;
import com.venky.swf.sql.Operator;
import com.venky.swf.sql.Select;
import in.succinct.plugins.ecommerce.db.model.assets.Asset;
import in.succinct.plugins.ecommerce.db.model.assets.Capability;
import in.succinct.plugins.ecommerce.db.model.attributes.AssetCode;
import in.succinct.plugins.ecommerce.db.model.attributes.AttributeValue;
import in.succinct.plugins.ecommerce.db.model.catalog.Item;
import in.succinct.plugins.ecommerce.db.model.catalog.ItemAttributeValue;
import in.succinct.plugins.ecommerce.db.model.catalog.ItemCategory;
import in.succinct.plugins.ecommerce.db.model.catalog.MasterItemCategory;
import in.succinct.plugins.ecommerce.db.model.catalog.MasterItemCategoryValue;
import java.util.ArrayList;
import java.util.List;

public class ItemImpl
extends ModelImpl<Item> {
    private String hsn = null;

    public ItemImpl() {
    }

    public ItemImpl(Item item) {
        super((Model)item);
    }

    public ItemCategory getItemCategory(String categoryName) {
        Item item = (Item)this.getProxy();
        ItemCategory itemCategory = null;
        for (ItemCategory tmp : item.getItemCategories()) {
            if (!tmp.getMasterItemCategory().getName().equals(categoryName)) continue;
            itemCategory = tmp;
            break;
        }
        return itemCategory;
    }

    public ItemCategory setItemCategory(String categoryName, String categoryValue) {
        Item item = (Item)this.getProxy();
        ItemCategory itemCategory = this.getItemCategory(categoryName);
        if (itemCategory != null) {
            if (itemCategory.getMasterItemCategoryValue().getAllowedValue().equals(categoryValue)) {
                return itemCategory;
            }
            MasterItemCategoryValue masterItemCategoryValue = ItemImpl.getMasterItemCategoryValue(item.getCompanyId(), categoryName, categoryValue);
            itemCategory.setMasterItemCategoryValueId(masterItemCategoryValue.getId());
        } else {
            itemCategory = (ItemCategory)Database.getTable(ItemCategory.class).newRecord();
            itemCategory.setItemId(item.getId());
            MasterItemCategoryValue masterItemCategoryValue = ItemImpl.getMasterItemCategoryValue(item.getCompanyId(), categoryName, categoryValue);
            itemCategory.setMasterItemCategoryId(masterItemCategoryValue.getMasterItemCategoryId());
            itemCategory.setMasterItemCategoryValueId(masterItemCategoryValue.getId());
        }
        itemCategory.save();
        return itemCategory;
    }

    private static MasterItemCategoryValue getMasterItemCategoryValue(long companyId, String categoryName, String categoryValue) {
        MasterItemCategory category = ItemImpl.getMasterCategory(companyId, categoryName);
        List<MasterItemCategoryValue> values = category.getAllowedValues();
        MasterItemCategoryValue matchedMasterItemCategoryValue = null;
        for (MasterItemCategoryValue value : values) {
            if (!value.getAllowedValue().equals(categoryValue)) continue;
            matchedMasterItemCategoryValue = value;
            break;
        }
        if (matchedMasterItemCategoryValue == null) {
            matchedMasterItemCategoryValue = (MasterItemCategoryValue)Database.getTable(MasterItemCategoryValue.class).newRecord();
            matchedMasterItemCategoryValue.setMasterItemCategoryId(category.getId());
            matchedMasterItemCategoryValue.setAllowedValue(categoryValue);
            matchedMasterItemCategoryValue.save();
        }
        return matchedMasterItemCategoryValue;
    }

    private static MasterItemCategory getMasterCategory(long companyId, String categoryName) {
        MasterItemCategory category = MasterItemCategory.find(companyId, categoryName, true);
        if (category == null) {
            category = (MasterItemCategory)Database.getTable(MasterItemCategory.class).newRecord();
            category.setCompanyId(companyId);
            category.setName(categoryName);
            category.save();
        }
        return category;
    }

    public boolean isRentable() {
        return false;
    }

    public List<Asset> getAssets() {
        Item item = (Item)this.getProxy();
        ModelReflector ref = ModelReflector.instance(Capability.class);
        List assets = new Select(new String[0]).from(new Class[]{Capability.class}).where(new Expression(ref.getPool(), Conjunction.AND).add(new Expression(ref.getPool(), "catalog_hash", Operator.EQ, (Object[])new String[]{item.getItemHash()})).add(new Expression(ref.getPool(), "asset_code_id", Operator.EQ, (Object[])new Long[]{item.getAssetCodeId()}))).execute();
        return assets;
    }

    public void computeHash() {
        Item item = (Item)this.getProxy();
        if (item.getReflector().isVoid((Object)item.getAssetCodeId())) {
            return;
        }
        ArrayList<AttributeValue> attributeValues = new ArrayList<AttributeValue>();
        for (ItemAttributeValue itemAttributeValue : item.getAttributeValues()) {
            attributeValues.add(itemAttributeValue.getAttributeValue());
        }
        item.setItemHash(Item.hash(item.getAssetCode(), attributeValues));
        item.save();
    }

    public String getHsn() {
        if (this.hsn == null) {
            AssetCode assetCode;
            Item item = (Item)this.getProxy();
            if (item.getAssetCodeId() != null && (assetCode = item.getAssetCode()).isHsn()) {
                return assetCode.getCode();
            }
            ItemCategory category = item.getItemCategory("HSN");
            this.hsn = category != null ? category.getMasterItemCategoryValue().getAllowedValue() : "";
        }
        return this.hsn;
    }
}

