/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.db.model.catalog;

import com.venky.swf.db.annotations.column.IS_NULLABLE;
import com.venky.swf.db.annotations.column.UNIQUE_KEY;
import com.venky.swf.db.annotations.column.pm.PARTICIPANT;
import com.venky.swf.db.annotations.column.relationship.CONNECTED_VIA;
import com.venky.swf.db.annotations.column.ui.HIDDEN;
import com.venky.swf.db.annotations.column.ui.PROTECTION;
import com.venky.swf.db.annotations.model.CONFIGURATION;
import com.venky.swf.db.annotations.model.MENU;
import com.venky.swf.db.annotations.model.validations.UniqueKeyValidator;
import com.venky.swf.db.model.Model;
import com.venky.swf.sql.Conjunction;
import com.venky.swf.sql.Expression;
import com.venky.swf.sql.Operator;
import com.venky.swf.sql.Select;
import in.succinct.plugins.ecommerce.db.model.catalog.ItemCategory;
import in.succinct.plugins.ecommerce.db.model.catalog.MasterItemCategoryValue;
import in.succinct.plugins.ecommerce.db.model.participation.Company;
import java.util.List;

@MENU(value="Catalog")
@CONFIGURATION
public interface MasterItemCategory
extends Model {
    @PARTICIPANT
    @PROTECTION(value=PROTECTION.Kind.NON_EDITABLE)
    @UNIQUE_KEY
    public long getCompanyId();

    public void setCompanyId(long var1);

    public Company getCompany();

    @UNIQUE_KEY
    @IS_NULLABLE(value=false)
    public String getName();

    public void setName(String var1);

    public List<MasterItemCategoryValue> getAllowedValues();

    public static MasterItemCategory find(long companyId, String name, boolean lock) {
        Select select = new Select(lock, new String[0]).from(new Class[]{MasterItemCategory.class});
        Expression where = new Expression(select.getPool(), Conjunction.AND);
        where.add(new Expression(select.getPool(), "NAME", Operator.EQ, (Object[])new String[]{name}));
        where.add(new Expression(select.getPool(), "COMPANY_ID", Operator.EQ, (Object[])new Long[]{companyId}));
        List categories = select.where(where).execute();
        if (categories.size() == 0) {
            return null;
        }
        if (categories.size() > 1) {
            throw new UniqueKeyValidator.UniqueConstraintViolatedException("CompanyId:" + companyId + ", name: " + name);
        }
        return (MasterItemCategory)categories.get(0);
    }

    @CONNECTED_VIA(value="MASTER_ITEM_CATEGORY_ID")
    @HIDDEN
    public List<ItemCategory> getItemCategories();
}

