/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.db.model.catalog;

import com.venky.swf.db.annotations.column.UNIQUE_KEY;
import com.venky.swf.db.annotations.column.indexing.Index;
import com.venky.swf.db.annotations.column.relationship.CONNECTED_VIA;
import com.venky.swf.db.annotations.column.validations.Enumeration;
import com.venky.swf.db.annotations.model.CONFIGURATION;
import com.venky.swf.db.annotations.model.MENU;
import com.venky.swf.db.model.Model;
import com.venky.swf.sql.Conjunction;
import com.venky.swf.sql.Expression;
import com.venky.swf.sql.Operator;
import com.venky.swf.sql.Select;
import in.succinct.plugins.ecommerce.db.model.catalog.UnitOfMeasureConversionTable;
import java.util.List;

@MENU(value="Catalog")
@CONFIGURATION
public interface UnitOfMeasure
extends Model {
    public static final String KILOGRAMS = "Kgs";
    public static final String GRAMS = "Gms";
    public static final String CENTIMETERS = "Cms";
    public static final String INCHES = "Inches";
    public static final String KILOMETERS = "Kms";
    public static final String MEASURES_WEIGHT = "Weight";
    public static final String MEASURES_LENGTH = "Length";
    public static final String MEASURES_PACKAGING = "Packaging";
    public static final String MEASURES_TEMPERATURE = "Temperature";
    public static final String MEASURES_DOSAGE = "Dosage";

    @UNIQUE_KEY
    @Index
    public String getName();

    public void setName(String var1);

    @Enumeration(value="Weight,Length,Packaging,Temperature,Dosage")
    @UNIQUE_KEY
    @Index
    public String getMeasures();

    public void setMeasures(String var1);

    @CONNECTED_VIA(value="FROM_ID")
    public List<UnitOfMeasureConversionTable> getConvertableToUOMs();

    @CONNECTED_VIA(value="TO_ID")
    public List<UnitOfMeasureConversionTable> getConvertableFromUOMs();

    public static UnitOfMeasure getDefaultWeightMeasure() {
        return UnitOfMeasure.getWeightMeasure(KILOGRAMS);
    }

    public static UnitOfMeasure getWeightMeasure(String name) {
        return UnitOfMeasure.getMeasure(MEASURES_WEIGHT, name);
    }

    public static UnitOfMeasure getLengthMeasure(String name) {
        return UnitOfMeasure.getMeasure(MEASURES_LENGTH, name);
    }

    public static UnitOfMeasure getMeasure(String measures, String name) {
        Select s = new Select(new String[0]).from(new Class[]{UnitOfMeasure.class});
        Expression w = new Expression(s.getPool(), Conjunction.AND);
        w.add(new Expression(s.getPool(), "NAME", Operator.EQ, (Object[])new String[]{name}));
        w.add(new Expression(s.getPool(), "MEASURES", Operator.EQ, (Object[])new String[]{measures}));
        List uoms = s.where(w).execute();
        if (uoms.isEmpty()) {
            return null;
        }
        if (uoms.size() > 1) {
            throw new RuntimeException("Multiple UOMS match " + name + " that measures " + measures);
        }
        return (UnitOfMeasure)uoms.get(0);
    }

    public static List<UnitOfMeasure> getMeasures(String measures) {
        Select s = new Select(new String[0]).from(new Class[]{UnitOfMeasure.class});
        Expression w = new Expression(s.getPool(), Conjunction.AND);
        w.add(new Expression(s.getPool(), "MEASURES", Operator.EQ, (Object[])new String[]{measures}));
        return s.where(w).execute();
    }
}

