/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.db.model.catalog;

import com.venky.swf.db.annotations.column.IS_NULLABLE;
import com.venky.swf.db.annotations.column.UNIQUE_KEY;
import com.venky.swf.db.annotations.column.pm.PARTICIPANT;
import com.venky.swf.db.annotations.column.ui.OnLookupSelect;
import com.venky.swf.db.annotations.model.CONFIGURATION;
import com.venky.swf.db.model.Model;
import in.succinct.plugins.ecommerce.db.model.catalog.UnitOfMeasure;

@CONFIGURATION
public interface UnitOfMeasureConversionTable
extends Model {
    @IS_NULLABLE(value=false)
    @UNIQUE_KEY
    @OnLookupSelect(processor="in.succinct.plugins.ecommerce.db.model.catalog.UnitOfMeasureSelectionProcessor")
    @PARTICIPANT(redundant=true)
    public Long getFromId();

    public void setFromId(Long var1);

    public UnitOfMeasure getFrom();

    @IS_NULLABLE(value=false)
    @UNIQUE_KEY
    @OnLookupSelect(processor="in.succinct.plugins.ecommerce.db.model.catalog.UnitOfMeasureSelectionProcessor")
    @PARTICIPANT(redundant=true)
    public Long getToId();

    public void setToId(Long var1);

    public UnitOfMeasure getTo();

    public double getConversionFactor();

    public void setConversionFactor(double var1);

    public static double convert(double measurement, String measureType, String fromUom, String toUom) {
        if (fromUom.equals(toUom)) {
            return measurement;
        }
        UnitOfMeasure from = UnitOfMeasure.getMeasure(measureType, fromUom);
        UnitOfMeasure to = UnitOfMeasure.getMeasure(measureType, toUom);
        if (from == null) {
            throw new IllegalArgumentException(fromUom + " is not a valid uom for " + measureType);
        }
        if (to == null) {
            throw new IllegalArgumentException(toUom + " is not a valid uom for " + measureType);
        }
        return UnitOfMeasureConversionTable.convert(measurement, measureType, from, to);
    }

    public static double convert(double measurement, String measureType, UnitOfMeasure from, UnitOfMeasure to) {
        if (from.getId() != to.getId()) {
            for (UnitOfMeasureConversionTable cnvTable : from.getConvertableToUOMs()) {
                if (cnvTable.getToId().longValue() != to.getId()) continue;
                return cnvTable.getConversionFactor() * measurement;
            }
            for (UnitOfMeasureConversionTable cnvTable : to.getConvertableToUOMs()) {
                if (cnvTable.getToId().longValue() != from.getId()) continue;
                return measurement / cnvTable.getConversionFactor();
            }
        } else {
            return measurement;
        }
        throw new IllegalArgumentException("Cannot be converted from " + from.getName() + " to " + to.getName());
    }
}

