/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.db.model.inventory;

import com.venky.core.util.ObjectUtil;
import com.venky.swf.db.annotations.column.IS_NULLABLE;
import com.venky.swf.db.annotations.column.ui.HIDDEN;
import com.venky.swf.db.annotations.column.validations.MinLength;
import com.venky.swf.db.annotations.model.EXPORTABLE;
import com.venky.swf.db.annotations.model.MENU;
import com.venky.swf.db.model.Model;
import com.venky.swf.db.model.io.ModelIOFactory;
import com.venky.swf.db.model.reflection.ModelReflector;
import com.venky.swf.integration.FormatHelper;
import in.succinct.plugins.ecommerce.db.model.attributes.AssetCode;
import in.succinct.plugins.ecommerce.db.model.catalog.Item;
import in.succinct.plugins.ecommerce.db.model.catalog.UnitOfMeasure;
import in.succinct.plugins.ecommerce.db.model.inventory.Inventory;
import in.succinct.plugins.ecommerce.db.model.inventory.Sku;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

@EXPORTABLE(value=false)
@MENU(value="Inventory")
public interface AdjustmentRequest
extends Model {
    @HIDDEN
    public long getInventoryId();

    public void setInventoryId(long var1);

    public Inventory getInventory();

    public double getAdjustmentQuantity();

    public void setAdjustmentQuantity(double var1);

    @MinLength(value=1)
    @IS_NULLABLE(value=false)
    public String getComment();

    public void setComment(String var1);

    public static <T> List<AdjustmentRequest> adjust(FormatHelper<T> helper) {
        Object adjustmentElement;
        List adjustmentElements = helper.getArrayElements("AdjustmentRequest");
        if (adjustmentElements.isEmpty() && (adjustmentElement = helper.getElementAttribute("AdjustmentRequest")) != null) {
            adjustmentElements.add(adjustmentElement);
        }
        ArrayList<AdjustmentRequest> requests = new ArrayList<AdjustmentRequest>();
        ModelReflector ref = ModelReflector.instance(AdjustmentRequest.class);
        for (Object adjustmentElement2 : adjustmentElements) {
            Inventory inventory;
            FormatHelper adjustmentElementHelper = FormatHelper.instance(adjustmentElement2);
            boolean newProduct = (Boolean)ref.getJdbcTypeHelper().getTypeRef(Boolean.class).getTypeConverter().valueOf(adjustmentElementHelper.getAttribute("NewProduct"));
            Object inventoryElement = adjustmentElementHelper.getElementAttribute("Inventory");
            Object skuElement = FormatHelper.instance((Object)inventoryElement).getElementAttribute("Sku");
            if (skuElement != null) {
                Sku sku;
                AssetCode assetCode;
                FormatHelper skuHelper = FormatHelper.instance((Object)skuElement);
                Object itemElement = skuHelper.getElementAttribute("Item");
                if (itemElement != null) {
                    FormatHelper itemHelper = FormatHelper.instance((Object)itemElement);
                    Object uomElement = skuHelper.getElementAttribute("PackagingUOM");
                    if (uomElement != null) {
                        UnitOfMeasure uom = (UnitOfMeasure)ModelIOFactory.getReader(UnitOfMeasure.class, (Class)helper.getFormatClass()).read(uomElement);
                        uom.save();
                    } else if (ObjectUtil.isVoid((Object)skuHelper.getAttribute("Name"))) {
                        skuHelper.setAttribute("Name", (String)itemHelper.getAttribute("Name"));
                    }
                    Object assetCodeElement = itemHelper.getElementAttribute("AssetCode");
                    if (assetCodeElement != null && ObjectUtil.isVoid((Object)FormatHelper.instance((Object)assetCodeElement).getAttribute("Code"))) {
                        itemHelper.removeElementAttribute("AssetCode");
                    }
                    Item item = (Item)ModelIOFactory.getReader(Item.class, (Class)helper.getFormatClass()).read(itemElement);
                    item.save();
                }
                if ((assetCode = (sku = (Sku)ModelIOFactory.getReader(Sku.class, (Class)helper.getFormatClass()).read(skuElement)).getItem().getAssetCode()) != null && !assetCode.getReflector().isVoid((Object)assetCode.getGstPct())) {
                    sku.setTaxRate(assetCode.getGstPct());
                }
                sku.setUpdatedAt(new Timestamp(System.currentTimeMillis()));
                sku.save();
            }
            if ((inventory = (Inventory)ModelIOFactory.getReader(Inventory.class, (Class)helper.getFormatClass()).read(inventoryElement)).getRawRecord().isNewRecord()) {
                inventory.save();
            }
            AdjustmentRequest request = (AdjustmentRequest)ModelIOFactory.getReader(AdjustmentRequest.class, (Class)helper.getFormatClass()).read(adjustmentElement2);
            request.setInventoryId(inventory.getId());
            request.save();
            requests.add(request);
        }
        return requests;
    }
}

