/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.db.model.inventory;

import com.venky.swf.db.Database;
import com.venky.swf.db.annotations.column.COLUMN_DEF;
import com.venky.swf.db.annotations.column.IS_NULLABLE;
import com.venky.swf.db.annotations.column.IS_VIRTUAL;
import com.venky.swf.db.annotations.column.UNIQUE_KEY;
import com.venky.swf.db.annotations.column.defaulting.StandardDefault;
import com.venky.swf.db.annotations.column.indexing.Index;
import com.venky.swf.db.annotations.column.pm.PARTICIPANT;
import com.venky.swf.db.annotations.column.ui.HIDDEN;
import com.venky.swf.db.annotations.model.EXPORTABLE;
import com.venky.swf.db.annotations.model.MENU;
import com.venky.swf.db.model.Model;
import com.venky.swf.plugins.calendar.db.model.WorkCalendar;
import com.venky.swf.plugins.collab.db.model.CompanySpecific;
import com.venky.swf.sql.Conjunction;
import com.venky.swf.sql.Expression;
import com.venky.swf.sql.Operator;
import com.venky.swf.sql.Select;
import in.succinct.plugins.ecommerce.db.model.assets.Asset;
import in.succinct.plugins.ecommerce.db.model.demand.Demand;
import in.succinct.plugins.ecommerce.db.model.inventory.AdjustmentRequest;
import in.succinct.plugins.ecommerce.db.model.inventory.InventoryAttributeValue;
import in.succinct.plugins.ecommerce.db.model.inventory.InventoryAudit;
import in.succinct.plugins.ecommerce.db.model.inventory.Sku;
import in.succinct.plugins.ecommerce.db.model.participation.Facility;
import java.util.List;

@MENU(value="Inventory")
@EXPORTABLE(value=false)
public interface Inventory
extends Model,
CompanySpecific {
    @HIDDEN
    public Long getCompanyId();

    @PARTICIPANT(redundant=true)
    @UNIQUE_KEY(value="K1,K2")
    @Index
    public long getFacilityId();

    public void setFacilityId(long var1);

    public Facility getFacility();

    @PARTICIPANT(redundant=true)
    @UNIQUE_KEY(value="K1,K2")
    @Index
    public long getSkuId();

    public void setSkuId(long var1);

    public Sku getSku();

    @COLUMN_DEF(value=StandardDefault.BOOLEAN_TRUE)
    public boolean isInfinite();

    public void setInfinite(boolean var1);

    @COLUMN_DEF(value=StandardDefault.ZERO)
    public double getQuantity();

    public void setQuantity(double var1);

    @IS_VIRTUAL
    public double getAvailableToPromise();

    @IS_VIRTUAL
    public double getDemandQuantity();

    @COLUMN_DEF(value=StandardDefault.BOOLEAN_TRUE)
    public boolean isEnabled();

    public void setEnabled(boolean var1);

    @IS_VIRTUAL
    @Index
    public boolean isPublished();

    @IS_NULLABLE
    public Double getMaxRetailPrice();

    public void setMaxRetailPrice(Double var1);

    @IS_NULLABLE
    public Double getSellingPrice();

    public void setSellingPrice(Double var1);

    public List<AdjustmentRequest> getAdjustmentRequests();

    public List<InventoryAudit> getAudits();

    public List<Demand> getDemands();

    @IS_VIRTUAL
    public WorkCalendar getWorkCalendar();

    @IS_NULLABLE
    @UNIQUE_KEY(allowMultipleRecordsWithNull=false, value="K1,K2")
    public String getInventoryHash();

    public void setInventoryHash(String var1);

    public void computeHash();

    public List<InventoryAttributeValue> getInventoryAttributes();

    @IS_VIRTUAL
    public List<Asset> getAssets();

    public void adjust(double var1, String var3);

    public static Inventory find(Facility facility, Sku sku) {
        return Inventory.find(facility.getId(), sku.getId());
    }

    public static Inventory find(long facilityId, long skuId) {
        Select inventorySelect = new Select(new String[0]).from(new Class[]{Inventory.class});
        Expression where = new Expression(inventorySelect.getPool(), Conjunction.AND);
        where.add(new Expression(inventorySelect.getPool(), "FACILITY_ID", Operator.EQ, (Object[])new Long[]{facilityId}));
        where.add(new Expression(inventorySelect.getPool(), "SKU_ID", Operator.EQ, (Object[])new Long[]{skuId}));
        List inventories = inventorySelect.where(where).execute();
        Inventory inventory = null;
        if (inventories.isEmpty()) {
            inventory = (Inventory)Database.getTable(Inventory.class).newRecord();
            inventory.setFacilityId(facilityId);
            inventory.setSkuId(skuId);
        } else if (inventories.size() == 1) {
            inventory = (Inventory)inventories.get(0);
        } else {
            throw new RuntimeException("Cannot find inventory record uniquely:" + where.getRealSQL());
        }
        return inventory;
    }

    public static void adjust(Facility facility, Sku sku, double signedDelta, String comment) {
        Inventory inventory = Inventory.find(facility, sku);
        inventory.adjust(signedDelta, comment);
    }
}

