/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.db.model.inventory;

import com.venky.cache.Cache;
import com.venky.core.collections.SequenceSet;
import com.venky.core.date.DateUtils;
import com.venky.core.util.Bucket;
import com.venky.swf.db.model.reflection.ModelReflector;
import com.venky.swf.plugins.calendar.db.model.WorkSlot;
import com.venky.swf.pm.DataSecurityFilter;
import com.venky.swf.sql.Conjunction;
import com.venky.swf.sql.Expression;
import com.venky.swf.sql.Operator;
import com.venky.swf.sql.Select;
import in.succinct.plugins.ecommerce.db.model.attributes.AttributeValue;
import in.succinct.plugins.ecommerce.db.model.demand.Demand;
import in.succinct.plugins.ecommerce.db.model.inventory.Inventory;
import in.succinct.plugins.ecommerce.db.model.inventory.Sku;
import in.succinct.plugins.ecommerce.db.model.order.OrderLine;
import in.succinct.plugins.ecommerce.db.model.order.OrderLineItemAttributeValue;
import in.succinct.plugins.ecommerce.db.model.participation.Facility;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InventoryCalculator {
    Facility facility = null;
    Sku sku = null;
    List<AttributeValue> inventoryAttributeValues = new ArrayList<AttributeValue>();
    Timestamp after = null;
    Timestamp before = null;

    public InventoryCalculator(OrderLine orderLine) {
        this.facility = orderLine.getShipFrom();
        this.sku = orderLine.getSku();
        for (OrderLineItemAttributeValue orderLineItemAttributeValue : orderLine.getOrderLineItemAttributeValues()) {
            this.inventoryAttributeValues.add(orderLineItemAttributeValue.getAttributeValue());
        }
        this.after = orderLine.getOrder().getShipAfterDate();
        this.before = orderLine.getOrder().getShipByDate();
    }

    public InventoryCalculator(Sku sku) {
        this(sku, null);
    }

    public InventoryCalculator(Sku sku, Facility facility) {
        this.sku = sku;
        this.facility = facility;
        this.inventoryAttributeValues = new ArrayList<AttributeValue>();
    }

    public Double getTotalInventory() {
        Bucket total = new Bucket();
        this.getInventory().forEach(atp -> total.increment(atp.getQuantity().doubleValue()));
        return total.doubleValue();
    }

    public Double getPendingShip() {
        Bucket total = new Bucket();
        this.getInventory().forEach(atp -> total.increment(atp.getPendingShipQuantity().doubleValue()));
        return total.doubleValue();
    }

    private List<Demand> getDemands(Set<Long> inventoryIds) {
        ModelReflector ref = ModelReflector.instance(Demand.class);
        Expression where = new Expression(ref.getPool(), Conjunction.AND);
        where.add(new Expression(ref.getPool(), "INVENTORY_ID", Operator.IN, inventoryIds.toArray()));
        String[] orderBy = new String[]{"ID"};
        if (this.sku.getItem().isRentable()) {
            if (this.after != null) {
                where.add(new Expression(ref.getPool(), "DEMAND_DATE", Operator.GE, (Object[])new Timestamp[]{this.after}));
            }
            if (this.before != null) {
                where.add(new Expression(ref.getPool(), "DEMAND_DATE", Operator.LE, (Object[])new Timestamp[]{this.before}));
            }
            orderBy = new String[]{"DEMAND_DATE", "ID"};
        }
        Select select = new Select(new String[0]).from(new Class[]{Demand.class}).where(where).orderBy(orderBy);
        List demands = select.execute();
        return demands;
    }

    public List<ATP> getInventory() {
        ArrayList<ATP> inv = new ArrayList<ATP>();
        ModelReflector ref = ModelReflector.instance(Inventory.class);
        Expression where = new Expression(ref.getPool(), Conjunction.AND);
        if (this.facility != null) {
            where.add(new Expression(ref.getPool(), "FACILITY_ID", Operator.EQ, (Object[])new Long[]{this.facility.getId()}));
        }
        where.add(new Expression(ref.getPool(), "SKU_ID", Operator.EQ, (Object[])new Long[]{this.sku.getId()}));
        Select select = new Select(new String[0]).from(new Class[]{Inventory.class}).where(where);
        for (AttributeValue attributeValue : this.inventoryAttributeValues) {
            select.add(" and exists ( select 1 from inventory_attribute_values where inventory_id = inventories.id and attribute_value_id = " + attributeValue.getId() + ")");
        }
        List inventories = select.execute();
        SequenceSet inventoryIds = DataSecurityFilter.getIds((List)inventories);
        List<Demand> demands = this.getDemands((Set<Long>)inventoryIds);
        Cache<Long, Map<Date, Map<Long, List<Demand>>>> map = new Cache<Long, Map<Date, Map<Long, List<Demand>>>>(0, 0.0){

            protected Map<Date, Map<Long, List<Demand>>> getValue(Long inventoryId) {
                return new Cache<Date, Map<Long, List<Demand>>>(0, 0.0){

                    protected Map<Long, List<Demand>> getValue(Date date) {
                        return new Cache<Long, List<Demand>>(){

                            protected List<Demand> getValue(Long slotId) {
                                return new ArrayList<Demand>();
                            }
                        };
                    }
                };
            }
        };
        demands.forEach(arg_0 -> InventoryCalculator.lambda$getInventory$2((Map)map, arg_0));
        inventories.forEach(arg_0 -> this.lambda$getInventory$3((Map)map, inv, arg_0));
        return inv;
    }

    private /* synthetic */ void lambda$getInventory$3(Map map, List inv, Inventory inventory) {
        if (this.sku.getItem().isRentable()) {
            long date = this.after.getTime();
            while (date <= this.before.getTime()) {
                for (WorkSlot slot : inventory.getWorkCalendar().getWorkSlots()) {
                    ATP atp = new ATP();
                    atp.inventory = inventory;
                    atp.onDate = date;
                    atp.slot = slot;
                    atp.pendShip = (List)((Map)((Map)map.get(inventory.getId())).get(new Date(date))).get(slot.getId());
                    inv.add(atp);
                }
                date = DateUtils.addHours((long)date, (int)24);
            }
        } else {
            ATP atp = new ATP();
            atp.inventory = inventory;
            atp.pendShip = (List)((Map)((Map)map.get(inventory.getId())).get(null)).get(null);
            inv.add(atp);
        }
    }

    private static /* synthetic */ void lambda$getInventory$2(Map map, Demand demand) {
        ((List)((Map)((Map)map.get(demand.getInventoryId())).get(demand.getDemandDate())).get(demand.getWorkSlotId())).add(demand);
    }

    public static class ATP {
        Inventory inventory;
        List<Demand> pendShip;
        long onDate;
        WorkSlot slot;
        Bucket total = null;
        Bucket pendShipQuantity = null;

        public Inventory getInventory() {
            return this.inventory;
        }

        public long getDemandDate() {
            return this.onDate;
        }

        public WorkSlot getSlot() {
            return this.slot;
        }

        public Long getSlotId() {
            if (this.slot == null) {
                return null;
            }
            return this.slot.getId();
        }

        public Bucket getPendingShipQuantity() {
            if (this.pendShipQuantity != null) {
                return this.pendShipQuantity;
            }
            this.getQuantity();
            return this.pendShipQuantity;
        }

        public Bucket getQuantity() {
            if (this.total != null) {
                return this.total;
            }
            this.total = new Bucket();
            this.pendShipQuantity = new Bucket();
            boolean isItemRentable = this.inventory.getSku().getItem().isRentable();
            if (isItemRentable) {
                Bucket workSlotCapacityConsumed = new Bucket();
                this.pendShip.forEach(demand -> workSlotCapacityConsumed.increment(demand.getQuantity().doubleValue()));
                this.total.increment(this.inventory.getQuantity());
                this.total.decrement(workSlotCapacityConsumed.doubleValue());
            } else {
                this.pendShip.forEach(demand -> this.pendShipQuantity.increment(demand.getQuantity().doubleValue()));
                this.total.increment(this.inventory.isInfinite() ? Double.POSITIVE_INFINITY : this.inventory.getQuantity() - this.pendShipQuantity.doubleValue());
            }
            if (this.total.doubleValue() < 0.0) {
                this.total = new Bucket(0.0);
            }
            return this.total;
        }
    }
}

