/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.db.model.inventory;

import com.venky.core.util.ObjectUtil;
import com.venky.digest.Encryptor;
import com.venky.swf.db.Database;
import com.venky.swf.db.model.Model;
import com.venky.swf.db.model.reflection.ModelReflector;
import com.venky.swf.db.table.ModelImpl;
import com.venky.swf.plugins.background.core.CoreTask;
import com.venky.swf.plugins.background.core.TaskManager;
import com.venky.swf.plugins.calendar.db.model.WorkCalendar;
import com.venky.swf.plugins.lucene.index.LuceneIndexer;
import com.venky.swf.plugins.lucene.index.background.IndexTask;
import com.venky.swf.routing.Config;
import com.venky.swf.sql.Conjunction;
import com.venky.swf.sql.Expression;
import com.venky.swf.sql.Operator;
import com.venky.swf.sql.Select;
import in.succinct.plugins.ecommerce.db.model.assets.Asset;
import in.succinct.plugins.ecommerce.db.model.assets.Capability;
import in.succinct.plugins.ecommerce.db.model.catalog.Item;
import in.succinct.plugins.ecommerce.db.model.inventory.Inventory;
import in.succinct.plugins.ecommerce.db.model.inventory.InventoryAttributeValue;
import in.succinct.plugins.ecommerce.db.model.inventory.InventoryAudit;
import in.succinct.plugins.ecommerce.db.model.inventory.InventoryCalculator;
import in.succinct.plugins.ecommerce.db.model.participation.Company;
import in.succinct.plugins.ecommerce.db.model.participation.Facility;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class InventoryImpl
extends ModelImpl<Inventory> {
    private InventoryCalculator inventoryCalculator = null;

    public InventoryImpl() {
    }

    public InventoryImpl(Inventory proxy) {
        super((Model)proxy);
    }

    public void adjust(double delta, String comment) {
        JSONObject object;
        Inventory inv = (Inventory)this.getProxy();
        if (!inv.isInfinite()) {
            inv.setQuantity(inv.getQuantity() + delta);
        }
        try {
            object = (JSONObject)JSONValue.parse((String)comment);
        }
        catch (Exception ex) {
            object = null;
        }
        if (object == null) {
            object = new JSONObject();
            object.put((Object)"Comment", (Object)comment);
        }
        for (String f : inv.getRawRecord().getDirtyFields()) {
            JSONObject audit = new JSONObject();
            object.put((Object)f, (Object)audit);
            audit.put((Object)"old", inv.getRawRecord().getOldValue(f));
            audit.put((Object)"new", inv.getReflector().get((Object)inv, f));
        }
        inv.save();
        InventoryAudit audit = (InventoryAudit)Database.getTable(InventoryAudit.class).newRecord();
        audit.setInventoryId(inv.getId());
        audit.setAuditQuantity(delta);
        audit.setComment(object.toString());
        audit.save();
    }

    public void computeHash() {
        Inventory inventory = (Inventory)this.getProxy();
        Item item = (Item)inventory.getSku().getItem().getRawRecord().getAsProxy(Item.class);
        if (item.getReflector().isVoid((Object)item.getAssetCodeId())) {
            return;
        }
        HashSet allowedAttributeIds = new HashSet();
        item.getAssetCode().getAssetCodeAttributes().forEach(aca -> {
            if (ObjectUtil.equals((Object)aca.getAttributeType(), (Object)"Inventory")) {
                allowedAttributeIds.add(aca.getAttributeId());
            }
        });
        StringBuilder builder = new StringBuilder();
        builder.append(item.getAssetCodeId());
        TreeSet set = new TreeSet();
        if (!inventory.getRawRecord().isNewRecord()) {
            inventory.getInventoryAttributes().forEach(a -> {
                if (allowedAttributeIds.contains(a.getAttributeValue().getAttributeId())) {
                    set.add(a.getAttributeValueId());
                } else {
                    a.destroy();
                }
            });
        }
        builder.append(set);
        inventory.setInventoryHash(Encryptor.encrypt((String)builder.toString()));
        inventory.save();
        this.reindex(inventory);
    }

    public void reindex(Inventory inventory) {
        LuceneIndexer indexer = LuceneIndexer.instance(Inventory.class);
        try {
            Document document = indexer.getDocument(inventory.getRawRecord());
            for (InventoryAttributeValue a : inventory.getInventoryAttributes()) {
                indexer.addTextField(document, a.getAttribute().getName(), a.getAttributeValue().getPossibleValue(), Field.Store.YES);
            }
            IndexTask task = new IndexTask();
            task.setOperation(IndexTask.Operation.MODIFY);
            task.setDirectory(Database.getTable(Inventory.class).getTableName());
            task.setDocuments(Arrays.asList(document));
            TaskManager.instance().executeAsync((CoreTask)task, false);
        }
        catch (Exception ex) {
            Config.instance().getLogger(this.getModelClass().getName()).log(Level.INFO, "Reindex on inventory failed", (Throwable)ex);
        }
    }

    public List<Asset> getAssets() {
        Inventory inventory = (Inventory)this.getProxy();
        Item item = (Item)inventory.getSku().getItem().getRawRecord().getAsProxy(Item.class);
        ModelReflector ref = ModelReflector.instance(Capability.class);
        List assets = new Select(new String[0]).from(new Class[]{Capability.class}).where(new Expression(ref.getPool(), Conjunction.AND).add(new Expression(ref.getPool(), "inventory_hash", Operator.EQ, (Object[])new String[]{inventory.getInventoryHash()})).add(new Expression(ref.getPool(), "asset_code_id", Operator.EQ, (Object[])new Long[]{item.getAssetCodeId()}))).execute();
        return assets;
    }

    public WorkCalendar getWorkCalendar() {
        Company company;
        Inventory inventory = (Inventory)this.getProxy();
        WorkCalendar calendar = null;
        Facility facility = inventory.getFacility();
        if (facility.getWorkCalendarId() != null) {
            calendar = facility.getWorkCalendar();
        }
        if (calendar == null && (company = (Company)facility.getCompany().getRawRecord().getAsProxy(Company.class)).getWorkCalendarId() != null) {
            calendar = company.getWorkCalendar();
        }
        return calendar;
    }

    public InventoryCalculator getInventoryCalculator() {
        Inventory inventory = (Inventory)this.getProxy();
        if (inventory.getRawRecord().isNewRecord()) {
            return null;
        }
        if (this.inventoryCalculator == null) {
            this.inventoryCalculator = new InventoryCalculator(((Inventory)this.getProxy()).getSku(), ((Inventory)this.getProxy()).getFacility());
        }
        return this.inventoryCalculator;
    }

    public boolean isPublished() {
        Inventory inventory = (Inventory)this.getProxy();
        InventoryCalculator inventoryCalculator = this.getInventoryCalculator();
        return inventory.isEnabled() && (inventory.isInfinite() || inventoryCalculator != null && inventoryCalculator.getTotalInventory() > 0.0);
    }

    public double getAvailableToPromise() {
        InventoryCalculator calculator = this.getInventoryCalculator();
        if (calculator == null) {
            return 0.0;
        }
        return calculator.getTotalInventory();
    }

    public double getDemandQuantity() {
        InventoryCalculator calculator = this.getInventoryCalculator();
        if (calculator == null) {
            return 0.0;
        }
        return calculator.getPendingShip();
    }
}

