/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.db.model.inventory;

import com.venky.swf.db.annotations.column.COLUMN_DEF;
import com.venky.swf.db.annotations.column.COLUMN_SIZE;
import com.venky.swf.db.annotations.column.IS_NULLABLE;
import com.venky.swf.db.annotations.column.IS_VIRTUAL;
import com.venky.swf.db.annotations.column.UNIQUE_KEY;
import com.venky.swf.db.annotations.column.defaulting.StandardDefault;
import com.venky.swf.db.annotations.column.indexing.Index;
import com.venky.swf.db.annotations.column.pm.PARTICIPANT;
import com.venky.swf.db.annotations.column.ui.PROTECTION;
import com.venky.swf.db.annotations.column.ui.WATERMARK;
import com.venky.swf.db.annotations.model.MENU;
import com.venky.swf.db.annotations.model.ORDER_BY;
import com.venky.swf.db.annotations.model.validations.UniqueKeyValidator;
import com.venky.swf.db.model.Model;
import com.venky.swf.plugins.collab.db.model.CompanySpecific;
import com.venky.swf.sql.Conjunction;
import com.venky.swf.sql.Expression;
import com.venky.swf.sql.Operator;
import com.venky.swf.sql.Select;
import in.succinct.plugins.ecommerce.db.model.attachments.Attachment;
import in.succinct.plugins.ecommerce.db.model.catalog.Item;
import in.succinct.plugins.ecommerce.db.model.catalog.UnitOfMeasure;
import in.succinct.plugins.ecommerce.db.model.inventory.Container;
import in.succinct.plugins.ecommerce.db.model.inventory.Inventory;
import in.succinct.plugins.ecommerce.db.model.inventory.ProductContent;
import in.succinct.plugins.ecommerce.db.model.inventory.SkuDiscountPlan;
import in.succinct.plugins.ecommerce.db.model.participation.Company;
import java.sql.Date;
import java.util.List;

@MENU(value="Inventory")
@ORDER_BY(value="COMPANY_ID,PUBLISHED DESC,DISPLAY_SEQUENCE_NO,ID")
public interface Sku
extends Model,
Container,
CompanySpecific {
    @PARTICIPANT(redundant=true)
    @UNIQUE_KEY(value="SKU2,SKU3")
    @Index
    public long getItemId();

    public void setItemId(long var1);

    public Item getItem();

    @IS_NULLABLE
    @UNIQUE_KEY(value="SKU3", allowMultipleRecordsWithNull=true)
    @PARTICIPANT(redundant=true)
    @Index
    public Long getPackagingUOMId();

    public void setPackagingUOMId(Long var1);

    public UnitOfMeasure getPackagingUOM();

    @UNIQUE_KEY(value="UPC", allowMultipleRecordsWithNull=true)
    public String getSkuCode();

    public void setSkuCode(String var1);

    @UNIQUE_KEY(value="SKU")
    @PROTECTION(value=PROTECTION.Kind.NON_EDITABLE)
    public Long getCompanyId();

    public void setCompanyId(long var1);

    public Company getCompany();

    @Index
    @UNIQUE_KEY(value="SKU,SKU2")
    public String getName();

    public void setName(String var1);

    @Index
    public boolean isPublished();

    public void setPublished(boolean var1);

    @Index
    public String getShortDescription();

    public void setShortDescription(String var1);

    @Index
    @COLUMN_SIZE(value=8192)
    public String getLongDescription();

    public void setLongDescription(String var1);

    @WATERMARK(value="Enter absolute url of small sized product image")
    public String getSmallImageUrl();

    public void setSmallImageUrl(String var1);

    @WATERMARK(value="Enter absolute url of large sized product image")
    public String getLongImageUrl();

    public void setLongImageUrl(String var1);

    @COLUMN_SIZE(value=1024)
    public String getBenefits();

    public void setBenefits(String var1);

    public String getCompositionUnitDescription();

    public void setCompositionUnitDescription(String var1);

    public List<ProductContent> getProductContents();

    @Override
    public Double getLength();

    @Override
    @PARTICIPANT(redundant=true)
    public Long getLengthUOMId();

    @Override
    public Double getWidth();

    @Override
    @PARTICIPANT(redundant=true)
    public Long getWidthUOMId();

    @Override
    public Double getHeight();

    @Override
    @PARTICIPANT(redundant=true)
    public Long getHeightUOMId();

    @Override
    public Double getWeight();

    @Override
    @PARTICIPANT(redundant=true)
    public Long getWeightUOMId();

    public static Sku find(long companyId, String itemName, String uomName) {
        Item item = Item.find(companyId, itemName);
        UnitOfMeasure uom = UnitOfMeasure.getMeasure("Packaging", uomName);
        if (item == null || uom == null) {
            return null;
        }
        Select select = new Select(new String[0]).from(new Class[]{Sku.class});
        Expression where = new Expression(select.getPool(), Conjunction.AND);
        where.add(new Expression(select.getPool(), "ITEM_ID", Operator.EQ, (Object[])new Long[]{item.getId()}));
        where.add(new Expression(select.getPool(), "PACKAGING_U_O_M_ID", Operator.EQ, (Object[])new Long[]{uom.getId()}));
        where.add(new Expression(select.getPool(), "COMPANY_ID", Operator.EQ, (Object[])new Long[]{companyId}));
        List skus = select.where(where).execute();
        if (skus.size() == 0) {
            return null;
        }
        if (skus.size() > 1) {
            throw new UniqueKeyValidator.UniqueConstraintViolatedException("CompanyId = " + companyId + ", Item: " + itemName + ", Uom : " + uomName);
        }
        return (Sku)skus.get(0);
    }

    public static Sku find(long companyId, String name) {
        Select select = new Select(new String[0]).from(new Class[]{Sku.class});
        Expression where = new Expression(select.getPool(), Conjunction.AND);
        where.add(new Expression(select.getPool(), "NAME", Operator.EQ, (Object[])new String[]{name}));
        where.add(new Expression(select.getPool(), "COMPANY_ID", Operator.EQ, (Object[])new Long[]{companyId}));
        List skus = select.where(where).execute();
        if (skus.size() == 0) {
            return null;
        }
        if (skus.size() > 1) {
            throw new UniqueKeyValidator.UniqueConstraintViolatedException("CompanyId = " + companyId + ", Sku: " + name);
        }
        return (Sku)skus.get(0);
    }

    public List<Inventory> getInventory();

    @COLUMN_DEF(value=StandardDefault.ZERO)
    public double getMaxRetailPrice();

    public void setMaxRetailPrice(double var1);

    @IS_VIRTUAL
    public double getSellingPrice();

    @COLUMN_DEF(value=StandardDefault.ZERO)
    public double getTaxRate();

    public void setTaxRate(double var1);

    @COLUMN_DEF(value=StandardDefault.ZERO)
    public int getDisplaySequenceNo();

    public void setDisplaySequenceNo(int var1);

    public List<SkuDiscountPlan> getDiscountPlans();

    @IS_VIRTUAL
    public Long getActiveDiscountPlanId();

    public SkuDiscountPlan getActiveDiscountPlan();

    public List<Attachment> getAttachments();

    @COLUMN_DEF(value=StandardDefault.BOOLEAN_FALSE)
    public boolean isPublishedToMarketPlace();

    public void setPublishedToMarketPlace(boolean var1);

    public Date getExpectedToBeAvailableBy();

    public void setExpectedToBeAvailableBy(Date var1);

    @Index
    @COLUMN_DEF(value=StandardDefault.BOOLEAN_FALSE)
    public boolean isActive();

    public void setActive(boolean var1);

    @IS_VIRTUAL
    public double getGeneralDiscountPct();
}

