/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.db.model.inventory;

import com.venky.core.math.DoubleHolder;
import com.venky.core.util.ObjectHolder;
import com.venky.swf.db.model.Model;
import com.venky.swf.db.table.ModelImpl;
import in.succinct.plugins.ecommerce.db.model.inventory.ActiveSkuDiscountPlan;
import in.succinct.plugins.ecommerce.db.model.inventory.Sku;
import in.succinct.plugins.ecommerce.db.model.inventory.SkuDiscountPlan;
import java.util.ArrayList;
import java.util.List;

public class SkuImpl
extends ModelImpl<Sku> {
    private ObjectHolder<SkuDiscountPlan> activeDiscountPlan = null;

    public SkuImpl(Sku sku) {
        super((Model)sku);
    }

    public SkuImpl() {
    }

    public SkuDiscountPlan getActiveDiscountPlan() {
        if (this.activeDiscountPlan == null) {
            this.activeDiscountPlan = new ObjectHolder(null);
            List<SkuDiscountPlan> plans = ((Sku)this.getProxy()).getDiscountPlans();
            if (plans.size() > 0) {
                this.activeDiscountPlan.set((Object)plans.get(0));
            }
        }
        return (SkuDiscountPlan)this.activeDiscountPlan.get();
    }

    public Long getActiveDiscountPlanId() {
        SkuDiscountPlan active = this.getActiveDiscountPlan();
        if (active != null) {
            return active.getId();
        }
        return null;
    }

    public void setActiveDiscountPlanId(Long id) {
    }

    public List<ActiveSkuDiscountPlan> getActiveDiscountPlans() {
        List<SkuDiscountPlan> plans = ((Sku)this.getProxy()).getDiscountPlans();
        ArrayList<ActiveSkuDiscountPlan> activeSkuDiscountPlans = new ArrayList<ActiveSkuDiscountPlan>();
        if (!plans.isEmpty()) {
            activeSkuDiscountPlans.add((ActiveSkuDiscountPlan)plans.get(0).getRawRecord().getAsProxy(ActiveSkuDiscountPlan.class));
        }
        return activeSkuDiscountPlans;
    }

    public double getGeneralDiscountPct() {
        Sku sku = (Sku)this.getProxy();
        SkuDiscountPlan plan = this.getActiveDiscountPlan();
        if (plan != null) {
            return plan.getGeneralDiscountPct();
        }
        return 0.0;
    }

    public double getSellingPrice() {
        Sku sku = (Sku)this.getProxy();
        SkuDiscountPlan plan = this.getActiveDiscountPlan();
        if (plan != null) {
            return new DoubleHolder(sku.getMaxRetailPrice() * (1.0 - plan.getGeneralDiscountPct() / 100.0), 2).getHeldDouble().doubleValue();
        }
        return sku.getMaxRetailPrice();
    }
}

