/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.db.model.order;

import com.venky.core.util.ObjectUtil;
import com.venky.swf.db.model.Model;
import com.venky.swf.db.table.ModelImpl;
import com.venky.swf.plugins.background.core.CoreTask;
import com.venky.swf.plugins.background.core.TaskManager;
import com.venky.swf.sql.Conjunction;
import com.venky.swf.sql.Expression;
import com.venky.swf.sql.Operator;
import com.venky.swf.sql.Select;
import in.succinct.plugins.ecommerce.agents.order.tasks.ship.ManifestShippingUpdatesTask;
import in.succinct.plugins.ecommerce.db.model.order.Manifest;
import in.succinct.plugins.ecommerce.db.model.order.Order;
import in.succinct.plugins.ecommerce.db.model.order.OrderAttribute;
import in.succinct.plugins.ecommerce.integration.fedex.TrackWebServiceClient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ManifestImpl
extends ModelImpl<Manifest> {
    Set<Long> orderIds = null;
    List<Order> orders = null;

    public ManifestImpl(Manifest proxy) {
        super((Model)proxy);
    }

    public void close() {
        Manifest manifest = (Manifest)this.getProxy();
        if (!manifest.isClosed()) {
            manifest.setClosed(true);
            manifest.save();
        } else {
            TaskManager.instance().executeAsync((CoreTask)new ManifestShippingUpdatesTask(manifest.getId()), false);
        }
    }

    public void track() {
        if (this.getNumOrdersPendingDelivery() > 0) {
            TrackWebServiceClient client = new TrackWebServiceClient((Manifest)this.getProxy());
            client.track();
        }
    }

    public Set<Long> getOrderIdsPendingDelivery() {
        if (this.orderIds == null) {
            this.orderIds = new HashSet<Long>();
            Manifest manifest = (Manifest)this.getProxy();
            Select s = new Select(new String[0]).from(new Class[]{OrderAttribute.class});
            Expression where = new Expression(s.getPool(), Conjunction.AND);
            where.add(new Expression(s.getPool(), "NAME", Operator.EQ, (Object[])new String[]{"manifest_number"}));
            where.add(new Expression(s.getPool(), "VALUE", Operator.EQ, (Object[])new String[]{manifest.getManifestNumber()}));
            s.where(where).add(" and exists ( select 1 from order_statuses where order_id = order_attributes.order_id and fulfillment_status = 'MANIFESTED' ) ");
            List oas = s.execute();
            oas.forEach(oa -> this.orderIds.add(oa.getOrderId()));
        }
        return this.orderIds;
    }

    public List<Order> getOrders() {
        if (this.orders == null) {
            Set<Long> orderIds = this.getOrderIdsPendingDelivery();
            if (orderIds.isEmpty()) {
                this.orders = new ArrayList<Order>();
            } else {
                Manifest manifest = (Manifest)this.getProxy();
                this.orders = new Select(new String[0]).from(new Class[]{Order.class}).where(new Expression(this.getReflector().getPool(), "ID", Operator.IN, orderIds.toArray())).execute();
                Iterator<Order> i = this.orders.iterator();
                while (i.hasNext()) {
                    Order order = i.next();
                    if (ObjectUtil.equals((Object)order.getAttribute("courier").getValue(), (Object)manifest.getPreferredCarrier().getName())) continue;
                    i.remove();
                }
            }
        }
        return this.orders;
    }

    public int getNumOrdersPendingDelivery() {
        return this.getOrderIdsPendingDelivery().size();
    }
}

