/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.db.model.order;

import com.venky.swf.db.annotations.column.COLUMN_DEF;
import com.venky.swf.db.annotations.column.IS_NULLABLE;
import com.venky.swf.db.annotations.column.IS_VIRTUAL;
import com.venky.swf.db.annotations.column.UNIQUE_KEY;
import com.venky.swf.db.annotations.column.defaulting.StandardDefault;
import com.venky.swf.db.annotations.column.indexing.Index;
import com.venky.swf.db.annotations.column.ui.PROTECTION;
import com.venky.swf.db.annotations.column.validations.Enumeration;
import com.venky.swf.db.annotations.model.EXPORTABLE;
import com.venky.swf.db.annotations.model.MENU;
import com.venky.swf.db.model.Model;
import com.venky.swf.plugins.collab.db.model.CompanySpecific;
import com.venky.swf.plugins.collab.db.model.user.User;
import in.succinct.plugins.ecommerce.db.model.order.Manifest;
import in.succinct.plugins.ecommerce.db.model.order.OrderAddress;
import in.succinct.plugins.ecommerce.db.model.order.OrderAttribute;
import in.succinct.plugins.ecommerce.db.model.order.OrderIntransitEvent;
import in.succinct.plugins.ecommerce.db.model.order.OrderLine;
import in.succinct.plugins.ecommerce.db.model.order.OrderPrint;
import in.succinct.plugins.ecommerce.db.model.order.OrderStatus;
import in.succinct.plugins.ecommerce.db.model.participation.MarketPlaceIntegration;
import in.succinct.plugins.ecommerce.db.model.participation.PreferredCarrier;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;

@MENU(value="Fulfillment")
@EXPORTABLE(value=false)
public interface Order
extends Model,
CompanySpecific {
    public static final String FULFILLMENT_STATUS_DOWNLOADED = "DOWNLOADED";
    public static final String FULFILLMENT_STATUS_ACKNOWLEDGED = "ACKNOWLEDGED";
    public static final String FULFILLMENT_STATUS_PACKED = "PACKED";
    public static final String FULFILLMENT_STATUS_MANIFESTED = "MANIFESTED";
    public static final String FULFILLMENT_STATUS_SHIPPED = "SHIPPED";
    public static final String FULFILLMENT_STATUS_DELIVERED = "DELIVERED";
    public static final String FULFILLMENT_STATUS_CANCELLED = "CANCELLED";
    public static final String FULFILLMENT_STATUS_RETURNED = "RETURNED";
    public static final String RETURN_STATUS_REQUESTED = "REQUESTED";
    public static final String RETURN_STATUS_REJECTED = "REJECTED";
    public static final String RETURN_STATUS_APPROVED = "APPROVED";
    public static final String RETURN_STATUS_RETURNED = "RETURNED";
    public static final String RETURN_STATUS_REFUNDED = "REFUNDED";
    public static final String RETURN_STATUS_REPLACED = "REPLACED";
    public static final String HOLD_REASON_CATALOG_INCOMPLETE = "New item!";

    @Index
    public String getReference();

    public void setReference(String var1);

    @IS_VIRTUAL
    public String getOrderNumber();

    public void setOrderNumber(String var1);

    @IS_VIRTUAL
    public Long getPreferredCarrierId();

    public void setPreferredCarrierId(Long var1);

    public PreferredCarrier getPreferredCarrier();

    @IS_NULLABLE
    @COLUMN_DEF(value=StandardDefault.SOME_VALUE, args="FedEx")
    @PROTECTION(value=PROTECTION.Kind.NON_EDITABLE)
    public String getPreferredCarrierName();

    public void setPreferredCarrierName(String var1);

    @COLUMN_DEF(value=StandardDefault.BOOLEAN_TRUE)
    public boolean isMrpInclusiveOfTaxes();

    public void setMrpInclusiveOfTaxes(boolean var1);

    @UNIQUE_KEY
    public long getId();

    public List<OrderStatus> getOrderStatuses();

    @Enumeration(value="DOWNLOADED,ACKNOWLEDGED,PACKED,MANIFESTED,SHIPPED,DELIVERED,CANCELLED,RETURNED")
    @COLUMN_DEF(value=StandardDefault.SOME_VALUE, args="DOWNLOADED")
    @Index
    public String getFulfillmentStatus();

    public void setFulfillmentStatus(String var1);

    @Enumeration(value=" ,REQUESTED,REJECTED,APPROVED,RETURNED,REFUNDED,REPLACED")
    public String getReturnStatus();

    public void setReturnStatus(String var1);

    public String getReturnReason();

    public void setReturnReason(String var1);

    @IS_NULLABLE
    public Double getSellingPrice();

    public void setSellingPrice(Double var1);

    @Index
    public Timestamp getShipByDate();

    public void setShipByDate(Timestamp var1);

    @IS_NULLABLE
    @Index
    public Timestamp getShipAfterDate();

    public void setShipAfterDate(Timestamp var1);

    public List<OrderAddress> getAddresses();

    public List<OrderAttribute> getAttributes();

    public <T extends OrderLine> List<T> getOrderLines();

    public Map<String, OrderAttribute> getAttributeMap();

    public void saveAttributeMap(Map<String, OrderAttribute> var1);

    public OrderAttribute getAttribute(String var1);

    public void acknowledge();

    public void backorder();

    public void reject();

    public void cancel(String var1);

    public void cancel(String var1, String var2);

    public void ship();

    public List<OrderPrint> getOrderPrints();

    public void pack();

    public void deliver();

    @COLUMN_DEF(value=StandardDefault.BOOLEAN_FALSE)
    public boolean isCOD();

    public void setCOD(Boolean var1);

    @IS_VIRTUAL
    public boolean isShort();

    public Double getIGst();

    public void setIGst(Double var1);

    public Double getCGst();

    public void setCGst(Double var1);

    public Double getSGst();

    public void setSGst(Double var1);

    public Double getPrice();

    public void setPrice(Double var1);

    public Double getProductPrice();

    public void setProductPrice(Double var1);

    public Double getProductSellingPrice();

    public void setProductSellingPrice(Double var1);

    @COLUMN_DEF(value=StandardDefault.ZERO)
    public double getShippingPrice();

    public void setShippingPrice(double var1);

    @COLUMN_DEF(value=StandardDefault.ZERO)
    public double getShippingSellingPrice();

    public void setShippingSellingPrice(double var1);

    @IS_VIRTUAL
    public Long getManifestId();

    public void setManifestId(Long var1);

    public Manifest getManifest();

    @IS_NULLABLE
    public String getHoldReason();

    public void setHoldReason(String var1);

    @IS_VIRTUAL
    public Date getExpectedDeliveryDate();

    public List<OrderIntransitEvent> getIntransitUpdates();

    @IS_VIRTUAL
    public User getShipFromContact();

    @IS_NULLABLE
    public Long getMarketPlaceIntegrationId();

    public void setMarketPlaceIntegrationId(Long var1);

    public MarketPlaceIntegration getMarketPlaceIntegration();
}

