/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.db.model.order;

import com.venky.cache.Cache;
import com.venky.cache.UnboundedCache;
import com.venky.core.date.DateUtils;
import com.venky.core.util.Bucket;
import com.venky.core.util.ObjectUtil;
import com.venky.extension.Registry;
import com.venky.swf.db.Database;
import com.venky.swf.db.JdbcTypeHelper;
import com.venky.swf.db.model.Model;
import com.venky.swf.db.table.ModelImpl;
import com.venky.swf.plugins.background.core.CoreTask;
import com.venky.swf.plugins.background.core.TaskManager;
import com.venky.swf.plugins.collab.db.model.user.User;
import com.venky.swf.plugins.collab.db.model.user.UserFacility;
import in.succinct.plugins.ecommerce.agents.order.tasks.OrderStatusMonitor;
import in.succinct.plugins.ecommerce.db.model.inventory.InventoryCalculator;
import in.succinct.plugins.ecommerce.db.model.order.Order;
import in.succinct.plugins.ecommerce.db.model.order.OrderAddress;
import in.succinct.plugins.ecommerce.db.model.order.OrderAttribute;
import in.succinct.plugins.ecommerce.db.model.order.OrderLine;
import in.succinct.plugins.ecommerce.db.model.order.OrderStatus;
import in.succinct.plugins.ecommerce.db.model.participation.Facility;
import in.succinct.plugins.ecommerce.integration.fedex.RateWebServiceClient;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OrderImpl
extends ModelImpl<Order> {
    private Map<String, OrderAttribute> map = null;
    String orderNumber = null;
    Long preferredCarrierId;

    public OrderImpl() {
    }

    public OrderImpl(Order proxy) {
        super((Model)proxy);
    }

    public String getOrderNumber() {
        if (this.orderNumber == null) {
            this.orderNumber = ((Order)this.getProxy()).getId() == 0L ? "" : String.format("%019d", ((Order)this.getProxy()).getId());
        }
        return this.orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public synchronized Map<String, OrderAttribute> getAttributeMap() {
        if (this.map == null) {
            this.map = new UnboundedCache<String, OrderAttribute>(){
                private static final long serialVersionUID = 1L;

                protected OrderAttribute getValue(String name) {
                    OrderAttribute attr = (OrderAttribute)Database.getTable(OrderAttribute.class).newRecord();
                    attr.setName(name);
                    if (!((Order)OrderImpl.this.getProxy()).getRawRecord().isNewRecord()) {
                        attr.setOrderId(((Order)OrderImpl.this.getProxy()).getId());
                    }
                    return attr;
                }
            };
            ((Order)this.getProxy()).getAttributes().forEach(a -> this.map.put(a.getName(), (OrderAttribute)a));
        }
        return this.map;
    }

    public void saveAttributeMap(Map<String, OrderAttribute> map) {
        map.keySet().stream().sorted().forEach(a -> {
            OrderAttribute oa = (OrderAttribute)map.get(a);
            oa.setOrderId(((Order)this.getProxy()).getId());
            oa.save();
        });
    }

    public OrderAttribute getAttribute(String name) {
        Map<String, OrderAttribute> map = ((Order)this.getProxy()).getAttributeMap();
        if (map.containsKey(name)) {
            return map.get(name);
        }
        return null;
    }

    public void backorder() {
        Order order = (Order)this.getProxy();
        order.getOrderLines().forEach(ol -> ol.backorder());
    }

    public void acknowledge() {
        Order order = (Order)this.getProxy();
        Registry.instance().callExtensions("order.before.acknowledge", new Object[]{order});
        JdbcTypeHelper.TypeConverter iConv = order.getReflector().getJdbcTypeHelper().getTypeRef(Long.class).getTypeConverter();
        List<OrderLine> orderLines = order.getOrderLines();
        Cache<Long, List<InventoryCalculator.ATP>> skuATP = new Cache<Long, List<InventoryCalculator.ATP>>(){

            protected List<InventoryCalculator.ATP> getValue(Long aLong) {
                return new ArrayList<InventoryCalculator.ATP>();
            }
        };
        Bucket acknowledgedLineCount = new Bucket();
        Bucket rejectedLineCount = new Bucket();
        orderLines.forEach(arg_0 -> OrderImpl.lambda$acknowledge$3((Map)skuATP, acknowledgedLineCount, rejectedLineCount, arg_0));
        TaskManager.instance().execute((CoreTask)new OrderStatusMonitor(order.getId()));
    }

    public void reject() {
        this.cancel("OUT_OF_STOCK", "Company");
    }

    public void cancel(String reason, String initiator) {
        Order order = (Order)this.getProxy();
        order.getOrderLines().forEach(ol -> ol.cancel(reason, initiator));
        TaskManager.instance().execute((CoreTask)new OrderStatusMonitor(order.getId()));
    }

    public void cancel(String reason) {
        this.cancel(reason, "User");
    }

    public void pack() {
        Order order = (Order)this.getProxy();
        List toSort = order.getOrderLines();
        toSort.sort((o1, o2) -> {
            long ret = o1.getSkuId() - o2.getSkuId();
            if (ret == 0L) {
                ret = o1.getShipFromId() - o2.getShipFromId();
            }
            return (int)ret;
        });
        for (OrderLine ol : toSort) {
            ol.pack();
        }
        TaskManager.instance().execute((CoreTask)new OrderStatusMonitor(order.getId()));
    }

    public void ship() {
        Order order = (Order)this.getProxy();
        order.getOrderLines().stream().sorted(new Comparator<OrderLine>(){

            @Override
            public int compare(OrderLine o1, OrderLine o2) {
                long ret = o1.getSkuId() - o2.getSkuId();
                if (ret == 0L) {
                    ret = o1.getShipFromId() - o2.getShipFromId();
                }
                return (int)ret;
            }
        }).forEach(ol -> ol.ship());
        TaskManager.instance().execute((CoreTask)new OrderStatusMonitor(order.getId()));
    }

    public void deliver() {
        Order order = (Order)this.getProxy();
        order.getOrderLines().stream().sorted(new Comparator<OrderLine>(){

            @Override
            public int compare(OrderLine o1, OrderLine o2) {
                long ret = o1.getSkuId() - o2.getSkuId();
                if (ret == 0L) {
                    ret = o1.getShipFromId() - o2.getShipFromId();
                }
                return (int)ret;
            }
        }).forEach(ol -> ol.deliver());
        TaskManager.instance().execute((CoreTask)new OrderStatusMonitor(order.getId()));
    }

    public boolean isShort() {
        Bucket numShortLines = new Bucket();
        ((Order)this.getProxy()).getOrderLines().forEach(ol -> {
            if (ol.isShortage() && ol.getToShipQuantity() > 0.0) {
                numShortLines.increment();
            }
        });
        return numShortLines.intValue() > 0;
    }

    public Long getManifestId() {
        String value = this.getAttribute("manifest_id").getValue();
        long manifestId = (Long)this.getReflector().getJdbcTypeHelper().getTypeRef(Long.class).getTypeConverter().valueOf((Object)value);
        if (manifestId != 0L) {
            return manifestId;
        }
        return null;
    }

    public void setManifestId(Long id) {
    }

    public Date getExpectedDeliveryDate() {
        Order order = (Order)this.getProxy();
        Timestamp shipByDate = order.getShipByDate();
        Date expectedDeliveryDate = null;
        Optional<OrderStatus> orderShippedAudit = order.getOrderStatuses().stream().filter(os -> ObjectUtil.equals((Object)os.getFulfillmentStatus(), (Object)"SHIPPED")).findFirst();
        long shipDate = -1L;
        if (orderShippedAudit.isPresent()) {
            shipDate = orderShippedAudit.get().getStatusDate().getTime();
        } else {
            long today = DateUtils.getStartOfDay((long)System.currentTimeMillis());
            shipDate = shipByDate != null && shipByDate.getTime() >= today ? shipByDate.getTime() : today;
        }
        expectedDeliveryDate = new Date(shipDate + (long)this.getTransitDays() * 24L * 60L * 60L * 1000L);
        return expectedDeliveryDate;
    }

    public int getTransitDays() {
        Order order = (Order)this.getProxy();
        int transitDays = 5;
        Optional<OrderAddress> optionalShipTo = order.getAddresses().stream().filter(a -> ObjectUtil.equals((Object)a.getAddressType(), (Object)"ST")).findFirst();
        if (optionalShipTo.isPresent()) {
            Facility facility;
            OrderLine line;
            OrderAddress shipTo = optionalShipTo.get();
            List lines = order.getOrderLines();
            if (!lines.isEmpty() && (line = (OrderLine)lines.get(0)).getShipFromId() != null && (facility = line.getShipFrom()) != null) {
                transitDays = new RateWebServiceClient<OrderAddress>(facility, shipTo).getTransitTime().getTransitDays();
            }
        }
        return transitDays + 2;
    }

    public User getShipFromContact() {
        Order order = (Order)this.getProxy();
        User user = null;
        OrderLine sample = (OrderLine)order.getOrderLines().get(0);
        if (sample.getShipFromId() != null) {
            for (UserFacility fu : sample.getShipFrom().getFacilityUsers()) {
                if (!fu.getUser().isStaff()) continue;
                user = fu.getUser();
                break;
            }
        }
        return user;
    }

    public Long getPreferredCarrierId() {
        return this.preferredCarrierId;
    }

    public void setPreferredCarrierId(Long preferredCarrierId) {
        this.preferredCarrierId = preferredCarrierId;
        if (this.preferredCarrierId != null) {
            ((Order)this.getProxy()).setPreferredCarrierName(((Order)this.getProxy()).getPreferredCarrier().getName());
        }
    }

    private static /* synthetic */ void lambda$acknowledge$3(Map skuATP, Bucket acknowledgedLineCount, Bucket rejectedLineCount, OrderLine ol) {
        ol.acknowledge(skuATP, acknowledgedLineCount, rejectedLineCount, false);
    }
}

