/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.db.model.order;

import com.venky.core.util.Bucket;
import com.venky.swf.db.annotations.column.COLUMN_DEF;
import com.venky.swf.db.annotations.column.COLUMN_NAME;
import com.venky.swf.db.annotations.column.IS_NULLABLE;
import com.venky.swf.db.annotations.column.IS_VIRTUAL;
import com.venky.swf.db.annotations.column.UNIQUE_KEY;
import com.venky.swf.db.annotations.column.defaulting.StandardDefault;
import com.venky.swf.db.annotations.column.indexing.Index;
import com.venky.swf.db.annotations.column.pm.PARTICIPANT;
import com.venky.swf.db.annotations.column.ui.PROTECTION;
import com.venky.swf.db.annotations.column.validations.Enumeration;
import com.venky.swf.db.annotations.model.EXPORTABLE;
import com.venky.swf.db.annotations.model.ORDER_BY;
import com.venky.swf.db.model.Model;
import com.venky.swf.plugins.calendar.db.model.WorkSlot;
import in.succinct.plugins.ecommerce.db.model.inventory.Inventory;
import in.succinct.plugins.ecommerce.db.model.inventory.InventoryCalculator;
import in.succinct.plugins.ecommerce.db.model.inventory.Sku;
import in.succinct.plugins.ecommerce.db.model.order.Order;
import in.succinct.plugins.ecommerce.db.model.order.OrderLineAttribute;
import in.succinct.plugins.ecommerce.db.model.order.OrderLineItemAttributeValue;
import in.succinct.plugins.ecommerce.db.model.order.OrderLineUnitNumber;
import in.succinct.plugins.ecommerce.db.model.participation.Facility;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;

@ORDER_BY(value="ID")
@EXPORTABLE(value=false)
public interface OrderLine
extends Model {
    public static final String CANCELLATION_REASON_OUT_OF_STOCK = "OUT_OF_STOCK";
    public static final String CANCELLATION_REASON_WRONG_PRODUCT = "WRONG_PRODUCT";
    public static final String CANCELLATION_REASON_WRONG_PRICE = "WRONG_PRICE";
    public static final String CANCELLATION_REASON_PARTIAL_CANCEL_NOT_SUPPORTED = "PARTIAL_CANCEL_NOT_SUPPORTED";
    public static final String CANCELLATION_REASON_PARTIAL_LINE_CANCEL_NOT_SUPPORTED = "PARTIAL_LINE_CANCEL_NOT_SUPPORTED";
    public static final String CANCELLATION_REASON_NOT_REQUIRED = "NOT_REQUIRED";
    public static final String CANCELLATION_INITIATOR_COMPANY = "Company";
    public static final String CANCELLATION_INITIATOR_USER = "User";
    public static final String CANCELLATION_INITIATOR_MARKET_PLACE = "MarketPlaceRules";

    @UNIQUE_KEY(value="K1")
    @PARTICIPANT
    public long getOrderId();

    public void setOrderId(long var1);

    public Order getOrder();

    @UNIQUE_KEY(value="K1")
    @PARTICIPANT(redundant=true)
    @Index
    public long getSkuId();

    public void setSkuId(long var1);

    public Sku getSku();

    @UNIQUE_KEY(value="K1", allowMultipleRecordsWithNull=false)
    public Long getShipFromId();

    public void setShipFromId(Long var1);

    public Facility getShipFrom();

    @Index
    public Timestamp getAcknowledgeBy();

    public void setAcknowledgeBy(Timestamp var1);

    @Index
    public Timestamp getShipBy();

    public void setShipBy(Timestamp var1);

    @IS_NULLABLE
    public Timestamp getDeliveryExpectedNoEarlierThan();

    public void setDeliveryExpectedNoEarlierThan(Timestamp var1);

    @IS_NULLABLE
    public Timestamp getDeliveryExpectedNoLaterThan();

    public void setDeliveryExpectedNoLaterThan(Timestamp var1);

    public Long getInventoryId();

    public void setInventoryId(Long var1);

    public Inventory getInventory();

    @IS_NULLABLE
    public Long getWorkSlotId();

    public void setWorkSlotId(Long var1);

    public WorkSlot getWorkSlot();

    public double getOrderedQuantity();

    public void setOrderedQuantity(double var1);

    @IS_NULLABLE
    @Index
    public Timestamp getOrderedTs();

    public void setOrderedTs(Timestamp var1);

    @COLUMN_DEF(value=StandardDefault.ZERO)
    @PROTECTION(value=PROTECTION.Kind.NON_EDITABLE)
    public double getAcknowledgedQuantity();

    public void setAcknowledgedQuantity(double var1);

    @IS_NULLABLE
    @Index
    public Timestamp getAcknowledgedTs();

    public void setAcknowledgedTs(Timestamp var1);

    @COLUMN_DEF(value=StandardDefault.ZERO)
    @PROTECTION(value=PROTECTION.Kind.NON_EDITABLE)
    public double getPackedQuantity();

    public void setPackedQuantity(double var1);

    @IS_NULLABLE
    @Index
    public Timestamp getPackedTs();

    public void setPackedTs(Timestamp var1);

    @COLUMN_DEF(value=StandardDefault.ZERO)
    @PROTECTION(value=PROTECTION.Kind.NON_EDITABLE)
    public double getManifestedQuantity();

    public void setManifestedQuantity(double var1);

    @IS_NULLABLE
    @Index
    public Timestamp getManifestedTs();

    public void setManifestedTs(Timestamp var1);

    @COLUMN_DEF(value=StandardDefault.ZERO)
    @PROTECTION(value=PROTECTION.Kind.NON_EDITABLE)
    public double getShippedQuantity();

    public void setShippedQuantity(double var1);

    @IS_NULLABLE
    @Index
    public Timestamp getShippedTs();

    public void setShippedTs(Timestamp var1);

    @COLUMN_DEF(value=StandardDefault.ZERO)
    @PROTECTION(value=PROTECTION.Kind.NON_EDITABLE)
    public double getDeliveredQuantity();

    public void setDeliveredQuantity(double var1);

    @IS_NULLABLE
    @Index
    public Timestamp getDeliveredTs();

    public void setDeliveredTs(Timestamp var1);

    @COLUMN_DEF(value=StandardDefault.ZERO)
    @PROTECTION(value=PROTECTION.Kind.NON_EDITABLE)
    public double getCancelledQuantity();

    public void setCancelledQuantity(double var1);

    @IS_NULLABLE
    @Index
    public Timestamp getCancelledTs();

    public void setCancelledTs(Timestamp var1);

    @COLUMN_DEF(value=StandardDefault.ZERO)
    @PROTECTION(value=PROTECTION.Kind.NON_EDITABLE)
    public double getReturnedQuantity();

    public void setReturnedQuantity(double var1);

    @IS_VIRTUAL
    public double getRemainingCancellableQuantity();

    @IS_NULLABLE
    @Index
    public Timestamp getReturnedTs();

    public void setReturnedTs(Timestamp var1);

    public double getMaxRetailPrice();

    public void setMaxRetailPrice(double var1);

    @COLUMN_DEF(value=StandardDefault.ZERO)
    @COLUMN_NAME(value="DISCOUNT")
    public double getDiscountPercentage();

    public void setDiscountPercentage(double var1);

    public double getSellingPrice();

    public void setSellingPrice(double var1);

    public String getShipTogetherCode();

    public void setShipTogetherCode(String var1);

    @Enumeration(value=" ,Company,User,MarketPlaceRules")
    public String getCancellationInitiator();

    public void setCancellationInitiator(String var1);

    public String getCancellationReason();

    public void setCancellationReason(String var1);

    @COLUMN_DEF(value=StandardDefault.BOOLEAN_FALSE)
    public boolean isUnitNumberCaptureRequired();

    public void setUnitNumberCaptureRequired(boolean var1);

    public String getUnitNumberTypeRequired();

    public void setUnitNumberTypeRequired(String var1);

    public List<OrderLineAttribute> getAttributes();

    public Map<String, OrderLineAttribute> getAttributeMap();

    public void saveAttributeMap(Map<String, OrderLineAttribute> var1);

    public OrderLineAttribute getAttribute(String var1);

    public void pack();

    public void pack(double var1);

    public void pack(String var1);

    @IS_VIRTUAL
    public double getToDeliverQuantity();

    @IS_VIRTUAL
    public double getToShipQuantity();

    @IS_VIRTUAL
    public double getToPackQuantity();

    @IS_VIRTUAL
    public double getToAcknowledgeQuantity();

    @IS_VIRTUAL
    public double getToManifestQuantity();

    @UNIQUE_KEY(value="K1,ChannelOrderLine")
    public String getChannelOrderLineRef();

    public void setChannelOrderLineRef(String var1);

    public List<OrderLineUnitNumber> getUnitNumbers();

    @IS_VIRTUAL
    public Inventory getInventory(boolean var1);

    @IS_VIRTUAL
    public Inventory getInventory(boolean var1, long var2);

    @IS_VIRTUAL
    public List<Inventory> getInventories(boolean var1, long var2);

    public void ship();

    public void deliver();

    public void ship(double var1);

    public void deliver(double var1);

    @IS_NULLABLE
    public String getShippingCompany();

    public void setShippingCompany(String var1);

    @IS_NULLABLE
    public String getTrackingNumber();

    public void setTrackingNumber(String var1);

    public void reject(String var1);

    public void reject(String var1, double var2);

    public void cancel(String var1);

    public void cancel(String var1, double var2);

    public void cancel(String var1, String var2);

    public void cancel(String var1, String var2, double var3);

    public void acknowledge();

    public void acknowledge(boolean var1);

    public void acknowledge(Map<Long, List<InventoryCalculator.ATP>> var1, Bucket var2, Bucket var3, boolean var4);

    public void manifest();

    @COLUMN_DEF(value=StandardDefault.BOOLEAN_FALSE)
    public boolean isShortage();

    public void setShortage(boolean var1);

    public Double getIGst();

    public void setIGst(Double var1);

    public Double getCGst();

    public void setCGst(Double var1);

    public Double getSGst();

    public void setSGst(Double var1);

    public Double getPrice();

    public void setPrice(Double var1);

    @IS_VIRTUAL
    public double getProductSellingPrice();

    @IS_VIRTUAL
    public double getProductPrice();

    @IS_VIRTUAL
    public double getShippingSellingPrice();

    @IS_VIRTUAL
    public double getShippingPrice();

    @IS_VIRTUAL
    public String getHsn();

    public void backorder();

    @IS_NULLABLE
    public Long getFreeAgainstLineId();

    public void setFreeAgainstLineId(Long var1);

    public List<OrderLineItemAttributeValue> getOrderLineItemAttributeValues();
}

