/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.db.model.order;

import com.venky.cache.Cache;
import com.venky.cache.UnboundedCache;
import com.venky.core.date.DateUtils;
import com.venky.core.util.Bucket;
import com.venky.core.util.ObjectUtil;
import com.venky.geo.GeoCoordinate;
import com.venky.geo.GeoLocation;
import com.venky.swf.db.Database;
import com.venky.swf.db.model.Model;
import com.venky.swf.db.table.ModelImpl;
import com.venky.swf.plugins.calendar.db.model.WorkSlot;
import com.venky.swf.sql.Conjunction;
import com.venky.swf.sql.Expression;
import com.venky.swf.sql.Operator;
import com.venky.swf.sql.Select;
import in.succinct.plugins.ecommerce.db.model.apis.Cancel;
import in.succinct.plugins.ecommerce.db.model.apis.Pack;
import in.succinct.plugins.ecommerce.db.model.attributes.AssetCode;
import in.succinct.plugins.ecommerce.db.model.catalog.Item;
import in.succinct.plugins.ecommerce.db.model.catalog.ItemCategory;
import in.succinct.plugins.ecommerce.db.model.inventory.Inventory;
import in.succinct.plugins.ecommerce.db.model.inventory.InventoryCalculator;
import in.succinct.plugins.ecommerce.db.model.order.Order;
import in.succinct.plugins.ecommerce.db.model.order.OrderAddress;
import in.succinct.plugins.ecommerce.db.model.order.OrderLine;
import in.succinct.plugins.ecommerce.db.model.order.OrderLineAttribute;
import in.succinct.plugins.ecommerce.db.model.order.OrderLineItemAttributeValue;
import in.succinct.plugins.ecommerce.db.model.order.OrderLineUnitNumber;
import in.succinct.plugins.ecommerce.db.model.participation.Facility;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OrderLineImpl
extends ModelImpl<OrderLine> {
    private Map<String, OrderLineAttribute> map = null;
    private String hsn = null;

    public OrderLineImpl() {
    }

    public OrderLineImpl(OrderLine proxy) {
        super((Model)proxy);
    }

    public synchronized Map<String, OrderLineAttribute> getAttributeMap() {
        if (this.map == null) {
            this.map = new UnboundedCache<String, OrderLineAttribute>(){
                private static final long serialVersionUID = 1L;

                protected OrderLineAttribute getValue(String name) {
                    OrderLineAttribute attr = (OrderLineAttribute)Database.getTable(OrderLineAttribute.class).newRecord();
                    attr.setName(name);
                    if (!((OrderLine)OrderLineImpl.this.getProxy()).getRawRecord().isNewRecord()) {
                        attr.setOrderLineId(((OrderLine)OrderLineImpl.this.getProxy()).getId());
                    }
                    return attr;
                }
            };
            ((OrderLine)this.getProxy()).getAttributes().forEach(a -> this.map.put(a.getName(), (OrderLineAttribute)a));
        }
        return this.map;
    }

    public void saveAttributeMap(Map<String, OrderLineAttribute> map) {
        map.keySet().stream().sorted().forEach(a -> {
            OrderLineAttribute oa = (OrderLineAttribute)map.get(a);
            oa.setOrderLineId(((OrderLine)this.getProxy()).getId());
            oa.save();
        });
    }

    public OrderLineAttribute getAttribute(String name) {
        Map<String, OrderLineAttribute> map = ((OrderLine)this.getProxy()).getAttributeMap();
        if (map.containsKey(name)) {
            return map.get(name);
        }
        return null;
    }

    public void pack() {
        this.pack(this.getToPackQuantity());
    }

    public void pack(double quantity) {
        double remainingQuantityToPack;
        OrderLine orderLine = (OrderLine)this.getProxy();
        double quantityAcknowledged = orderLine.getAcknowledgedQuantity();
        if (quantityAcknowledged < quantity + orderLine.getPackedQuantity()) {
            orderLine.acknowledge(true);
        }
        if (quantity > (remainingQuantityToPack = orderLine.getToPackQuantity())) {
            throw new Pack.PackValidationException("Quantity " + quantity + " Exceeds quantity remaining to be packed" + remainingQuantityToPack);
        }
        orderLine.setPackedQuantity(orderLine.getPackedQuantity() + quantity);
        orderLine.save();
    }

    public void pack(String unitNumber) {
        OrderLine ol = (OrderLine)this.getProxy();
        OrderLineUnitNumber scanned = (OrderLineUnitNumber)Database.getTable(OrderLineUnitNumber.class).newRecord();
        scanned.setOrderLineId(ol.getId());
        scanned.setUnitNumberType(ol.getUnitNumberTypeRequired());
        scanned.setUnitNumber(unitNumber);
        scanned.save();
        this.pack(1.0);
    }

    public double getRemainingCancellableQuantity() {
        return ((OrderLine)this.getProxy()).getOrderedQuantity() - ((OrderLine)this.getProxy()).getCancelledQuantity() - ((OrderLine)this.getProxy()).getReturnedQuantity();
    }

    public double getToShipQuantity() {
        OrderLine ol = (OrderLine)this.getProxy();
        return Math.max(0.0, this.getRemainingCancellableQuantity() - ol.getShippedQuantity());
    }

    public double getToDeliverQuantity() {
        OrderLine ol = (OrderLine)this.getProxy();
        return Math.max(0.0, ol.getShippedQuantity() - Math.max(ol.getReturnedQuantity(), ol.getDeliveredQuantity()));
    }

    public double getToAcknowledgeQuantity() {
        OrderLine ol = (OrderLine)this.getProxy();
        return Math.max(0.0, this.getToShipQuantity() - ol.getAcknowledgedQuantity());
    }

    public double getToPackQuantity() {
        OrderLine ol = (OrderLine)this.getProxy();
        return Math.max(0.0, this.getToShipQuantity() - ol.getPackedQuantity());
    }

    public double getToManifestQuantity() {
        OrderLine ol = (OrderLine)this.getProxy();
        return Math.max(0.0, this.getToShipQuantity() - ol.getManifestedQuantity());
    }

    public void ship() {
        this.ship(((OrderLine)this.getProxy()).getToShipQuantity());
    }

    public void ship(double quantity) {
        OrderLine ol = (OrderLine)this.getProxy();
        double remainingShippableQuantity = ol.getToShipQuantity();
        if (quantity > remainingShippableQuantity) {
            throw new IllegalArgumentException("Quantity " + quantity + " Exceeds quantity remaining to be shipped" + remainingShippableQuantity);
        }
        if (ol.getPackedQuantity() < quantity + ol.getShippedQuantity()) {
            ol.pack(quantity - ol.getPackedQuantity());
        }
        ol.setShippedQuantity(ol.getShippedQuantity() + quantity);
        ol.save();
    }

    public void deliver() {
        OrderLine ol = (OrderLine)this.getProxy();
        Item item = ol.getSku().getItem();
        if (item.getAssetCodeId() != null && item.getAssetCode().isSac()) {
            ol.pack();
            ol.ship();
        } else {
            ol.ship();
        }
        this.deliver(ol.getToDeliverQuantity());
    }

    public void deliver(double quantity) {
        OrderLine ol = (OrderLine)this.getProxy();
        double remainingDeliverableQuanity = ol.getToDeliverQuantity();
        if (quantity > remainingDeliverableQuanity) {
            throw new IllegalArgumentException("Quantity " + quantity + " Exceeds quantity remaining to be delivered" + remainingDeliverableQuanity);
        }
        ol.setDeliveredQuantity(ol.getDeliveredQuantity() + quantity);
        ol.save();
    }

    public void reject(String reason) {
        this.cancel(reason, "Company", this.getRemainingCancellableQuantity());
    }

    public void cancel(String reason) {
        this.cancel(reason, "User", this.getRemainingCancellableQuantity());
    }

    public void reject(String reason, double quantity) {
        this.cancel(reason, "Company", quantity);
    }

    public void cancel(String reason, double quantity) {
        this.cancel(reason, "User", quantity);
    }

    public void cancel(String reason, String initiator) {
        this.cancel(reason, initiator, this.getRemainingCancellableQuantity());
    }

    public void cancel(String reason, String initiator, double quantity) {
        boolean backOrder;
        double quantityReturnable;
        OrderLine orderLine = (OrderLine)this.getProxy();
        double quantityCancellable = orderLine.getToShipQuantity();
        if (quantity > quantityCancellable + (quantityReturnable = orderLine.getShippedQuantity() - orderLine.getReturnedQuantity())) {
            throw new Cancel.OrderCancellationException("Cannot cancel more than " + quantityCancellable + quantityReturnable);
        }
        double quantityToCancel = quantity;
        boolean bl = backOrder = ObjectUtil.isVoid((Object)initiator) && ObjectUtil.isVoid((Object)reason);
        if (quantityToCancel > 0.0) {
            if (backOrder) {
                if (quantityCancellable > 0.0) {
                    double quantityBackOrdered = Collections.min(Arrays.asList(quantityToCancel, quantityCancellable, orderLine.getAcknowledgedQuantity()));
                    orderLine.setManifestedQuantity(Math.max(0.0, orderLine.getManifestedQuantity() - quantityBackOrdered));
                    orderLine.setPackedQuantity(Math.max(0.0, orderLine.getPackedQuantity() - quantityBackOrdered));
                    orderLine.setAcknowledgedQuantity(orderLine.getAcknowledgedQuantity() - quantityBackOrdered);
                }
            } else {
                if (quantityCancellable > 0.0) {
                    double quantityCancelled = Math.min(quantityToCancel, quantityCancellable);
                    orderLine.setCancelledQuantity(orderLine.getCancelledQuantity() + quantityCancelled);
                    quantityToCancel -= quantityCancelled;
                }
                orderLine.setReturnedQuantity(orderLine.getReturnedQuantity() + quantityToCancel);
                if (orderLine.getReflector().isVoid((Object)orderLine.getCancellationReason())) {
                    orderLine.setCancellationReason(reason);
                }
                if (orderLine.getReflector().isVoid((Object)orderLine.getCancellationInitiator())) {
                    orderLine.setCancellationInitiator(initiator);
                }
            }
        }
        orderLine.save();
    }

    public Inventory getInventory(boolean lock) {
        OrderLine line = (OrderLine)this.getProxy();
        if (line.getInventoryId() != null) {
            if (!lock) {
                return line.getInventory();
            }
            return (Inventory)Database.getTable(Inventory.class).lock(line.getInventoryId().longValue());
        }
        return this.getInventory(lock, line.getSkuId());
    }

    public Inventory getInventory(boolean lock, long skuId) {
        List<Inventory> inventories = this.getInventories(lock, skuId);
        if (inventories.isEmpty()) {
            return null;
        }
        return inventories.get(0);
    }

    public List<Inventory> getInventories(boolean lock, long skuId) {
        OrderLine line = (OrderLine)this.getProxy();
        Select s = new Select(lock, new String[0]).from(new Class[]{Inventory.class});
        Expression w = new Expression(s.getPool(), Conjunction.AND);
        w.add(new Expression(s.getPool(), "FACILITY_ID", Operator.EQ, (Object[])new Long[]{line.getShipFromId()}));
        w.add(new Expression(s.getPool(), "SKU_ID", Operator.EQ, (Object[])new Long[]{skuId}));
        w.add(new Expression(s.getPool(), "QUANTITY", Operator.GE, (Object[])new Double[]{line.getToShipQuantity()}));
        s.where(w);
        for (OrderLineItemAttributeValue orderLineItemAttributeValue : line.getOrderLineItemAttributeValues()) {
            s.add(" and exists (select 1 from inventory_attributes where inventory_id  = inventories.id and attribute_value_id  = " + orderLineItemAttributeValue.getAttributeValueId() + ")");
        }
        List inventories = s.orderBy(new String[]{"FACILITY_ID", "SKU_ID", "ID"}).execute();
        return inventories;
    }

    public void backorder() {
        this.cancel("", "");
    }

    public void acknowledge() {
        this.acknowledge(false);
    }

    public void acknowledge(boolean force) {
        if (force) {
            ((OrderLine)this.getProxy()).setAcknowledgedQuantity(this.getRemainingCancellableQuantity());
        } else {
            Cache<Long, List<InventoryCalculator.ATP>> skuATP = new Cache<Long, List<InventoryCalculator.ATP>>(){

                protected List<InventoryCalculator.ATP> getValue(Long skuId) {
                    return new ArrayList<InventoryCalculator.ATP>();
                }
            };
            Bucket acknowlededCounter = new Bucket();
            Bucket rejectCounter = new Bucket();
            this.acknowledge((Map<Long, List<InventoryCalculator.ATP>>)skuATP, acknowlededCounter, rejectCounter, false);
        }
    }

    public void acknowledge(Map<Long, List<InventoryCalculator.ATP>> skuATP, Bucket acknowledgedLineCounter, Bucket rejectLineCounter, boolean cancelOnShortage) {
        OrderLine ol = (OrderLine)this.getProxy();
        Order order = ol.getOrder();
        if (ol.getToAcknowledgeQuantity() > 0.0) {
            if (!skuATP.containsKey(ol.getSkuId())) {
                InventoryCalculator invCalculator = new InventoryCalculator(ol);
                for (InventoryCalculator.ATP atp : invCalculator.getInventory()) {
                    skuATP.get(atp.getInventory().getSkuId()).add(atp);
                }
                List<InventoryCalculator.ATP> atpList = skuATP.get(ol.getSkuId());
                if (!atpList.isEmpty()) {
                    OrderAddress shipToAddress;
                    HashSet<Long> shipNodeIds = new HashSet<Long>();
                    for (InventoryCalculator.ATP atp : atpList) {
                        shipNodeIds.add(atp.getInventory().getFacilityId());
                    }
                    Select select = new Select(new String[0]).from(new Class[]{Facility.class});
                    List facilities = select.where(new Expression(select.getPool(), "ID", Operator.IN, shipNodeIds.toArray())).execute();
                    final HashMap facilityMap = new HashMap();
                    facilities.forEach(f -> facilityMap.put(f.getId(), f));
                    List shipToAddresses = order.getAddresses().stream().filter(a -> "ST".equals(a.getAddressType())).collect(Collectors.toList());
                    OrderAddress orderAddress = shipToAddress = shipToAddresses.isEmpty() ? null : (OrderAddress)shipToAddresses.get(0);
                    if (shipToAddress == null) {
                        throw new RuntimeException("Don't know where to ship the order " + order.getId());
                    }
                    atpList.sort(new Comparator<InventoryCalculator.ATP>(){

                        @Override
                        public int compare(InventoryCalculator.ATP o1, InventoryCalculator.ATP o2) {
                            double d2;
                            Facility f1 = (Facility)facilityMap.get(o1.getInventory().getFacilityId());
                            Facility f2 = (Facility)facilityMap.get(o2.getInventory().getFacilityId());
                            double d1 = new GeoCoordinate((GeoLocation)f1).distanceTo(new GeoCoordinate((GeoLocation)shipToAddress));
                            int ret = (int)(d1 - (d2 = new GeoCoordinate((GeoLocation)f2).distanceTo(new GeoCoordinate((GeoLocation)shipToAddress))));
                            if (ret == 0) {
                                ret = (int)(o1.getDemandDate() - o2.getDemandDate());
                            }
                            if (ret == 0 && o1.getSlotId() != null && o2.getSlotId() != null) {
                                ret = o1.getSlot().getStartTime().compareTo(o2.getSlot().getStartTime());
                            }
                            if (ret == 0) {
                                ret = (int)(f1.getId() - f2.getId());
                            }
                            return ret;
                        }
                    });
                }
            }
            if (!skuATP.get(ol.getSkuId()).isEmpty()) {
                ol.setShortage(true);
                for (InventoryCalculator.ATP atp : skuATP.get(ol.getSkuId())) {
                    if (atp.getQuantity().doubleValue() < ol.getToAcknowledgeQuantity()) continue;
                    ol.setShipFromId(atp.getInventory().getFacilityId());
                    ol.setInventoryId(atp.getInventory().getId());
                    long date = atp.getDemandDate();
                    if (atp.getSlotId() != null && date > 0L) {
                        Calendar calendar = Calendar.getInstance();
                        WorkSlot slot = atp.getSlot();
                        calendar.setTimeInMillis(date + DateUtils.getTime((String)slot.getStartTime()).getTime());
                        ol.setDeliveryExpectedNoEarlierThan(new Timestamp(calendar.getTimeInMillis()));
                        calendar.setTimeInMillis(date + DateUtils.getTime((String)slot.getEndTime()).getTime());
                        ol.setDeliveryExpectedNoLaterThan(new Timestamp(calendar.getTimeInMillis()));
                        ol.setWorkSlotId(atp.getSlotId());
                    }
                    atp.getQuantity().decrement(ol.getToAcknowledgeQuantity());
                    ol.setAcknowledgedQuantity(ol.getAcknowledgedQuantity() + ol.getToAcknowledgeQuantity());
                    ol.setShortage(false);
                    acknowledgedLineCounter.increment();
                    break;
                }
            } else {
                ol.setShortage(true);
            }
            if (ol.isShortage() && cancelOnShortage) {
                ol.setCancelledQuantity(ol.getOrderedQuantity());
                ol.setCancellationReason("OUT_OF_STOCK");
                ol.setCancellationInitiator("Company");
                rejectLineCounter.increment();
            }
            ol.save();
        }
    }

    public void manifest() {
        OrderLine line = (OrderLine)this.getProxy();
        if (line.getToManifestQuantity() > 0.0) {
            line.setManifestedQuantity(line.getToManifestQuantity());
            line.save();
        }
    }

    public String getHsn() {
        OrderLine line;
        if (this.hsn == null && !(line = (OrderLine)this.getProxy()).getReflector().isVoid((Object)line.getSkuId())) {
            AssetCode assetCode;
            Item item = line.getSku().getItem();
            if (item.getAssetCodeId() != null && (assetCode = item.getAssetCode()).isHsn()) {
                return assetCode.getCode();
            }
            ItemCategory category = line.getSku().getItem().getItemCategory("HSN");
            this.hsn = category != null ? category.getMasterItemCategoryValue().getAllowedValue() : "";
        }
        return this.hsn;
    }

    public double getProductSellingPrice() {
        return ((OrderLine)this.getProxy()).getSellingPrice();
    }

    public double getProductPrice() {
        return (Double)Database.getJdbcTypeHelper((String)((OrderLine)this.getProxy()).getReflector().getPool()).getTypeRef(Double.TYPE).getTypeConverter().valueOf((Object)((OrderLine)this.getProxy()).getPrice());
    }

    public double getShippingSellingPrice() {
        return 0.0;
    }

    public double getShippingPrice() {
        return 0.0;
    }
}

