/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.db.model.participation;

import com.venky.swf.db.model.Model;
import com.venky.swf.db.table.ModelImpl;
import in.succinct.plugins.ecommerce.db.model.order.FedexTransitTime;
import in.succinct.plugins.ecommerce.db.model.order.Order;
import in.succinct.plugins.ecommerce.db.model.order.OrderAddress;
import in.succinct.plugins.ecommerce.db.model.order.OrderLine;
import in.succinct.plugins.ecommerce.db.model.participation.Facility;
import in.succinct.plugins.ecommerce.db.model.participation.PreferredCarrier;
import in.succinct.plugins.ecommerce.integration.fedex.RateWebServiceClient;
import java.util.List;
import java.util.stream.Collectors;

public class PreferredCarrierImpl
extends ModelImpl<PreferredCarrier> {
    public PreferredCarrierImpl(PreferredCarrier preferredCarrier) {
        super((Model)preferredCarrier);
    }

    public PreferredCarrierImpl() {
    }

    public Double getEstimatedShippingCharges(Order order) {
        PreferredCarrier carrier = (PreferredCarrier)this.getProxy();
        if (!carrier.getName().equalsIgnoreCase("FedEx")) {
            return null;
        }
        List lines = order.getOrderLines();
        if (!lines.isEmpty()) {
            List addresses;
            Facility facility = null;
            for (OrderLine line : lines) {
                if (line.getShipFromId() == null) continue;
                facility = line.getShipFrom();
                break;
            }
            if (facility != null && !(addresses = order.getAddresses().stream().filter(oa -> oa.getAddressType().equals("ST")).collect(Collectors.toList())).isEmpty()) {
                FedexTransitTime transitTime = new RateWebServiceClient<OrderAddress>(carrier, facility, (OrderAddress)addresses.get(0)).getTransitTime();
                return transitTime.getRateFor1KgPackage();
            }
        }
        return null;
    }
}

