/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.db.model.service;

import com.venky.swf.db.annotations.column.COLUMN_DEF;
import com.venky.swf.db.annotations.column.COLUMN_SIZE;
import com.venky.swf.db.annotations.column.IS_NULLABLE;
import com.venky.swf.db.annotations.column.IS_VIRTUAL;
import com.venky.swf.db.annotations.column.UNIQUE_KEY;
import com.venky.swf.db.annotations.column.defaulting.StandardDefault;
import com.venky.swf.db.annotations.column.indexing.Index;
import com.venky.swf.db.annotations.column.pm.PARTICIPANT;
import com.venky.swf.db.annotations.column.ui.HIDDEN;
import com.venky.swf.db.annotations.column.validations.Enumeration;
import com.venky.swf.db.annotations.model.EXPORTABLE;
import com.venky.swf.db.annotations.model.MENU;
import com.venky.swf.db.model.Model;
import com.venky.swf.plugins.collab.db.model.CompanySpecific;
import in.succinct.plugins.ecommerce.db.model.catalog.Service;
import in.succinct.plugins.ecommerce.db.model.participation.ExtendedEntity;
import in.succinct.plugins.ecommerce.db.model.participation.User;
import in.succinct.plugins.ecommerce.db.model.service.ServiceCancellationReason;
import in.succinct.plugins.ecommerce.db.model.service.ServiceOrderAddress;
import in.succinct.plugins.ecommerce.db.model.service.ServiceOrderAttribute;
import in.succinct.plugins.ecommerce.db.model.service.ServiceOrderPrint;
import java.sql.Timestamp;
import java.util.List;

@MENU(value="Fulfillment")
@EXPORTABLE(value=false)
public interface ServiceOrder
extends ExtendedEntity<ServiceOrderAttribute, ServiceOrderAddress, ServiceOrderPrint>,
Model,
CompanySpecific {
    public static final String FULFILLMENT_STATUS_OPEN = "OPEN";
    public static final String FULFILLMENT_STATUS_COMPLETE = "COMPLETED";
    public static final String FULFILLMENT_STATUS_CANCELLED = "CANCELLED";
    public static final String CANCELLATION_INITIATOR_COMPANY = "Company";
    public static final String CANCELLATION_INITIATOR_USER = "User";

    @UNIQUE_KEY(value="K1,K2")
    public long getId();

    public String getReference();

    public void setReference(String var1);

    @PARTICIPANT(value="USER")
    @COLUMN_DEF(value=StandardDefault.CURRENT_USER)
    @IS_NULLABLE(value=false)
    @Index
    public Long getUserId();

    public void setUserId(Long var1);

    public User getUser();

    @IS_NULLABLE
    @Index
    @PARTICIPANT(redundant=true)
    public Long getServicedById();

    public void setServicedById(Long var1);

    public User getServicedBy();

    @IS_VIRTUAL
    public String getOrderNumber();

    @IS_VIRTUAL
    @HIDDEN
    public boolean isOpen();

    @Enumeration(value="OPEN,COMPLETED,CANCELLED")
    @COLUMN_DEF(value=StandardDefault.SOME_VALUE, args="OPEN")
    @Index
    public String getFulfillmentStatus();

    public void setFulfillmentStatus(String var1);

    @PARTICIPANT(redundant=true)
    public Long getCancellationReasonId();

    public void setCancellationReasonId(Long var1);

    public ServiceCancellationReason getCancellationReason();

    @COLUMN_SIZE(value=1024)
    public String getRemarks();

    public void setRemarks(String var1);

    @PARTICIPANT(redundant=true)
    @Index
    public long getServiceId();

    public void setServiceId(long var1);

    public Service getService();

    @Override
    public List<ServiceOrderAddress> getAddresses();

    @Override
    public List<ServiceOrderAttribute> getAttributes();

    public void reject();

    public void cancel();

    public void cancel(String var1, String var2);

    @Enumeration(value=" ,Company,User")
    @COLUMN_DEF(value=StandardDefault.SOME_VALUE, args=" ")
    public String getCancellationInitiatedBy();

    public void setCancellationInitiatedBy(String var1);

    public void complete();

    @Override
    public List<ServiceOrderPrint> getPrints();

    @COLUMN_DEF(value=StandardDefault.BOOLEAN_FALSE)
    public boolean isCOD();

    public void setCOD(Boolean var1);

    public String getDescription();

    public void setDescription(String var1);

    @IS_NULLABLE(value=true)
    @Index
    @UNIQUE_KEY(value="K2")
    public Timestamp getEarliestBy();

    public void setEarliestBy(Timestamp var1);

    @IS_NULLABLE(value=true)
    @Index
    @UNIQUE_KEY(value="K2")
    public Timestamp getLatestBy();

    public void setLatestBy(Timestamp var1);

    public static enum ServiceStatus {
        OPEN,
        COMPLETED,
        CANCELLED;

    }
}

