/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.db.model.service;

import com.venky.core.util.ObjectUtil;
import in.succinct.plugins.ecommerce.db.model.participation.ExtendedEntityImpl;
import in.succinct.plugins.ecommerce.db.model.service.ServiceCancellationReason;
import in.succinct.plugins.ecommerce.db.model.service.ServiceOrder;
import in.succinct.plugins.ecommerce.db.model.service.ServiceOrderAddress;
import in.succinct.plugins.ecommerce.db.model.service.ServiceOrderAttribute;
import in.succinct.plugins.ecommerce.db.model.service.ServiceOrderPrint;

public class ServiceOrderImpl
extends ExtendedEntityImpl<ServiceOrder, ServiceOrderAttribute, ServiceOrderAddress, ServiceOrderPrint> {
    public ServiceOrderImpl() {
    }

    public ServiceOrderImpl(ServiceOrder serviceOrder) {
        super(serviceOrder);
    }

    public String getOrderNumber() {
        return String.valueOf(((ServiceOrder)this.getProxy()).getId());
    }

    public void reject() {
        ServiceOrder order = (ServiceOrder)this.getProxy();
        if (ObjectUtil.isVoid((Object)order.getCancellationReason())) {
            for (ServiceCancellationReason reason : order.getService().getServiceCancellationReasons()) {
                if (!ObjectUtil.equals((Object)reason.getInitiator(), (Object)"Company") || !reason.isDefaultReason()) continue;
                order.setCancellationReasonId(reason.getId());
                break;
            }
        }
        this.cancel("Company");
    }

    public void cancel() {
        ServiceOrder order = (ServiceOrder)this.getProxy();
        if (ObjectUtil.isVoid((Object)order.getCancellationReason())) {
            for (ServiceCancellationReason reason : order.getService().getServiceCancellationReasons()) {
                if (!ObjectUtil.equals((Object)reason.getInitiator(), (Object)"User") || !reason.isDefaultReason()) continue;
                order.setCancellationReasonId(reason.getId());
                break;
            }
        }
        this.cancel("User");
    }

    public void cancel(String initiator) {
        ServiceOrder order = (ServiceOrder)this.getProxy();
        if (!ObjectUtil.equals((Object)"CANCELLED", (Object)order.getFulfillmentStatus())) {
            if (ObjectUtil.isVoid((Object)order.getCancellationReasonId())) {
                throw new RuntimeException("Please provide us your reason for cancellation.");
            }
            if (order.getCancellationReason().isRemarksRequired() && ObjectUtil.isVoid((Object)order.getRemarks())) {
                throw new RuntimeException("Please provide with additional remarks.");
            }
            order.setFulfillmentStatus("CANCELLED");
            order.setCancellationInitiatedBy(initiator);
            order.save();
        }
    }

    public void complete() {
        ServiceOrder order = (ServiceOrder)this.getProxy();
        order.setFulfillmentStatus("COMPLETED");
        order.save();
    }

    public boolean isOpen() {
        switch (((ServiceOrder)this.getProxy()).getFulfillmentStatus()) {
            case "CANCELLED": 
            case "COMPLETED": {
                return false;
            }
        }
        return true;
    }
}

