/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.extensions.assets;

import com.venky.swf.db.extensions.BeforeModelValidateExtension;
import com.venky.swf.plugins.background.core.CoreTask;
import com.venky.swf.plugins.background.core.TaskManager;
import in.succinct.plugins.ecommerce.agents.asset.HashAssetTask;
import in.succinct.plugins.ecommerce.db.model.assets.Asset;
import in.succinct.plugins.ecommerce.db.model.assets.AssetAttributeValue;
import in.succinct.plugins.ecommerce.db.model.assets.Capability;
import in.succinct.plugins.ecommerce.db.model.attributes.AssetCode;
import java.util.HashSet;

public class BeforeValidateAssetAttributeValue
extends BeforeModelValidateExtension<AssetAttributeValue> {
    public void beforeValidate(AssetAttributeValue model) {
        if (model.getReflector().isVoid((Object)model.getAttributeId()) && !model.getReflector().isVoid((Object)model.getAttributeValueId())) {
            model.setAttributeId(model.getAttributeValue().getAttributeId());
        }
        HashSet allowedAttributeIds = new HashSet();
        HashSet<String> assetCodeDescriptions = new HashSet<String>();
        Asset asset = model.getAsset();
        for (Capability capability : asset.getAssetCapabilities()) {
            AssetCode assetCode = capability.getAssetCode();
            assetCode.getAssetCodeAttributes().forEach(aca -> allowedAttributeIds.add(aca.getAttributeId()));
            assetCodeDescriptions.add(assetCode.getLongDescription());
        }
        if (allowedAttributeIds.isEmpty()) {
            throw new RuntimeException("Don't know what asset code this asset belongs to.");
        }
        if (!allowedAttributeIds.contains(model.getAttributeValue().getAttributeId())) {
            throw new RuntimeException("Not a valid attribute for an asset with asset_code(s) of " + assetCodeDescriptions);
        }
        TaskManager.instance().executeAsync((CoreTask)new HashAssetTask(model.getAssetId()), false);
    }

    static {
        BeforeValidateAssetAttributeValue.registerExtension((BeforeModelValidateExtension)new BeforeValidateAssetAttributeValue());
    }
}

