/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.extensions.catalog;

import com.venky.core.util.ObjectUtil;
import com.venky.swf.db.extensions.BeforeModelValidateExtension;
import com.venky.swf.plugins.background.core.CoreTask;
import com.venky.swf.plugins.background.core.TaskManager;
import in.succinct.plugins.ecommerce.agents.catalog.HashItemTask;
import in.succinct.plugins.ecommerce.db.model.catalog.Item;
import in.succinct.plugins.ecommerce.db.model.catalog.ItemAttributeValue;
import java.util.HashSet;

public class BeforeValidateItemAttributeValue
extends BeforeModelValidateExtension<ItemAttributeValue> {
    public void beforeValidate(ItemAttributeValue model) {
        if (model.getReflector().isVoid((Object)model.getAttributeId()) && !model.getReflector().isVoid((Object)model.getAttributeValueId())) {
            model.setAttributeId(model.getAttributeValue().getAttributeId());
        }
        Item item = model.getItem();
        HashSet allowedAttributeIds = new HashSet();
        if (!item.getReflector().isVoid((Object)item.getAssetCodeId())) {
            item.getAssetCode().getAssetCodeAttributes().forEach(aca -> {
                if (ObjectUtil.equals((Object)aca.getAttributeType(), (Object)"Catalog")) {
                    allowedAttributeIds.add(aca.getAttributeId());
                }
            });
        }
        if (allowedAttributeIds.isEmpty()) {
            throw new RuntimeException("Select attributes based on the asset code the item " + model.getItem().getName() + " belongs to.");
        }
        if (!allowedAttributeIds.contains(model.getAttributeValue().getAttributeId())) {
            throw new RuntimeException("Not a valid attribute for an item with asset_code of " + model.getItem().getAssetCode().getLongDescription());
        }
        TaskManager.instance().executeAsync((CoreTask)new HashItemTask(model.getItemId()), false);
    }

    static {
        BeforeValidateItemAttributeValue.registerExtension((BeforeModelValidateExtension)new BeforeValidateItemAttributeValue());
    }
}

