/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.extensions.inventory;

import com.venky.core.util.ObjectUtil;
import com.venky.swf.db.extensions.BeforeModelValidateExtension;
import com.venky.swf.plugins.background.core.CoreTask;
import com.venky.swf.plugins.background.core.TaskManager;
import in.succinct.plugins.ecommerce.agents.inventory.HashInventoryTask;
import in.succinct.plugins.ecommerce.db.model.catalog.Item;
import in.succinct.plugins.ecommerce.db.model.inventory.InventoryAttributeValue;
import java.util.HashSet;

public class BeforeValidateInventoryAttributeValue
extends BeforeModelValidateExtension<InventoryAttributeValue> {
    public void beforeValidate(InventoryAttributeValue model) {
        if (model.getReflector().isVoid((Object)model.getAttributeId()) && !model.getReflector().isVoid((Object)model.getAttributeValueId())) {
            model.setAttributeId(model.getAttributeValue().getAttributeId());
        }
        Item item = (Item)model.getInventory().getSku().getItem().getRawRecord().getAsProxy(Item.class);
        HashSet allowedAttributeIds = new HashSet();
        if (!item.getReflector().isVoid((Object)item.getAssetCodeId())) {
            item.getAssetCode().getAssetCodeAttributes().forEach(aca -> {
                if (ObjectUtil.equals((Object)aca.getAttributeType(), (Object)"Inventory")) {
                    allowedAttributeIds.add(aca.getAttributeId());
                }
            });
        }
        if (allowedAttributeIds.isEmpty()) {
            throw new RuntimeException("Don't what what asset code the item " + item.getName() + " belongs to.");
        }
        if (!allowedAttributeIds.contains(model.getAttributeId())) {
            throw new RuntimeException("Not a valid attribute to track in inventory for item with asset_code of " + item.getAssetCode().getLongDescription());
        }
        TaskManager.instance().executeAsync((CoreTask)new HashInventoryTask(model.getInventoryId()), false);
    }

    static {
        BeforeValidateInventoryAttributeValue.registerExtension((BeforeModelValidateExtension)new BeforeValidateInventoryAttributeValue());
    }
}

