/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.extensions.order;

import com.venky.cache.Cache;
import com.venky.swf.db.Database;
import com.venky.swf.db.extensions.BeforeModelSaveExtension;
import com.venky.swf.db.model.reflection.ModelReflector;
import com.venky.swf.plugins.background.core.CoreTask;
import com.venky.swf.plugins.background.core.TaskManager;
import com.venky.swf.sql.Expression;
import com.venky.swf.sql.Operator;
import com.venky.swf.sql.Select;
import in.succinct.plugins.ecommerce.agents.order.tasks.pack.PacklistPrintTask;
import in.succinct.plugins.ecommerce.agents.order.tasks.ship.CreateManifestTask;
import in.succinct.plugins.ecommerce.db.model.order.Order;
import in.succinct.plugins.ecommerce.db.model.order.OrderLine;
import in.succinct.plugins.ecommerce.db.model.order.OrderStatus;
import in.succinct.plugins.ecommerce.db.model.participation.Facility;
import in.succinct.plugins.ecommerce.integration.MarketPlace;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class BeforeSaveOrder
extends BeforeModelSaveExtension<Order> {
    public void beforeSave(final Order order) {
        List<Object> lines = order.getRawRecord().isNewRecord() ? new ArrayList() : order.getOrderLines();
        Facility facility = lines.isEmpty() ? null : ((OrderLine)lines.get(0)).getShipFrom();
        List<Object> marketPlaceIntegrations = facility != null && !facility.getPreferredMarketPlaceIntegrations().isEmpty() ? MarketPlace.get(facility.getId()) : new ArrayList();
        if (order.getFulfillmentStatus().equals("DELIVERED") && order.getRawRecord().isFieldDirty("FULFILLMENT_STATUS")) {
            for (MarketPlace marketPlace : marketPlaceIntegrations) {
                marketPlace.getWarehouseActionHandler().deliver(order);
            }
        } else if (order.getFulfillmentStatus().equals("SHIPPED") && order.getRawRecord().isFieldDirty("FULFILLMENT_STATUS")) {
            for (MarketPlace marketPlace : marketPlaceIntegrations) {
                marketPlace.getWarehouseActionHandler().ship(order);
            }
        } else if (order.getFulfillmentStatus().equals("MANIFESTED") && order.getRawRecord().isFieldDirty("FULFILLMENT_STATUS")) {
            TaskManager.instance().executeAsync((CoreTask)new PacklistPrintTask(order.getId()), false);
            for (MarketPlace marketPlace : marketPlaceIntegrations) {
                marketPlace.getWarehouseActionHandler().pack(order);
            }
        } else if (order.getFulfillmentStatus().equals("PACKED") && order.getRawRecord().isFieldDirty("FULFILLMENT_STATUS")) {
            HashSet<Long> facilityIds = new HashSet<Long>();
            for (OrderLine orderLine : order.getOrderLines()) {
                Long facilityId = orderLine.getShipFromId();
                if (facilityId == null) continue;
                facilityIds.add(facilityId);
            }
            List list = new Select(new String[0]).from(new Class[]{Facility.class}).where(new Expression(ModelReflector.instance(Facility.class).getPool(), "ID", Operator.IN, facilityIds.toArray())).execute();
            list.forEach(f -> f.getPreferredCarriers().forEach(preferredCarrier -> TaskManager.instance().executeAsync((CoreTask)new CreateManifestTask(preferredCarrier.getId()), false)));
        }
        if (!order.getRawRecord().isNewRecord() && order.getRawRecord().isFieldDirty("FULFILLMENT_STATUS")) {
            Cache<String, OrderStatus> cache = new Cache<String, OrderStatus>(){

                protected OrderStatus getValue(String status) {
                    OrderStatus orderStatus = (OrderStatus)Database.getTable(OrderStatus.class).newRecord();
                    orderStatus.setFulfillmentStatus(status);
                    orderStatus.setOrderId(order.getId());
                    orderStatus.setStatusDate(new Timestamp(System.currentTimeMillis()));
                    return orderStatus;
                }
            };
            order.getOrderStatuses().forEach(arg_0 -> BeforeSaveOrder.lambda$beforeSave$2((Cache)cache, arg_0));
            ((OrderStatus)cache.get((Object)order.getFulfillmentStatus())).save();
        }
    }

    private static /* synthetic */ void lambda$beforeSave$2(Cache cache, OrderStatus orderStatus) {
        cache.put((Object)orderStatus.getFulfillmentStatus(), (Object)orderStatus);
    }

    static {
        BeforeSaveOrder.registerExtension((BeforeModelSaveExtension)new BeforeSaveOrder());
    }
}

