/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.extensions.order.line;

import com.venky.core.collections.SequenceSet;
import com.venky.core.date.DateUtils;
import com.venky.core.math.DoubleUtils;
import com.venky.core.util.ObjectUtil;
import com.venky.extension.Registry;
import com.venky.swf.db.Database;
import com.venky.swf.db.JdbcTypeHelper;
import com.venky.swf.db.extensions.BeforeModelSaveExtension;
import com.venky.swf.plugins.background.core.TaskManager;
import in.succinct.plugins.ecommerce.agents.demand.OpendDemandIncrementor;
import in.succinct.plugins.ecommerce.agents.order.tasks.OrderStatusMonitor;
import in.succinct.plugins.ecommerce.agents.order.tasks.cancel.CancelApiTask;
import in.succinct.plugins.ecommerce.db.model.attributes.AssetCode;
import in.succinct.plugins.ecommerce.db.model.catalog.Item;
import in.succinct.plugins.ecommerce.db.model.inventory.Inventory;
import in.succinct.plugins.ecommerce.db.model.order.Order;
import in.succinct.plugins.ecommerce.db.model.order.OrderAddress;
import in.succinct.plugins.ecommerce.db.model.order.OrderLine;
import in.succinct.plugins.ecommerce.integration.MarketPlace;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Optional;
import org.json.simple.JSONObject;

public class BeforeSaveOrderLine
extends BeforeModelSaveExtension<OrderLine> {
    public void beforeSave(OrderLine orderLine) {
        JdbcTypeHelper.TypeConverter dConvertor;
        JdbcTypeHelper.TypeConverter doubleTypeConverter;
        SequenceSet tasks = new SequenceSet();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        Order order = orderLine.getOrder();
        Timestamp demandDate = null;
        if (orderLine.getSku().getItem().isRentable()) {
            if (orderLine.getDeliveryExpectedNoEarlierThan() == null) {
                orderLine.setDeliveryExpectedNoEarlierThan(orderLine.getOrder().getShipAfterDate());
            }
            if (orderLine.getDeliveryExpectedNoLaterThan() == null) {
                orderLine.setDeliveryExpectedNoLaterThan(orderLine.getOrder().getShipByDate());
            }
            demandDate = new Timestamp(DateUtils.getStartOfDay((long)orderLine.getDeliveryExpectedNoEarlierThan().getTime()));
        }
        if (orderLine.getOrderedQuantity() > 0.0 && orderLine.getRawRecord().isFieldDirty("ORDERED_QUANTITY")) {
            orderLine.setOrderedTs(now);
            doubleTypeConverter = orderLine.getReflector().getJdbcTypeHelper().getTypeRef(Double.class).getTypeConverter();
            Double oldOrderedQty = (Double)doubleTypeConverter.valueOf(orderLine.getRawRecord().getOldValue("ORDERED_QUANTITY"));
            Double newOrderedQty = orderLine.getOrderedQuantity();
            double qtyOrderedNow = newOrderedQty - oldOrderedQty;
            Registry.instance().callExtensions("OrderLine.DOWNLOADED.quantity", new Object[]{orderLine, qtyOrderedNow});
        }
        if (!orderLine.getRawRecord().isNewRecord() && orderLine.getRawRecord().isFieldDirty("ACKNOWLEDGED_QUANTITY")) {
            if (orderLine.getAcknowledgedQuantity() > 0.0) {
                orderLine.setAcknowledgedTs(now);
            } else {
                orderLine.setAcknowledgedTs(null);
            }
            doubleTypeConverter = orderLine.getReflector().getJdbcTypeHelper().getTypeRef(Double.class).getTypeConverter();
            Double oldAcknowledgedQty = (Double)doubleTypeConverter.valueOf(orderLine.getRawRecord().getOldValue("ACKNOWLEDGED_QUANTITY"));
            Double newAcknowledgedQty = orderLine.getAcknowledgedQuantity();
            double qtyAcknowledgedNow = newAcknowledgedQty - oldAcknowledgedQty;
            Item item = orderLine.getSku().getItem();
            if (item.getAssetCodeId() != null && item.isRentable() && (orderLine.getReflector().isVoid((Object)orderLine.getDeliveryExpectedNoEarlierThan()) || orderLine.getReflector().isVoid((Object)orderLine.getDeliveryExpectedNoEarlierThan()))) {
                throw new RuntimeException("Please specify slot to book appointment.");
            }
            tasks.add((Object)new OpendDemandIncrementor(orderLine.getInventory(false).getId(), qtyAcknowledgedNow, demandDate, orderLine.getWorkSlot()));
            tasks.add((Object)new OrderStatusMonitor(orderLine.getOrderId()));
            Registry.instance().callExtensions("OrderLine.ACKNOWLEDGED.quantity", new Object[]{orderLine, qtyAcknowledgedNow});
        }
        if (orderLine.getPackedQuantity() > 0.0 && orderLine.getToPackQuantity() <= 0.0 && orderLine.getRawRecord().isFieldDirty("PACKED_QUANTITY")) {
            orderLine.setPackedTs(now);
            tasks.add((Object)new OrderStatusMonitor(orderLine.getOrderId()));
            Registry.instance().callExtensions("OrderLine.PACKED.quantity", new Object[]{orderLine, orderLine.getPackedQuantity()});
        }
        if (orderLine.getManifestedQuantity() > 0.0 && orderLine.getToManifestQuantity() <= 0.0 && orderLine.getRawRecord().isFieldDirty("MANIFESTED_QUANTITY")) {
            orderLine.setManifestedTs(now);
            tasks.add((Object)new OrderStatusMonitor(orderLine.getOrderId()));
            Registry.instance().callExtensions("OrderLine.MANIFESTED.quantity", new Object[]{orderLine, orderLine.getManifestedQuantity()});
        }
        if (orderLine.getCancelledQuantity() > 0.0 && orderLine.getRawRecord().isFieldDirty("CANCELLED_QUANTITY")) {
            Inventory inventory;
            dConvertor = orderLine.getReflector().getJdbcTypeHelper().getTypeRef(Double.class).getTypeConverter();
            Double oldCancelledQty = (Double)dConvertor.valueOf(orderLine.getRawRecord().getOldValue("CANCELLED_QUANTITY"));
            if (DoubleUtils.equals((double)oldCancelledQty, (double)0.0)) {
                orderLine.setCancelledTs(now);
            }
            Double newCancelledQty = orderLine.getCancelledQuantity();
            double qtyCancelledNow = newCancelledQty - oldCancelledQty;
            if (!orderLine.getCancellationInitiator().equals("MarketPlaceRules") && order.getMarketPlaceIntegrationId() != null && orderLine.getRemainingCancellableQuantity() > 0.0) {
                tasks.add((Object)new CancelApiTask(orderLine.getId(), "MarketPlaceRules", "PARTIAL_CANCEL_NOT_SUPPORTED"));
            }
            if (qtyCancelledNow > 0.0 && orderLine.getShipFromId() != null && (inventory = orderLine.getInventory(false)) != null) {
                tasks.add((Object)new OpendDemandIncrementor(inventory.getId(), -1.0 * qtyCancelledNow, demandDate, orderLine.getWorkSlot()));
            }
            tasks.add((Object)new OrderStatusMonitor(orderLine.getOrderId()));
            Registry.instance().callExtensions("OrderLine.CANCELLED.quantity", new Object[]{orderLine, qtyCancelledNow});
        }
        if (orderLine.getShippedQuantity() > 0.0 && orderLine.getRawRecord().isFieldDirty("SHIPPED_QUANTITY")) {
            dConvertor = orderLine.getReflector().getJdbcTypeHelper().getTypeRef(Double.class).getTypeConverter();
            Double oldShippedQty = (Double)dConvertor.valueOf(orderLine.getRawRecord().getOldValue("SHIPPED_QUANTITY"));
            if (DoubleUtils.equals((double)oldShippedQty, (double)0.0)) {
                orderLine.setShippedTs(now);
            }
            double newShippedQty = orderLine.getShippedQuantity();
            double qtyShippedNow = newShippedQty - oldShippedQty;
            Inventory inventory = orderLine.getInventory(true);
            if (inventory != null) {
                JSONObject object = new JSONObject();
                object.put((Object)"OrderLineId", (Object)orderLine.getId());
                object.put((Object)"OrderId", (Object)orderLine.getOrderId());
                inventory.adjust(-1.0 * qtyShippedNow, object.toString());
            } else if (!AssetCode.getDeliverySkuIds().contains(orderLine.getSkuId())) {
                inventory = (Inventory)Database.getTable(Inventory.class).newRecord();
                inventory.setSkuId(orderLine.getSkuId());
                inventory.setFacilityId(orderLine.getShipFromId());
                inventory.setQuantity(0.0);
            }
            if (inventory != null) {
                inventory.save();
                tasks.add((Object)new OpendDemandIncrementor(inventory.getId(), -1.0 * qtyShippedNow, demandDate, orderLine.getWorkSlot()));
            }
            tasks.add((Object)new OrderStatusMonitor(orderLine.getOrderId()));
            Registry.instance().callExtensions("OrderLine.SHIPPED.quantity", new Object[]{orderLine, qtyShippedNow});
        }
        if (orderLine.getDeliveredQuantity() > 0.0 && orderLine.getRawRecord().isFieldDirty("DELIVERED_QUANTITY")) {
            dConvertor = orderLine.getReflector().getJdbcTypeHelper().getTypeRef(Double.class).getTypeConverter();
            Double oldDeliveredQuantity = (Double)dConvertor.valueOf(orderLine.getRawRecord().getOldValue("DELIVERED_QUANTITY"));
            if (DoubleUtils.equals((double)oldDeliveredQuantity, (double)0.0)) {
                orderLine.setDeliveredTs(now);
                tasks.add((Object)new OrderStatusMonitor(orderLine.getOrderId()));
            }
            double newDeliveredQty = orderLine.getDeliveredQuantity();
            double qtyDeliveredNow = newDeliveredQty - oldDeliveredQuantity;
            Optional<OrderAddress> possibleShipToFacility = orderLine.getOrder().getAddresses().stream().filter(a -> a.getFacilityId() != null && ObjectUtil.equals((Object)a.getAddressType(), (Object)"ST")).findFirst();
            if (possibleShipToFacility.isPresent()) {
                OrderAddress shipToFacility = possibleShipToFacility.get();
                Inventory.adjust(shipToFacility.getFacility(), orderLine.getSku(), qtyDeliveredNow, "Receipt into facility " + shipToFacility.getFacility().getName() + " via Order " + orderLine.getOrderId());
            }
            Registry.instance().callExtensions("OrderLine.DELIVERED.quantity", new Object[]{orderLine, qtyDeliveredNow});
        }
        if (orderLine.getReturnedQuantity() > 0.0 && orderLine.getRawRecord().isFieldDirty("RETURNED_QUANTITY")) {
            dConvertor = orderLine.getReflector().getJdbcTypeHelper().getTypeRef(Double.class).getTypeConverter();
            Double oldReturnedQuantity = (Double)dConvertor.valueOf(orderLine.getRawRecord().getOldValue("RETURNED_QUANTITY"));
            if (DoubleUtils.equals((double)oldReturnedQuantity, (double)0.0)) {
                orderLine.setReturnedTs(now);
            }
            if (!orderLine.getCancellationInitiator().equals("MarketPlaceRules") && order.getMarketPlaceIntegrationId() != null && orderLine.getRemainingCancellableQuantity() > 0.0) {
                tasks.add((Object)new CancelApiTask(orderLine.getId(), "MarketPlaceRules", "PARTIAL_CANCEL_NOT_SUPPORTED"));
            }
            tasks.add((Object)new OrderStatusMonitor(orderLine.getOrderId()));
            double newReturnedQuantity = orderLine.getReturnedQuantity();
            double qtyReturnedNow = newReturnedQuantity - oldReturnedQuantity;
            Registry.instance().callExtensions("OrderLine.RETURNED.quantity", new Object[]{orderLine, qtyReturnedNow});
        }
        if (this.isBeingFullyCancelled(orderLine) && order.getMarketPlaceIntegrationId() != null) {
            MarketPlace.get(orderLine.getShipFromId(), order.getMarketPlaceIntegration().getName()).forEach(mp -> mp.getWarehouseActionHandler().reject(orderLine));
        }
        TaskManager.instance().executeAsync((Collection)tasks, false);
    }

    private boolean isBeingFullyCancelled(OrderLine model) {
        return model.getCancelledQuantity() + model.getReturnedQuantity() > 0.0 && model.getRemainingCancellableQuantity() == 0.0 && (model.getRawRecord().isFieldDirty("CANCELLED_QUANTITY") || model.getRawRecord().isFieldDirty("RETURNED_QUANTITY"));
    }

    static {
        BeforeSaveOrderLine.registerExtension((BeforeModelSaveExtension)new BeforeSaveOrderLine());
    }
}

