/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.extensions.service;

import com.venky.core.util.ObjectUtil;
import com.venky.swf.db.Database;
import com.venky.swf.db.extensions.BeforeModelSaveExtension;
import in.succinct.plugins.ecommerce.db.model.service.ServiceOrder;
import in.succinct.plugins.ecommerce.db.model.service.ServiceOrderRemark;
import java.util.HashSet;

public class BeforeSaveServiceOrder
extends BeforeModelSaveExtension<ServiceOrder> {
    public void beforeSave(ServiceOrder model) {
        if (model.getFulfillmentStatus().equals("COMPLETED") && model.getRawRecord().isFieldDirty("FULFILLMENT_STATUS")) {
            if (ObjectUtil.isVoid((Object)model.getServicedById())) {
                throw new RuntimeException("Please enter who serviced the request");
            }
            HashSet allowedUsers = new HashSet();
            model.getService().getServiceResources().forEach(sr -> allowedUsers.add(sr.getUserId()));
            if (!allowedUsers.isEmpty() && !allowedUsers.contains(model.getServicedById())) {
                throw new RuntimeException("Connect be serviced by " + model.getServicedBy().getLongName());
            }
        }
        if (model.getRawRecord().isFieldDirty("REMARKS") && !model.getReflector().isVoid((Object)model.getRemarks()) && !model.getRawRecord().isNewRecord() && model.getId() > 0L) {
            ServiceOrderRemark remark = (ServiceOrderRemark)Database.getTable(ServiceOrderRemark.class).newRecord();
            remark.setServiceOrderId(model.getId());
            remark.setRemarks(model.getRemarks());
            remark.save();
        }
    }

    static {
        BeforeSaveServiceOrder.registerExtension((BeforeModelSaveExtension)new BeforeSaveServiceOrder());
    }
}

