/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.integration;

import com.venky.core.util.ObjectUtil;
import com.venky.swf.db.Database;
import com.venky.swf.sql.Conjunction;
import com.venky.swf.sql.Expression;
import com.venky.swf.sql.Operator;
import com.venky.swf.sql.Select;
import in.succinct.plugins.ecommerce.db.model.inventory.Inventory;
import in.succinct.plugins.ecommerce.db.model.order.Order;
import in.succinct.plugins.ecommerce.db.model.order.OrderLine;
import in.succinct.plugins.ecommerce.db.model.participation.Facility;
import in.succinct.plugins.ecommerce.db.model.participation.MarketPlaceIntegration;
import in.succinct.plugins.ecommerce.integration.humbhionline.HumBhiOnline;
import in.succinct.plugins.ecommerce.integration.unicommerce.UniCommerce;
import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONObject;

public interface MarketPlace {
    public long getFacilityId();

    public String getOrderPrefix();

    default public void pullOrders() {
        this.getWarehouseActionHandler().pullOrders(this.getLastOrderDownloaded());
    }

    default public Order getLastOrderDownloaded() {
        Select select = new Select(new String[0]).from(new Class[]{Order.class});
        Expression where = new Expression(select.getPool(), Conjunction.AND);
        where.add(new Expression(select.getPool(), "REFERENCE", Operator.LK, (Object[])new String[]{this.getOrderPrefix() + "%"}));
        select.where(where).add(String.format(" and exists (select 1 from order_lines where order_id = orders.id and ship_from_id = %d )", this.getFacilityId()));
        List orders = select.orderBy(new String[]{"ID DESC"}).execute(1);
        Order order = null;
        if (!orders.isEmpty()) {
            order = (Order)orders.get(0);
        }
        return order;
    }

    public static List<MarketPlace> get(long facilityId) {
        return MarketPlace.get(facilityId, null);
    }

    public static List<MarketPlace> get(long facilityId, String integrationName) {
        Facility facility = (Facility)Database.getTable(Facility.class).get(facilityId);
        ArrayList<MarketPlace> marketPlaces = new ArrayList<MarketPlace>();
        if (facility == null || facility.getPreferredMarketPlaceIntegrations().isEmpty()) {
            return marketPlaces;
        }
        block8: for (MarketPlaceIntegration integration : facility.getPreferredMarketPlaceIntegrations()) {
            switch (integration.getName()) {
                case "HumBhiOnline": {
                    if (integrationName != null && !ObjectUtil.equals((Object)integrationName, (Object)integration.getName())) continue block8;
                    marketPlaces.add(HumBhiOnline.getInstance(integration));
                    continue block8;
                }
                case "UniCommerce": {
                    if (integrationName != null && !ObjectUtil.equals((Object)integrationName, (Object)integration.getName())) continue block8;
                    marketPlaces.add(UniCommerce.getInstance(integration));
                    continue block8;
                }
            }
            throw new RuntimeException(String.format("% not a valid market place integrator!", integration.getName()));
        }
        return marketPlaces;
    }

    public WarehouseActionHandler getWarehouseActionHandler();

    public UserActionHandler getUserActionHandler();

    public static interface WarehouseActionHandler {
        public void sync(Inventory var1);

        public void pullOrders(Order var1);

        public void pack(Order var1);

        public void ship(Order var1);

        public void deliver(Order var1);

        public void reject(OrderLine var1);

        public void startCount();
    }

    public static interface UserActionHandler {
        public void book(JSONObject var1);

        public void cancel_line(JSONObject var1);

        public void confirm_delivery(JSONObject var1);
    }
}

