/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.integration.fedex;

import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.MessageContext;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.ser.BeanSerializer;
import org.apache.axis.server.AxisServer;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class AxisObjectUtil {
    public static TypeDesc getAxisTypeDesc(Object obj) {
        Class<?> objClass = obj.getClass();
        try {
            Method methodGetTypeDesc = objClass.getMethod("getTypeDesc", new Class[0]);
            TypeDesc typeDesc = (TypeDesc)methodGetTypeDesc.invoke(obj, new Object[0]);
            return typeDesc;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get Axis TypeDesc for " + objClass.getName(), e);
        }
    }

    public static String serializeAxisObject(Object obj) {
        if (obj == null) {
            return null;
        }
        StringWriter outStr = new StringWriter();
        TypeDesc typeDesc = AxisObjectUtil.getAxisTypeDesc(obj);
        QName qname = typeDesc.getXmlType();
        String lname = qname.getLocalPart();
        if (lname.startsWith(">") && lname.length() > 1) {
            lname = lname.substring(1);
        }
        qname = new QName(qname.getNamespaceURI(), lname);
        AxisServer server = new AxisServer();
        BeanSerializer ser = new BeanSerializer(obj.getClass(), qname, typeDesc);
        SerializationContext ctx = new SerializationContext((Writer)outStr, new MessageContext((AxisEngine)server));
        ctx.setSendDecl(false);
        ctx.setDoMultiRefs(false);
        ctx.setPretty(true);
        try {
            ser.serialize(qname, (Attributes)new AttributesImpl(), obj, ctx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String xml = outStr.toString();
        return xml;
    }
}

