/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.integration.fedex;

import com.fedex.rate.stub.ClientDetail;
import com.fedex.rate.stub.CommercialInvoice;
import com.fedex.rate.stub.CustomsClearanceDetail;
import com.fedex.rate.stub.Dimensions;
import com.fedex.rate.stub.DropoffType;
import com.fedex.rate.stub.LinearUnits;
import com.fedex.rate.stub.Money;
import com.fedex.rate.stub.Notification;
import com.fedex.rate.stub.NotificationSeverityType;
import com.fedex.rate.stub.PackageRateDetail;
import com.fedex.rate.stub.PackageSpecialServicesRequested;
import com.fedex.rate.stub.PackagingType;
import com.fedex.rate.stub.Party;
import com.fedex.rate.stub.Payment;
import com.fedex.rate.stub.PaymentType;
import com.fedex.rate.stub.PurposeOfShipmentType;
import com.fedex.rate.stub.RatePortType;
import com.fedex.rate.stub.RateReply;
import com.fedex.rate.stub.RateReplyDetail;
import com.fedex.rate.stub.RateRequest;
import com.fedex.rate.stub.RateServiceLocator;
import com.fedex.rate.stub.RatedPackageDetail;
import com.fedex.rate.stub.RatedShipmentDetail;
import com.fedex.rate.stub.RequestedPackageLineItem;
import com.fedex.rate.stub.RequestedShipment;
import com.fedex.rate.stub.ServiceType;
import com.fedex.rate.stub.ShipmentRateDetail;
import com.fedex.rate.stub.Surcharge;
import com.fedex.rate.stub.TransactionDetail;
import com.fedex.rate.stub.VersionId;
import com.fedex.rate.stub.WebAuthenticationCredential;
import com.fedex.rate.stub.WebAuthenticationDetail;
import com.fedex.rate.stub.Weight;
import com.fedex.rate.stub.WeightUnits;
import com.venky.core.date.DateUtils;
import com.venky.core.log.SWFLogger;
import com.venky.core.math.DoubleHolder;
import com.venky.core.util.ObjectUtil;
import com.venky.swf.db.Database;
import com.venky.swf.db.model.Model;
import com.venky.swf.db.model.reflection.ModelReflector;
import com.venky.swf.plugins.collab.db.model.participants.admin.Address;
import com.venky.swf.routing.Config;
import com.venky.swf.sql.Conjunction;
import com.venky.swf.sql.Expression;
import com.venky.swf.sql.Operator;
import com.venky.swf.sql.Select;
import in.succinct.plugins.ecommerce.db.model.order.FedexTransitTime;
import in.succinct.plugins.ecommerce.db.model.participation.Facility;
import in.succinct.plugins.ecommerce.db.model.participation.PreferredCarrier;
import in.succinct.plugins.ecommerce.integration.fedex.AxisObjectUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.axis.types.NonNegativeInteger;

public class RateWebServiceClient<M extends Model & Address> {
    Facility from;
    M rateable;
    PreferredCarrier carrier;
    public static final int MAX_TRANSIT_DAYS = 5;
    SWFLogger cat = Config.instance().getLogger(this.getClass().getName());

    public RateWebServiceClient(PreferredCarrier carrier, Facility from, M rateable) {
        this.from = from;
        this.rateable = rateable;
        this.carrier = null;
        if (carrier.getName().equalsIgnoreCase("FedEx")) {
            this.carrier = carrier;
        }
    }

    public RateWebServiceClient(Facility from, M rateable) {
        this.from = from;
        this.rateable = rateable;
        Optional<PreferredCarrier> optionalCarrier = from.getPreferredCarriers().stream().filter(pc -> pc.getName().equalsIgnoreCase("FedEx")).findFirst();
        if (optionalCarrier.isPresent()) {
            this.carrier = optionalCarrier.get();
        }
    }

    public FedexTransitTime getTransitTime() {
        FedexTransitTime transitTime = null;
        if (this.carrier != null && ((Address)this.rateable).getCityId() != null && ((Address)this.rateable).getPinCodeId() != null && ((Address)this.rateable).getStateId() != null) {
            ModelReflector ref = ModelReflector.instance(FedexTransitTime.class);
            List times = new Select(new String[0]).from(new Class[]{FedexTransitTime.class}).where(new Expression(ref.getPool(), Conjunction.AND).add(new Expression(ref.getPool(), "ORIGIN_CITY_ID", Operator.EQ, (Object[])new Long[]{this.from.getCityId()})).add(new Expression(ref.getPool(), "DESTINATION_CITY_ID", Operator.EQ, (Object[])new Long[]{((Address)this.rateable).getCityId()}))).execute(1);
            if (times.isEmpty()) {
                TreeMap<Long, List<RateReplyDetail>> deliveryTimestampMap = new TreeMap<Long, List<RateReplyDetail>>();
                this.rate(deliveryTimestampMap);
                if (!deliveryTimestampMap.isEmpty()) {
                    int transitDays = DateUtils.compareToMinutes((long)deliveryTimestampMap.lastKey(), (long)DateUtils.getStartOfDay((long)System.currentTimeMillis())) / 1440;
                    transitTime = (FedexTransitTime)Database.getTable(FedexTransitTime.class).newRecord();
                    transitTime.setOriginCityId(this.from.getCityId());
                    transitTime.setDestinationCityId(((Address)this.rateable).getCityId());
                    transitTime.setTransitDays(transitDays);
                    List<RateReplyDetail> replies = deliveryTimestampMap.get(deliveryTimestampMap.lastKey());
                    double minRate = Double.POSITIVE_INFINITY;
                    for (RateReplyDetail rrd : replies) {
                        RatedShipmentDetail[] rsds = rrd.getRatedShipmentDetails();
                        RatedShipmentDetail rsd = rsds[0];
                        ShipmentRateDetail srd = rsd.getShipmentRateDetail();
                        minRate = Math.min(srd.getTotalNetCharge().getAmount().doubleValue(), minRate);
                    }
                    transitTime.setRateFor1KgPackage(minRate);
                    transitTime.save();
                }
            } else {
                transitTime = (FedexTransitTime)times.get(0);
            }
        }
        if (transitTime == null) {
            transitTime = (FedexTransitTime)Database.getTable(FedexTransitTime.class).newRecord();
            transitTime.setOriginCityId(this.from.getCityId());
            transitTime.setDestinationCityId(((Address)this.rateable).getCityId());
            transitTime.setTransitDays(5);
            transitTime.setRateFor1KgPackage(500.0);
        }
        return transitTime;
    }

    public void rate(SortedMap<Long, List<RateReplyDetail>> deliveryTimestampMap) {
        boolean getAllRatesFlag = true;
        RateRequest request = new RateRequest();
        request.setClientDetail(this.createClientDetail());
        request.setWebAuthenticationDetail(this.createWebAuthenticationDetail());
        request.setReturnTransitAndCommit(true);
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setCustomerTransactionId(this.rateable.getReflector().getModelClass().getSimpleName() + "." + this.rateable.getId());
        request.setTransactionDetail(transactionDetail);
        VersionId versionId = new VersionId("crs", 24, 0, 0);
        request.setVersion(versionId);
        RequestedShipment requestedShipment = new RequestedShipment();
        requestedShipment.setShipTimestamp(Calendar.getInstance());
        requestedShipment.setDropoffType(DropoffType.REGULAR_PICKUP);
        if (!getAllRatesFlag) {
            requestedShipment.setServiceType(ServiceType.FEDEX_EXPRESS_SAVER);
            requestedShipment.setPackagingType(PackagingType.YOUR_PACKAGING);
        }
        StringBuilder addressLine1 = new StringBuilder();
        StringBuilder addressLine2 = new StringBuilder();
        if (!ObjectUtil.isVoid((Object)this.from.getAddressLine1())) {
            addressLine1.append(this.from.getAddressLine1());
        }
        if (!ObjectUtil.isVoid((Object)this.from.getAddressLine2())) {
            if (addressLine1.length() > 0) {
                addressLine1.append(",");
            }
            addressLine1.append(this.from.getAddressLine2());
        }
        if (!ObjectUtil.isVoid((Object)this.from.getAddressLine3())) {
            addressLine2.append(this.from.getAddressLine3());
        }
        if (!ObjectUtil.isVoid((Object)this.from.getAddressLine4())) {
            if (addressLine2.length() > 0) {
                addressLine2.append(",");
            }
            addressLine2.append(this.from.getAddressLine4());
        }
        Party shipper = this.addShipper();
        requestedShipment.setShipper(shipper);
        Party recipient = this.addRecipient();
        requestedShipment.setRecipient(recipient);
        Payment shippingChargesPayment = new Payment();
        shippingChargesPayment.setPaymentType(PaymentType.SENDER);
        requestedShipment.setShippingChargesPayment(shippingChargesPayment);
        RequestedPackageLineItem rp = new RequestedPackageLineItem();
        rp.setGroupPackageCount(new NonNegativeInteger("1"));
        rp.setWeight(new Weight(WeightUnits.KG, new BigDecimal(1.0)));
        rp.setDimensions(new Dimensions(new NonNegativeInteger("1"), new NonNegativeInteger("1"), new NonNegativeInteger("1"), LinearUnits.IN));
        PackageSpecialServicesRequested pssr = new PackageSpecialServicesRequested();
        rp.setSpecialServicesRequested(pssr);
        requestedShipment.setRequestedPackageLineItems(new RequestedPackageLineItem[]{rp});
        requestedShipment.setPackageCount(new NonNegativeInteger("1"));
        requestedShipment.setCustomsClearanceDetail(this.addCustomsClearanceDetail());
        request.setRequestedShipment(requestedShipment);
        try {
            RateServiceLocator service = new RateServiceLocator();
            this.updateEndPoint(service);
            RatePortType port = service.getRateServicePort();
            this.cat.info("Request:\n" + AxisObjectUtil.serializeAxisObject(request));
            RateReply reply = port.getRates(request);
            if (this.isResponseOk(reply.getHighestSeverity())) {
                this.writeServiceOutput(reply, deliveryTimestampMap);
            }
            this.printNotifications(reply.getNotifications());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Party addShipper() {
        Party shipperParty = new Party();
        com.fedex.rate.stub.Address shipperAddress = new com.fedex.rate.stub.Address();
        StringBuilder addressLine1 = new StringBuilder();
        StringBuilder addressLine2 = new StringBuilder();
        if (!ObjectUtil.isVoid((Object)this.from.getAddressLine1())) {
            addressLine1.append(this.from.getAddressLine1());
        }
        if (!ObjectUtil.isVoid((Object)this.from.getAddressLine2())) {
            if (addressLine1.length() > 0) {
                addressLine1.append(",");
            }
            addressLine1.append(this.from.getAddressLine2());
        }
        if (!ObjectUtil.isVoid((Object)this.from.getAddressLine3())) {
            addressLine2.append(this.from.getAddressLine3());
        }
        if (!ObjectUtil.isVoid((Object)this.from.getAddressLine4())) {
            if (addressLine2.length() > 0) {
                addressLine2.append(",");
            }
            addressLine2.append(this.from.getAddressLine4());
        }
        shipperAddress.setStreetLines(new String[]{addressLine1.toString(), addressLine2.toString()});
        shipperAddress.setCity(this.from.getCity().getName());
        shipperAddress.setStateOrProvinceCode(this.from.getState().getCode());
        shipperAddress.setPostalCode(this.from.getPinCode().getPinCode());
        shipperAddress.setCountryCode(this.from.getCountry().getIsoCode());
        shipperAddress.setCountryName(this.from.getCountry().getName());
        shipperAddress.setResidential(false);
        shipperParty.setAddress(shipperAddress);
        return shipperParty;
    }

    private Party addRecipient() {
        Party recipient = new Party();
        com.fedex.rate.stub.Address addressRecip = new com.fedex.rate.stub.Address();
        StringBuilder addressLine1 = new StringBuilder();
        StringBuilder addressLine2 = new StringBuilder();
        if (!ObjectUtil.isVoid((Object)((Address)this.rateable).getAddressLine1())) {
            addressLine1.append(((Address)this.rateable).getAddressLine1());
        }
        if (!ObjectUtil.isVoid((Object)((Address)this.rateable).getAddressLine2())) {
            if (addressLine1.length() > 0) {
                addressLine1.append(",");
            }
            addressLine1.append(((Address)this.rateable).getAddressLine2());
        }
        if (!ObjectUtil.isVoid((Object)((Address)this.rateable).getAddressLine3())) {
            addressLine2.append(((Address)this.rateable).getAddressLine3());
        }
        if (!ObjectUtil.isVoid((Object)((Address)this.rateable).getAddressLine4())) {
            if (addressLine2.length() > 0) {
                addressLine2.append(",");
            }
            addressLine2.append(((Address)this.rateable).getAddressLine4());
        }
        addressRecip.setStreetLines(new String[]{addressLine1.toString(), addressLine2.toString()});
        addressRecip.setCity(((Address)this.rateable).getCity().getName());
        addressRecip.setStateOrProvinceCode(((Address)this.rateable).getState().getCode());
        addressRecip.setPostalCode(((Address)this.rateable).getPinCode().getPinCode());
        addressRecip.setCountryCode(((Address)this.rateable).getCountry().getIsoCode());
        addressRecip.setCountryName(((Address)this.rateable).getCountry().getName());
        addressRecip.setResidential(new Boolean(true));
        recipient.setAddress(addressRecip);
        return recipient;
    }

    public void writeServiceOutput(RateReply reply, SortedMap<Long, List<RateReplyDetail>> deliveryTimestampMap) {
        RateReplyDetail[] rrds = reply.getRateReplyDetails();
        for (int i = 0; i < rrds.length; ++i) {
            RateReplyDetail rrd = rrds[i];
            this.print("\nService type", rrd.getServiceType());
            this.print("Packaging type", rrd.getPackagingType());
            if (rrd.getDeliveryDayOfWeek() != null) {
                int month = rrd.getDeliveryTimestamp().get(2) + 1;
                int date = rrd.getDeliveryTimestamp().get(5);
                int year = rrd.getDeliveryTimestamp().get(1);
                String delDate = new String(month + "/" + date + "/" + year);
                ArrayList<RateReplyDetail> list = (ArrayList<RateReplyDetail>)deliveryTimestampMap.get(rrd.getDeliveryTimestamp().getTimeInMillis());
                if (list == null) {
                    list = new ArrayList<RateReplyDetail>();
                    deliveryTimestampMap.put(rrd.getDeliveryTimestamp().getTimeInMillis(), list);
                }
                list.add(rrd);
                this.print("Delivery date", delDate);
                this.print("Calendar DOW", rrd.getDeliveryTimestamp().get(7));
            }
            RatedShipmentDetail[] rsds = rrd.getRatedShipmentDetails();
            for (int j = 0; j < rsds.length; ++j) {
                this.print("RatedShipmentDetail " + j, "");
                RatedShipmentDetail rsd = rsds[j];
                ShipmentRateDetail srd = rsd.getShipmentRateDetail();
                this.print("  Rate type", srd.getRateType());
                this.printWeight("  Total Billing weight", srd.getTotalBillingWeight());
                this.printMoney("  Total surcharges", srd.getTotalSurcharges());
                this.printMoney("  Total net charge", srd.getTotalNetCharge());
                RatedPackageDetail[] rpds = rsd.getRatedPackages();
                if (rpds == null || rpds.length <= 0) continue;
                this.print("  RatedPackageDetails", "");
                for (int k = 0; k < rpds.length; ++k) {
                    this.print("  RatedPackageDetail " + i, "");
                    RatedPackageDetail rpd = rpds[k];
                    PackageRateDetail prd = rpd.getPackageRateDetail();
                    if (prd == null) continue;
                    this.printWeight("    Billing weight", prd.getBillingWeight());
                    this.printMoney("    Base charge", prd.getBaseCharge());
                    Surcharge[] surcharges = prd.getSurcharges();
                    if (surcharges == null || surcharges.length <= 0) continue;
                    for (int m = 0; m < surcharges.length; ++m) {
                        Surcharge surcharge = surcharges[m];
                        this.printMoney("    " + surcharge.getDescription() + " surcharge", surcharge.getAmount());
                    }
                }
            }
            this.cat.info("");
        }
    }

    private ClientDetail createClientDetail() {
        ClientDetail clientDetail = new ClientDetail();
        String accountNumber = this.carrier.getAccountNumber();
        String meterNumber = this.carrier.getMeterNumber();
        clientDetail.setAccountNumber(accountNumber);
        clientDetail.setMeterNumber(meterNumber);
        return clientDetail;
    }

    private WebAuthenticationDetail createWebAuthenticationDetail() {
        WebAuthenticationCredential userCredential = new WebAuthenticationCredential();
        userCredential.setKey(this.carrier.getApiKey());
        userCredential.setPassword(this.carrier.getPassword());
        WebAuthenticationCredential parentCredential = null;
        Boolean useParentCredential = false;
        if (useParentCredential.booleanValue()) {
            String parentKey = System.getProperty("parentkey");
            String parentPassword = System.getProperty("parentpassword");
            if (parentKey == null) {
                parentKey = "XXX";
            }
            if (parentPassword == null) {
                parentPassword = "XXX";
            }
            parentCredential = new WebAuthenticationCredential();
            parentCredential.setKey(parentKey);
            parentCredential.setPassword(parentPassword);
        }
        return new WebAuthenticationDetail(parentCredential, userCredential);
    }

    private void printNotifications(Notification[] notifications) {
        this.cat.info("Notifications:");
        if (notifications == null || notifications.length == 0) {
            this.cat.info("  No notifications returned");
        }
        for (int i = 0; i < notifications.length; ++i) {
            Notification n = notifications[i];
            System.out.print("  Notification no. " + i + ": ");
            if (n == null) {
                this.cat.info("null");
                continue;
            }
            this.cat.info("");
            NotificationSeverityType nst = n.getSeverity();
            this.cat.info("    Severity: " + (nst == null ? "null" : nst.getValue()));
            this.cat.info("    Code: " + n.getCode());
            this.cat.info("    Message: " + n.getMessage());
            this.cat.info("    Source: " + n.getSource());
        }
    }

    private boolean isResponseOk(NotificationSeverityType notificationSeverityType) {
        if (notificationSeverityType == null) {
            return false;
        }
        return notificationSeverityType.equals(NotificationSeverityType.WARNING) || notificationSeverityType.equals(NotificationSeverityType.NOTE) || notificationSeverityType.equals(NotificationSeverityType.SUCCESS);
    }

    private void print(String msg, Object obj) {
        if (msg == null || obj == null) {
            return;
        }
        this.cat.info(msg + ": " + obj.toString());
    }

    private void printMoney(String msg, Money money) {
        if (msg == null || money == null) {
            return;
        }
        this.cat.info(msg + ": " + money.getAmount() + " " + money.getCurrency());
    }

    private void printWeight(String msg, Weight weight) {
        if (msg == null || weight == null) {
            return;
        }
        this.cat.info(msg + ": " + weight.getValue() + " " + weight.getUnits());
    }

    private void updateEndPoint(RateServiceLocator serviceLocator) {
        String endPoint = this.carrier.getIntegrationEndPoint() + "/rate";
        if (endPoint != null) {
            serviceLocator.setRateServicePortEndpointAddress(endPoint);
        }
    }

    private CommercialInvoice addCommercialInvoice() {
        CommercialInvoice commercialInvoice = new CommercialInvoice();
        commercialInvoice.setPurpose(PurposeOfShipmentType.SOLD);
        return commercialInvoice;
    }

    private CustomsClearanceDetail addCustomsClearanceDetail() {
        CustomsClearanceDetail customs = new CustomsClearanceDetail();
        customs.setCommercialInvoice(this.addCommercialInvoice());
        customs.setCustomsValue(this.addMoney("INR", new DoubleHolder(1.0, 2).getHeldDouble().doubleValue()));
        return customs;
    }

    private Money addMoney(String currency, Double value) {
        Money money = new Money();
        money.setCurrency(currency);
        money.setAmount(new BigDecimal(value));
        return money;
    }
}

