/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.integration.fedex;

import com.fedex.ship.stub.Address;
import com.fedex.ship.stub.AssociatedShipmentDetail;
import com.fedex.ship.stub.ClientDetail;
import com.fedex.ship.stub.CodCollectionType;
import com.fedex.ship.stub.CodDetail;
import com.fedex.ship.stub.CommercialInvoice;
import com.fedex.ship.stub.Commodity;
import com.fedex.ship.stub.CompletedPackageDetail;
import com.fedex.ship.stub.CompletedShipmentDetail;
import com.fedex.ship.stub.Contact;
import com.fedex.ship.stub.ContactAndAddress;
import com.fedex.ship.stub.CustomerReference;
import com.fedex.ship.stub.CustomerReferenceType;
import com.fedex.ship.stub.CustomsClearanceDetail;
import com.fedex.ship.stub.Dimensions;
import com.fedex.ship.stub.DropoffType;
import com.fedex.ship.stub.FreightBaseCharge;
import com.fedex.ship.stub.FreightRateDetail;
import com.fedex.ship.stub.FreightRateNotation;
import com.fedex.ship.stub.InternationalDocumentContentType;
import com.fedex.ship.stub.LabelFormatType;
import com.fedex.ship.stub.LabelSpecification;
import com.fedex.ship.stub.LinearUnits;
import com.fedex.ship.stub.Money;
import com.fedex.ship.stub.Notification;
import com.fedex.ship.stub.NotificationSeverityType;
import com.fedex.ship.stub.PackageOperationalDetail;
import com.fedex.ship.stub.PackageRateDetail;
import com.fedex.ship.stub.PackageRating;
import com.fedex.ship.stub.PackagingType;
import com.fedex.ship.stub.Party;
import com.fedex.ship.stub.Payment;
import com.fedex.ship.stub.PaymentType;
import com.fedex.ship.stub.Payor;
import com.fedex.ship.stub.ProcessShipmentReply;
import com.fedex.ship.stub.ProcessShipmentRequest;
import com.fedex.ship.stub.PurposeOfShipmentType;
import com.fedex.ship.stub.RequestedPackageLineItem;
import com.fedex.ship.stub.RequestedShipment;
import com.fedex.ship.stub.ServiceType;
import com.fedex.ship.stub.ShipPortType;
import com.fedex.ship.stub.ShipServiceLocator;
import com.fedex.ship.stub.ShipmentOperationalDetail;
import com.fedex.ship.stub.ShipmentRateDetail;
import com.fedex.ship.stub.ShipmentRating;
import com.fedex.ship.stub.ShipmentSpecialServiceType;
import com.fedex.ship.stub.ShipmentSpecialServicesRequested;
import com.fedex.ship.stub.ShippingDocument;
import com.fedex.ship.stub.ShippingDocumentImageType;
import com.fedex.ship.stub.ShippingDocumentPart;
import com.fedex.ship.stub.Surcharge;
import com.fedex.ship.stub.TrackingId;
import com.fedex.ship.stub.TransactionDetail;
import com.fedex.ship.stub.VersionId;
import com.fedex.ship.stub.WebAuthenticationCredential;
import com.fedex.ship.stub.WebAuthenticationDetail;
import com.fedex.ship.stub.Weight;
import com.fedex.ship.stub.WeightUnits;
import com.venky.core.log.SWFLogger;
import com.venky.core.math.DoubleHolder;
import com.venky.core.math.DoubleUtils;
import com.venky.core.string.StringUtil;
import com.venky.core.util.Bucket;
import com.venky.core.util.ObjectUtil;
import com.venky.swf.db.Database;
import com.venky.swf.db.JdbcTypeHelper;
import com.venky.swf.db.annotations.column.ui.mimes.MimeType;
import com.venky.swf.routing.Config;
import in.succinct.plugins.ecommerce.db.model.catalog.Item;
import in.succinct.plugins.ecommerce.db.model.catalog.ItemCategory;
import in.succinct.plugins.ecommerce.db.model.catalog.MasterItemCategoryValue;
import in.succinct.plugins.ecommerce.db.model.catalog.UnitOfMeasure;
import in.succinct.plugins.ecommerce.db.model.catalog.UnitOfMeasureConversionTable;
import in.succinct.plugins.ecommerce.db.model.inventory.Sku;
import in.succinct.plugins.ecommerce.db.model.order.Manifest;
import in.succinct.plugins.ecommerce.db.model.order.Order;
import in.succinct.plugins.ecommerce.db.model.order.OrderAddress;
import in.succinct.plugins.ecommerce.db.model.order.OrderAttribute;
import in.succinct.plugins.ecommerce.db.model.order.OrderLine;
import in.succinct.plugins.ecommerce.db.model.order.OrderPrint;
import in.succinct.plugins.ecommerce.db.model.participation.Facility;
import in.succinct.plugins.ecommerce.db.model.participation.PreferredCarrier;
import in.succinct.plugins.ecommerce.integration.fedex.AxisObjectUtil;
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.axis.types.NonNegativeInteger;
import org.apache.axis.types.PositiveInteger;

public class ShipWebServiceClient {
    Order order = null;
    Manifest manifest = null;
    PreferredCarrier carrier = null;
    SWFLogger cat = Config.instance().getLogger(this.getClass().getName());

    public ShipWebServiceClient(Order order) {
        this.order = order;
        this.manifest = this.getManifest(order);
        this.carrier = this.getCourier(this.manifest);
    }

    public void ship() {
        if (!this.carrier.getName().equalsIgnoreCase("FedEx")) {
            return;
        }
        ProcessShipmentRequest request = this.buildRequest();
        try {
            ShipServiceLocator service = new ShipServiceLocator();
            this.updateEndPoint(service);
            ShipPortType port = service.getShipServicePort();
            ProcessShipmentReply reply = port.processShipment(request);
            if (this.isResponseOk(reply.getHighestSeverity())) {
                this.writeServiceOutput(reply);
            }
            this.printNotifications(reply.getNotifications());
        }
        catch (Exception e) {
            this.cat.log(Level.WARNING, e.getMessage(), (Throwable)e);
        }
    }

    public Manifest getManifest(Order order) {
        if (!ObjectUtil.equals((Object)"MANIFESTED", (Object)order.getFulfillmentStatus())) {
            throw new RuntimeException("Order is " + order.getFulfillmentStatus() + " cannot manifest.");
        }
        String manifestId = order.getAttribute("manifest_id").getValue();
        Manifest manifest = (Manifest)Database.getTable(Manifest.class).get(Long.valueOf(manifestId).longValue());
        return manifest;
    }

    private ProcessShipmentRequest buildRequest() {
        ProcessShipmentRequest request = new ProcessShipmentRequest();
        request.setClientDetail(this.createClientDetail());
        request.setWebAuthenticationDetail(this.createWebAuthenticationDetail());
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setCustomerTransactionId(String.valueOf(this.order.getId()));
        request.setTransactionDetail(transactionDetail);
        VersionId versionId = new VersionId("ship", 23, 0, 0);
        request.setVersion(versionId);
        RequestedShipment requestedShipment = new RequestedShipment();
        requestedShipment.setShipTimestamp(Calendar.getInstance());
        requestedShipment.setDropoffType(DropoffType.REGULAR_PICKUP);
        requestedShipment.setServiceType(ServiceType.FEDEX_EXPRESS_SAVER);
        requestedShipment.setPackagingType(PackagingType.YOUR_PACKAGING);
        requestedShipment.setShipper(this.addShipper());
        requestedShipment.setRecipient(this.addRecipient());
        requestedShipment.setShippingChargesPayment(this.addShippingChargesPayment());
        requestedShipment.setCustomsClearanceDetail(this.addCustomsClearanceDetail());
        requestedShipment.setLabelSpecification(this.addLabelSpecification());
        requestedShipment.setPackageCount(new NonNegativeInteger("1"));
        ArrayList<RequestedPackageLineItem> packageLineItems = new ArrayList<RequestedPackageLineItem>();
        OrderLine box = null;
        Bucket weight = new Bucket();
        for (OrderLine ol : this.order.getOrderLines()) {
            ItemCategory bundleCategory = ol.getSku().getItem().getItemCategory("BUNDLE_CATEGORY");
            if (ol.getManifestedQuantity() > 0.0 && bundleCategory != null && bundleCategory.getMasterItemCategoryValue().getAllowedValue().endsWith("Shipping Box")) {
                box = ol;
            }
            Sku sku = ol.getSku();
            double wt = ol.getManifestedQuantity() * UnitOfMeasureConversionTable.convert((double)sku.getWeight(), "Weight", sku.getWeightUOM(), UnitOfMeasure.getWeightMeasure("Kgs"));
            weight.increment(wt);
        }
        if (box != null) {
            packageLineItems.add(this.addRequestedPackageLineItem(box, weight));
        } else {
            packageLineItems.add(this.addRequestedPackageLineItem(null, weight));
        }
        requestedShipment.setRequestedPackageLineItems(packageLineItems.toArray(new RequestedPackageLineItem[0]));
        request.setRequestedShipment(requestedShipment);
        this.cat.warning("Input:\n" + AxisObjectUtil.serializeAxisObject(request));
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeServiceOutput(ProcessShipmentReply reply) throws Exception {
        try {
            this.cat.info("Output:\n" + AxisObjectUtil.serializeAxisObject(reply));
            this.cat.info(reply.getTransactionDetail().getCustomerTransactionId());
            CompletedShipmentDetail csd = reply.getCompletedShipmentDetail();
            String masterTrackingNumber = this.printMasterTrackingNumber(csd);
            Map<String, OrderAttribute> map = this.order.getAttributeMap();
            OrderAttribute attr = map.get("tracking_number");
            attr.setValue(masterTrackingNumber);
            this.printShipmentOperationalDetails(csd.getOperationalDetail());
            this.printShipmentRating(csd.getShipmentRating(), map);
            CompletedPackageDetail[] cpd = csd.getCompletedPackageDetails();
            this.printPackageDetails(cpd);
            this.saveShipmentDocumentsToFile(csd.getShipmentDocuments(), masterTrackingNumber);
            this.getAssociatedShipmentLabels(csd.getAssociatedShipments());
            this.order.saveAttributeMap(map);
        }
        catch (Exception e) {
            this.cat.log(Level.WARNING, e.getMessage(), (Throwable)e);
        }
    }

    private boolean isResponseOk(NotificationSeverityType notificationSeverityType) {
        if (notificationSeverityType == null) {
            return false;
        }
        return notificationSeverityType.equals(NotificationSeverityType.WARNING) || notificationSeverityType.equals(NotificationSeverityType.NOTE) || notificationSeverityType.equals(NotificationSeverityType.SUCCESS);
    }

    private void printNotifications(Notification[] notifications) {
        this.cat.info("Notifications:");
        if (notifications == null || notifications.length == 0) {
            this.cat.info("  No notifications returned");
        }
        for (int i = 0; i < notifications.length; ++i) {
            Notification n = notifications[i];
            this.cat.warning("  Notification no. " + i + ": ");
            if (n == null) continue;
            NotificationSeverityType nst = n.getSeverity();
            this.cat.warning("    Severity: " + (nst == null ? "null" : nst.getValue()));
            this.cat.warning("    Code: " + n.getCode());
            this.cat.warning("    Message: " + n.getMessage());
            this.cat.warning("    Source: " + n.getSource());
        }
    }

    private void printMoney(Money money, String description, String space) {
        if (money != null) {
            this.cat.info(space + description + ": " + money.getAmount() + " " + money.getCurrency());
        }
    }

    private void printWeight(Weight weight, String description, String space) {
        if (weight != null) {
            this.cat.info(space + description + ": " + weight.getValue() + " " + weight.getUnits());
        }
    }

    private Money addMoney(String currency, Double value) {
        Money money = new Money();
        money.setCurrency(currency);
        money.setAmount(new BigDecimal(value));
        return money;
    }

    private Weight addPackageWeight(Double packageWeight, WeightUnits weightUnits) {
        Weight weight = new Weight();
        weight.setUnits(weightUnits);
        weight.setValue(new DoubleHolder(packageWeight.doubleValue(), 3).getHeldDouble());
        this.cat.info("Package Weight  = " + packageWeight);
        return weight;
    }

    private Dimensions addPackageDimensions(Integer length, Integer height, Integer width, LinearUnits linearUnits) {
        Dimensions dimensions = new Dimensions();
        dimensions.setLength(new NonNegativeInteger(length.toString()));
        dimensions.setHeight(new NonNegativeInteger(height.toString()));
        dimensions.setWidth(new NonNegativeInteger(width.toString()));
        dimensions.setUnits(linearUnits);
        return dimensions;
    }

    private void printString(String value, String description, String space) {
        if (value != null) {
            this.cat.info(space + description + ": " + value);
        }
    }

    private void printShipmentOperationalDetails(ShipmentOperationalDetail shipmentOperationalDetail) {
        if (shipmentOperationalDetail != null) {
            this.cat.info("Routing Details");
            this.printString(shipmentOperationalDetail.getUrsaPrefixCode(), "URSA Prefix", "  ");
            if (shipmentOperationalDetail.getCommitDay() != null) {
                this.printString(shipmentOperationalDetail.getCommitDay().getValue(), "Service Commitment", "  ");
            }
            this.printString(shipmentOperationalDetail.getAirportId(), "Airport Id", "  ");
            if (shipmentOperationalDetail.getDeliveryDay() != null) {
                this.printString(shipmentOperationalDetail.getDeliveryDay().getValue(), "Delivery Day", "  ");
            }
        }
    }

    private void printShipmentRating(ShipmentRating shipmentRating, Map<String, OrderAttribute> map) {
        if (shipmentRating != null) {
            this.cat.info("Shipment Rate Details");
            ShipmentRateDetail[] srd = shipmentRating.getShipmentRateDetails();
            for (int j = 0; j < srd.length; ++j) {
                map.get(this.carrier.getName() + "-RateType").setValue(srd[j].getRateType().getValue());
                map.get(this.carrier.getName() + "-BillingWeight").setValue(srd[j].getTotalBillingWeight().getValue().toString());
                Money money = srd[j].getTotalBaseCharge();
                map.get(this.carrier.getName() + "-BaseCharge").setValue(money.getAmount().toString() + " " + money.getCurrency());
                money = srd[j].getTotalNetCharge();
                map.get(this.carrier.getName() + "-NetCharge").setValue(money.getAmount().toString() + " " + money.getCurrency());
                money = srd[j].getTotalSurcharges();
                map.get(this.carrier.getName() + "-TotalSurcharge").setValue(money.getAmount().toString() + " " + money.getCurrency());
                this.cat.info("  Rate Type: " + srd[j].getRateType().getValue());
                this.printWeight(srd[j].getTotalBillingWeight(), "Shipment Billing Weight", "    ");
                this.printMoney(srd[j].getTotalBaseCharge(), "Shipment Base Charge", "    ");
                this.printMoney(srd[j].getTotalNetCharge(), "Shipment Net Charge", "    ");
                this.printMoney(srd[j].getTotalSurcharges(), "Shipment Total Surcharge", "    ");
                if (null != srd[j].getSurcharges()) {
                    this.cat.info("    Surcharge Details");
                    Surcharge[] s = srd[j].getSurcharges();
                    for (int k = 0; k < s.length; ++k) {
                        this.printMoney(s[k].getAmount(), s[k].getSurchargeType().getValue(), "      ");
                    }
                }
                this.printFreightDetail(srd[j].getFreightRateDetail());
            }
        }
    }

    private void printPackageOperationalDetails(PackageOperationalDetail packageOperationalDetail) {
        if (packageOperationalDetail != null) {
            this.cat.info("  Routing Details");
            this.printString(packageOperationalDetail.getAstraHandlingText(), "Astra", "    ");
            this.printString(packageOperationalDetail.getGroundServiceCode(), "Ground Service Code", "    ");
        }
    }

    private void printPackageDetails(CompletedPackageDetail[] cpd) throws Exception {
        if (cpd != null) {
            this.cat.info("Package Details");
            for (int i = 0; i < cpd.length; ++i) {
                String trackingNumber = cpd[i].getTrackingIds()[0].getTrackingNumber();
                this.printTrackingNumbers(cpd[i]);
                this.printPackageRating(cpd[i].getPackageRating());
                ShippingDocument sd = cpd[i].getLabel();
                this.saveLabelToFile(sd, trackingNumber);
                this.printPackageOperationalDetails(cpd[i].getOperationalDetail());
            }
        }
    }

    private void printPackageRating(PackageRating packageRating) {
        if (packageRating != null) {
            this.cat.info("Package Rate Details");
            PackageRateDetail[] prd = packageRating.getPackageRateDetails();
            for (int j = 0; j < prd.length; ++j) {
                this.cat.info("  Rate Type: " + prd[j].getRateType().getValue());
                this.printWeight(prd[j].getBillingWeight(), "Billing Weight", "    ");
                this.printMoney(prd[j].getBaseCharge(), "Base Charge", "    ");
                this.printMoney(prd[j].getNetCharge(), "Net Charge", "    ");
                this.printMoney(prd[j].getTotalSurcharges(), "Total Surcharge", "    ");
                if (null == prd[j].getSurcharges()) continue;
                this.cat.info("    Surcharge Details");
                Surcharge[] s = prd[j].getSurcharges();
                for (int k = 0; k < s.length; ++k) {
                    this.printMoney(s[k].getAmount(), s[k].getSurchargeType().getValue(), "      ");
                }
            }
        }
    }

    private void printTrackingNumbers(CompletedPackageDetail completedPackageDetail) {
        if (completedPackageDetail.getTrackingIds() != null) {
            TrackingId[] trackingId = completedPackageDetail.getTrackingIds();
            for (int i = 0; i < trackingId.length; ++i) {
                String trackNumber = trackingId[i].getTrackingNumber();
                String trackType = trackingId[i].getTrackingIdType().getValue();
                String formId = trackingId[i].getFormId();
                this.printString(trackNumber, trackType + " tracking number", "  ");
                this.printString(formId, "Form Id", "  ");
            }
        }
    }

    private String getPayorAccountNumber() {
        String payorAccountNumber = this.carrier.getAccountNumber();
        if (payorAccountNumber == null) {
            payorAccountNumber = "XXX";
        }
        return payorAccountNumber;
    }

    private Party addShipper() {
        Party shipperParty = new Party();
        Contact shipperContact = new Contact();
        Facility facility = this.manifest.getPreferredCarrier().getFacility();
        shipperContact.setPersonName(facility.getName());
        shipperContact.setCompanyName(facility.getCompany().getName());
        shipperContact.setPhoneNumber(facility.getPhoneNumber());
        Address shipperAddress = new Address();
        StringBuilder addressLine1 = new StringBuilder();
        StringBuilder addressLine2 = new StringBuilder();
        if (!ObjectUtil.isVoid((Object)facility.getAddressLine1())) {
            addressLine1.append(facility.getAddressLine1());
        }
        if (!ObjectUtil.isVoid((Object)facility.getAddressLine2())) {
            if (addressLine1.length() > 0) {
                addressLine1.append(",");
            }
            addressLine1.append(facility.getAddressLine2());
        }
        if (!ObjectUtil.isVoid((Object)facility.getAddressLine3())) {
            addressLine2.append(facility.getAddressLine3());
        }
        if (!ObjectUtil.isVoid((Object)facility.getAddressLine4())) {
            if (addressLine2.length() > 0) {
                addressLine2.append(",");
            }
            addressLine2.append(facility.getAddressLine4());
        }
        shipperAddress.setStreetLines(new String[]{addressLine1.toString(), addressLine2.toString()});
        shipperAddress.setCity(facility.getCity().getName());
        shipperAddress.setStateOrProvinceCode(facility.getState().getCode());
        shipperAddress.setPostalCode(facility.getPinCode().getPinCode());
        shipperAddress.setCountryCode(facility.getCountry().getIsoCode());
        shipperAddress.setCountryName(facility.getCountry().getName());
        shipperAddress.setResidential(false);
        shipperParty.setContact(shipperContact);
        shipperParty.setAddress(shipperAddress);
        return shipperParty;
    }

    private Party addRecipient() {
        Party recipient = new Party();
        List addresses = this.order.getAddresses().stream().filter(oa -> oa.getAddressType().equals("ST")).collect(Collectors.toList());
        if (addresses.isEmpty()) {
            throw new RuntimeException("No Shipto Address found for order  " + this.order.getId());
        }
        OrderAddress shipTo = (OrderAddress)addresses.get(0);
        Contact contactRecip = new Contact();
        contactRecip.setPersonName(StringUtil.valueOf((Object)shipTo.getFirstName()) + " " + StringUtil.valueOf((Object)shipTo.getLastName()));
        contactRecip.setCompanyName("");
        contactRecip.setPhoneNumber(shipTo.getPhoneNumber());
        recipient.setContact(contactRecip);
        Address addressRecip = new Address();
        StringBuilder addressLine1 = new StringBuilder();
        StringBuilder addressLine2 = new StringBuilder();
        if (!ObjectUtil.isVoid((Object)shipTo.getAddressLine1())) {
            addressLine1.append(shipTo.getAddressLine1());
        }
        if (!ObjectUtil.isVoid((Object)shipTo.getAddressLine2())) {
            if (addressLine1.length() > 0) {
                addressLine1.append(",");
            }
            addressLine1.append(shipTo.getAddressLine2());
        }
        if (!ObjectUtil.isVoid((Object)shipTo.getAddressLine3())) {
            addressLine2.append(shipTo.getAddressLine3());
        }
        if (!ObjectUtil.isVoid((Object)shipTo.getAddressLine4())) {
            if (addressLine2.length() > 0) {
                addressLine2.append(",");
            }
            addressLine2.append(shipTo.getAddressLine4());
        }
        addressRecip.setStreetLines(new String[]{addressLine1.toString(), addressLine2.toString()});
        addressRecip.setCity(shipTo.getCity().getName());
        addressRecip.setStateOrProvinceCode(shipTo.getState().getCode());
        addressRecip.setPostalCode(shipTo.getPinCode().getPinCode());
        addressRecip.setCountryCode(shipTo.getCountry().getIsoCode());
        addressRecip.setCountryName(shipTo.getCountry().getName());
        addressRecip.setResidential(new Boolean(true));
        recipient.setAddress(addressRecip);
        return recipient;
    }

    private ContactAndAddress addFinancialInstitutionParty() {
        ContactAndAddress contactAndAddress = new ContactAndAddress();
        Contact contactRecip = new Contact();
        contactRecip.setPersonName("Recipient Name");
        contactRecip.setCompanyName("Recipient Company Name");
        contactRecip.setPhoneNumber("1234567890");
        contactAndAddress.setContact(contactRecip);
        Address addressRecip = new Address();
        addressRecip.setStreetLines(new String[]{"1 RECIPIENT STREET"});
        addressRecip.setCity("NEWDELHI");
        addressRecip.setStateOrProvinceCode("DL");
        addressRecip.setPostalCode("110010");
        addressRecip.setCountryCode("IN");
        addressRecip.setCountryName("INDIA");
        addressRecip.setResidential(new Boolean(false));
        contactAndAddress.setAddress(addressRecip);
        return contactAndAddress;
    }

    private Payment addShippingChargesPayment() {
        Payment payment = new Payment();
        payment.setPaymentType(PaymentType.SENDER);
        Payor payor = new Payor();
        Party responsibleParty = new Party();
        responsibleParty.setAccountNumber(this.getPayorAccountNumber());
        Address responsiblePartyAddress = new Address();
        responsiblePartyAddress.setCountryCode("IN");
        responsibleParty.setAddress(responsiblePartyAddress);
        responsibleParty.setContact(new Contact());
        payor.setResponsibleParty(responsibleParty);
        payment.setPayor(payor);
        return payment;
    }

    private Payment addDutiesPayment() {
        Payment payment = new Payment();
        if (this.carrier.isTaxesPaidBySender()) {
            payment.setPaymentType(PaymentType.SENDER);
        } else {
            payment.setPaymentType(PaymentType.RECIPIENT);
        }
        Payor payor = new Payor();
        Party responsibleParty = this.addShipper();
        payor.setResponsibleParty(responsibleParty);
        responsibleParty.setAccountNumber(this.getPayorAccountNumber());
        payment.setPayor(payor);
        return payment;
    }

    private RequestedPackageLineItem addRequestedPackageLineItem(OrderLine ol, Bucket weight) {
        RequestedPackageLineItem requestedPackageLineItem = new RequestedPackageLineItem();
        requestedPackageLineItem.setSequenceNumber(new PositiveInteger("1"));
        requestedPackageLineItem.setGroupPackageCount(new NonNegativeInteger("1"));
        if (ol != null) {
            Sku sku = ol.getSku();
            double l = Math.ceil(UnitOfMeasureConversionTable.convert((double)sku.getLength(), "Length", sku.getLengthUOM(), UnitOfMeasure.getLengthMeasure("Cms")));
            double w = Math.ceil(UnitOfMeasureConversionTable.convert((double)sku.getWidth(), "Length", sku.getWidthUOM(), UnitOfMeasure.getLengthMeasure("Cms")));
            double h = Math.ceil(ol.getManifestedQuantity() * UnitOfMeasureConversionTable.convert((double)sku.getHeight(), "Length", sku.getHeightUOM(), UnitOfMeasure.getLengthMeasure("Cms")));
            requestedPackageLineItem.setDimensions(this.addPackageDimensions((int)l, (int)h, (int)w, LinearUnits.CM));
        }
        double wt = weight.doubleValue();
        requestedPackageLineItem.setWeight(this.addPackageWeight(wt, WeightUnits.KG));
        requestedPackageLineItem.setCustomerReferences(new CustomerReference[]{this.addCustomerReference(CustomerReferenceType.CUSTOMER_REFERENCE.getValue(), String.valueOf(this.order.getReference())), this.addCustomerReference(CustomerReferenceType.INVOICE_NUMBER.getValue(), this.order.getOrderNumber()), this.addCustomerReference(CustomerReferenceType.P_O_NUMBER.getValue(), "B2C"), this.addCustomerReference(CustomerReferenceType.DEPARTMENT_NUMBER.getValue(), this.carrier.isTaxesPaidBySender() ? "BILL D/T: SENDER" : "BILL D/T: RECEIPIENT")});
        return requestedPackageLineItem;
    }

    private ShipmentSpecialServicesRequested addShipmentSpecialServicesRequested() {
        ShipmentSpecialServicesRequested shipmentSpecialServicesRequested = new ShipmentSpecialServicesRequested();
        ShipmentSpecialServiceType[] shipmentSpecialServiceType = new ShipmentSpecialServiceType[]{ShipmentSpecialServiceType.COD};
        shipmentSpecialServicesRequested.setSpecialServiceTypes(shipmentSpecialServiceType);
        CodDetail codDetail = new CodDetail();
        codDetail.setCollectionType(CodCollectionType.CASH);
        Money codMoney = new Money();
        codMoney.setCurrency("INR");
        codMoney.setAmount(new BigDecimal(400));
        codDetail.setCodCollectionAmount(codMoney);
        codDetail.setFinancialInstitutionContactAndAddress(this.addFinancialInstitutionParty());
        codDetail.setRemitToName("Remitter");
        shipmentSpecialServicesRequested.setCodDetail(codDetail);
        return shipmentSpecialServicesRequested;
    }

    private CustomerReference addCustomerReference(String customerReferenceType, String customerReferenceValue) {
        CustomerReference customerReference = new CustomerReference();
        customerReference.setCustomerReferenceType(CustomerReferenceType.fromString(customerReferenceType));
        customerReference.setValue(customerReferenceValue);
        return customerReference;
    }

    private LabelSpecification addLabelSpecification() {
        LabelSpecification labelSpecification = new LabelSpecification();
        labelSpecification.setImageType(ShippingDocumentImageType.PNG);
        labelSpecification.setLabelFormatType(LabelFormatType.COMMON2D);
        return labelSpecification;
    }

    private CustomsClearanceDetail addCustomsClearanceDetail() {
        JdbcTypeHelper.TypeConverter converter = this.order.getReflector().getJdbcTypeHelper().getTypeRef(Double.class).getTypeConverter();
        this.order.setSellingPrice((Double)converter.valueOf((Object)this.order.getSellingPrice()));
        CustomsClearanceDetail customs = new CustomsClearanceDetail();
        customs.setDutiesPayment(this.addDutiesPayment());
        customs.setCustomsValue(this.addMoney("INR", new DoubleHolder(Math.max(this.order.getSellingPrice(), 1.0), 2).getHeldDouble().doubleValue()));
        customs.setDocumentContent(InternationalDocumentContentType.NON_DOCUMENTS);
        customs.setCommercialInvoice(this.addCommercialInvoice());
        ArrayList commodities = new ArrayList();
        this.order.getOrderLines().forEach(ol -> {
            ol.setSellingPrice((Double)converter.valueOf((Object)ol.getSellingPrice()));
            if (ol.getManifestedQuantity() > 0.0) {
                ItemCategory category = ol.getSku().getItem().getItemCategory("BUNDLE_CATEGORY");
                if (category != null && ObjectUtil.equals((Object)category.getMasterItemCategoryValue().getAllowedValue(), (Object)"Big Shipping Box") && DoubleUtils.equals((double)this.order.getSellingPrice(), (double)0.0)) {
                    commodities.add(this.addCommodity((OrderLine)ol, 1.0));
                    return;
                }
                commodities.add(this.addCommodity((OrderLine)ol, ol.getSellingPrice()));
            }
        });
        if (!commodities.isEmpty()) {
            customs.setCommodities(commodities.toArray(new Commodity[0]));
        }
        return customs;
    }

    private CommercialInvoice addCommercialInvoice() {
        CommercialInvoice commercialInvoice = new CommercialInvoice();
        commercialInvoice.setPurpose(PurposeOfShipmentType.SOLD);
        return commercialInvoice;
    }

    private Commodity addCommodity(OrderLine ol, double price) {
        MasterItemCategoryValue value;
        Commodity commodity = new Commodity();
        commodity.setNumberOfPieces(new NonNegativeInteger("1"));
        Item item = ol.getSku().getItem();
        ItemCategory itemCategory = item.getItemCategory("BUNDLE_CATEGORY");
        if (itemCategory != null && (value = itemCategory.getMasterItemCategoryValue()) != null) {
            commodity.setDescription(value.getAllowedValue());
        }
        if (ObjectUtil.isVoid((Object)commodity.getDescription())) {
            commodity.setDescription(item.getName());
        }
        commodity.setCountryOfManufacture("IN");
        commodity.setWeight(new Weight());
        Bucket wt = new Bucket();
        wt.increment(ol.getManifestedQuantity() * UnitOfMeasureConversionTable.convert((double)((Double)ol.getReflector().getJdbcTypeHelper().getTypeRef(Double.class).getTypeConverter().valueOf((Object)ol.getSku().getWeight())), "Weight", ol.getSku().getWeightUOM().getName(), "Kgs"));
        commodity.getWeight().setValue(new BigDecimal(wt.doubleValue()));
        commodity.getWeight().setUnits(WeightUnits.KG);
        commodity.setQuantity(new BigDecimal(ol.getManifestedQuantity()));
        commodity.setQuantityUnits("EA");
        commodity.setUnitPrice(new Money());
        commodity.getUnitPrice().setAmount(new DoubleHolder(price / ol.getManifestedQuantity(), 2).getHeldDouble());
        commodity.getUnitPrice().setCurrency("INR");
        commodity.setCustomsValue(new Money());
        commodity.getCustomsValue().setAmount(new DoubleHolder(price, 2).getHeldDouble());
        commodity.getCustomsValue().setCurrency("INR");
        commodity.setCountryOfManufacture("IN");
        ItemCategory hsn = ol.getSku().getItem().getItemCategory("HSN");
        if (hsn != null) {
            String hsnCode = hsn.getMasterItemCategoryValue().getAllowedValue();
            commodity.setHarmonizedCode(hsnCode);
        }
        this.cat.info("Commodity Weight " + ol.getId() + " = " + wt.doubleValue());
        return commodity;
    }

    private void printFreightDetail(FreightRateDetail freightRateDetail) {
        if (freightRateDetail != null) {
            this.cat.info("  Freight Details");
            this.printFreightNotations(freightRateDetail);
            this.printFreightBaseCharges(freightRateDetail);
        }
    }

    private void printFreightNotations(FreightRateDetail frd) {
        if (null != frd.getNotations()) {
            this.cat.info("    Notations");
            FreightRateNotation[] notations = frd.getNotations();
            for (int n = 0; n < notations.length; ++n) {
                this.printString(notations[n].getCode(), "Code", "      ");
                this.printString(notations[n].getDescription(), "Notification", "      ");
            }
        }
    }

    private void printFreightBaseCharges(FreightRateDetail frd) {
        if (null != frd.getBaseCharges()) {
            FreightBaseCharge[] baseCharges = frd.getBaseCharges();
            for (int i = 0; i < baseCharges.length; ++i) {
                this.cat.info("    Freight Rate Details");
                this.printString(baseCharges[i].getDescription(), "Description", "      ");
                this.printString(baseCharges[i].getFreightClass().getValue(), "Freight Class", "      ");
                this.printString(baseCharges[i].getRatedAsClass().getValue(), "Rated Class", "      ");
                this.printWeight(baseCharges[i].getWeight(), "Weight", "      ");
                this.printString(baseCharges[i].getChargeBasis().getValue(), "Charge Basis", "      ");
                this.printMoney(baseCharges[i].getChargeRate(), "Charge Rate", "      ");
                this.printMoney(baseCharges[i].getExtendedAmount(), "Extended Amount", "      ");
                this.printString(baseCharges[i].getNmfcCode(), "NMFC Code", "      ");
            }
        }
    }

    private String printMasterTrackingNumber(CompletedShipmentDetail csd) {
        String trackingNumber = "";
        if (null != csd.getMasterTrackingId()) {
            trackingNumber = csd.getMasterTrackingId().getTrackingNumber();
            this.cat.info("Master Tracking Number");
            this.cat.info("  Type: " + csd.getMasterTrackingId().getTrackingIdType());
            this.cat.info("  Tracking Number: " + trackingNumber);
        }
        return trackingNumber;
    }

    private void saveLabelToFile(ShippingDocument shippingDocument, String trackingNumber) throws Exception {
        ShippingDocumentPart[] sdparts = shippingDocument.getParts();
        for (int a = 0; a < sdparts.length; ++a) {
            ShippingDocumentPart sdpart = sdparts[a];
            String shippingDocumentType = shippingDocument.getType().getValue();
            OrderPrint print = (OrderPrint)Database.getTable(OrderPrint.class).newRecord();
            print.setOrderId(this.order.getId());
            print.setDocumentType("CARRIER_LABEL");
            print.setDocumentId(shippingDocumentType);
            print.setImageContentType(MimeType.IMAGE_PNG.toString());
            print.setImageContentName(shippingDocumentType + "." + trackingNumber + ".png");
            print.setImage(new ByteArrayInputStream(sdpart.getImage()));
            print.setImageContentSize(sdpart.getImage().length);
            print.save();
        }
    }

    private void saveShipmentDocumentsToFile(ShippingDocument[] shippingDocument, String trackingNumber) throws Exception {
        if (shippingDocument != null) {
            for (int i = 0; i < shippingDocument.length; ++i) {
                ShippingDocumentPart[] sdparts = shippingDocument[i].getParts();
                for (int a = 0; a < sdparts.length; ++a) {
                    ShippingDocumentPart sdpart = sdparts[a];
                    String labelName = shippingDocument[i].getType().getValue();
                    OrderPrint print = (OrderPrint)Database.getTable(OrderPrint.class).newRecord();
                    print.setOrderId(this.order.getId());
                    print.setDocumentType("CARRIER_LABEL");
                    print.setDocumentId(labelName);
                    print.setImageContentType(MimeType.IMAGE_PNG.toString());
                    print.setImageContentName(labelName + "." + trackingNumber + "_" + a + ".png");
                    print.setImage(new ByteArrayInputStream(sdpart.getImage()));
                    print.setImageContentSize(sdpart.getImage().length);
                    print.save();
                }
            }
        }
    }

    private void getAssociatedShipmentLabels(AssociatedShipmentDetail[] associatedShipmentDetail) throws Exception {
        if (associatedShipmentDetail != null) {
            for (int j = 0; j < associatedShipmentDetail.length; ++j) {
                if (associatedShipmentDetail[j].getLabel() == null || associatedShipmentDetail[j].getType() == null) continue;
                String trackingNumber = associatedShipmentDetail[j].getTrackingId().getTrackingNumber();
                String associatedShipmentType = associatedShipmentDetail[j].getType().getValue();
                ShippingDocument associatedShipmentLabel = associatedShipmentDetail[j].getLabel();
                this.saveAssociatedShipmentLabelToFile(associatedShipmentLabel, trackingNumber, associatedShipmentType);
            }
        }
    }

    private void saveAssociatedShipmentLabelToFile(ShippingDocument shippingDocument, String trackingNumber, String labelName) throws Exception {
        ShippingDocumentPart[] sdparts = shippingDocument.getParts();
        for (int a = 0; a < sdparts.length; ++a) {
            ShippingDocumentPart sdpart = sdparts[a];
            OrderPrint print = (OrderPrint)Database.getTable(OrderPrint.class).newRecord();
            print.setOrderId(this.order.getId());
            print.setDocumentType("CARRIER_LABEL");
            print.setDocumentId(labelName);
            print.setImageContentType(MimeType.IMAGE_PNG.toString());
            print.setImageContentName(labelName + "." + trackingNumber + "_" + a + ".png");
            print.setImage(new ByteArrayInputStream(sdpart.getImage()));
            print.save();
        }
    }

    private PreferredCarrier getCourier(Manifest manifest) {
        return manifest.getPreferredCarrier();
    }

    private ClientDetail createClientDetail() {
        ClientDetail clientDetail = new ClientDetail();
        String accountNumber = this.carrier.getAccountNumber();
        String meterNumber = this.carrier.getMeterNumber();
        clientDetail.setAccountNumber(accountNumber);
        clientDetail.setMeterNumber(meterNumber);
        return clientDetail;
    }

    private WebAuthenticationDetail createWebAuthenticationDetail() {
        WebAuthenticationCredential userCredential = new WebAuthenticationCredential();
        userCredential.setKey(this.carrier.getApiKey());
        userCredential.setPassword(this.carrier.getPassword());
        WebAuthenticationCredential parentCredential = null;
        Boolean useParentCredential = false;
        if (useParentCredential.booleanValue()) {
            String parentKey = System.getProperty("parentkey");
            String parentPassword = System.getProperty("parentpassword");
            if (parentKey == null) {
                parentKey = "XXX";
            }
            if (parentPassword == null) {
                parentPassword = "XXX";
            }
            parentCredential = new WebAuthenticationCredential();
            parentCredential.setKey(parentKey);
            parentCredential.setPassword(parentPassword);
        }
        return new WebAuthenticationDetail(parentCredential, userCredential);
    }

    private void updateEndPoint(ShipServiceLocator serviceLocator) {
        String endPoint = this.carrier.getIntegrationEndPoint() + "/ship";
        if (endPoint != null) {
            serviceLocator.setShipServicePortEndpointAddress(endPoint);
        }
    }

    private class ObjectHolder<T> {
        T value;

        ObjectHolder(T value) {
            this.value = value;
        }
    }
}

